/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.core.model;

import java.net.URI;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Property;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/core#")
@OslcResourceShape(title="OSLC Resource Shape Resource Shape", describes={"http://open-services.net/ns/core#ResourceShape"})
public final class ResourceShape
extends AbstractResource {
    private final SortedSet<URI> describes = new TreeSet<URI>();
    private final TreeMap<URI, Property> properties = new TreeMap();
    private String name;
    private String title;
    private String description;

    public ResourceShape() {
    }

    public ResourceShape(URI about) {
        super(about);
    }

    public void addDescribeItem(URI describeItem) {
        this.describes.add(describeItem);
    }

    public void addProperty(Property property) {
        this.properties.put(property.getPropertyDefinition(), property);
    }

    public Property getProperty(URI definition) {
        return this.properties.get(definition);
    }

    @OslcDescription(value="Type or types of resource described by this shape")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#describes")
    @OslcReadOnly
    @OslcTitle(value="Describes")
    public URI[] getDescribes() {
        return this.describes.toArray(new URI[this.describes.size()]);
    }

    @OslcDescription(value="The properties that are allowed or required by this shape")
    @OslcName(value="property")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#property")
    @OslcRange(value={"http://open-services.net/ns/core#Property"})
    @OslcReadOnly
    @OslcRepresentation(value=Representation.Inline)
    @OslcTitle(value="Properties")
    @OslcValueShape(value="resourceShapes/property")
    @OslcValueType(value=ValueType.LocalResource)
    public Property[] getProperties() {
        return this.properties.values().toArray(new Property[this.properties.size()]);
    }

    @OslcDescription(value="The local name of the defined resource")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#name")
    @OslcReadOnly
    @OslcTitle(value="Name")
    public String getName() {
        return this.name;
    }

    @OslcDescription(value="Title of the resource shape. SHOULD include only content that is valid and suitable inside an XHTML <div> element")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcReadOnly
    @OslcTitle(value="Title")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getTitle() {
        return this.title;
    }

    @OslcDescription(value="The description of the defined constraint.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcReadOnly
    @OslcTitle(value="Description")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getDescription() {
        return this.description;
    }

    public void setDescribes(URI[] describes) {
        this.describes.clear();
        if (describes != null) {
            this.describes.addAll(Arrays.asList(describes));
        }
    }

    public void setProperties(Property[] properties) {
        this.properties.clear();
        if (properties != null) {
            for (Property prop : properties) {
                this.properties.put(prop.getPropertyDefinition(), prop);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

