/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.core.model;

import java.net.URI;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/core#")
@OslcResourceShape(title="OSLC Dialog Resource Shape", describes={"http://open-services.net/ns/core#Dialog"})
public class Dialog
extends AbstractResource {
    private final SortedSet<URI> resourceTypes = new TreeSet<URI>();
    private final SortedSet<URI> usages = new TreeSet<URI>();
    private URI dialog;
    private String hintHeight;
    private String hintWidth;
    private String label;
    private String title;

    public Dialog() {
    }

    public Dialog(String title, URI dialog) {
        this();
        this.title = title;
        this.dialog = dialog;
    }

    public void addResourceType(URI resourceType) {
        this.resourceTypes.add(resourceType);
    }

    public void addUsage(URI usage) {
        this.usages.add(usage);
    }

    @OslcDescription(value="The URI of the dialog")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#dialog")
    @OslcReadOnly
    @OslcTitle(value="Dialog")
    public URI getDialog() {
        return this.dialog;
    }

    @OslcDescription(value="Values MUST be expressed in relative length units as defined in the W3C Cascading Style Sheets Specification (CSS 2.1) Em and ex units are interpreted relative to the default system font (at 100% size)")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#hintHeight")
    @OslcReadOnly
    @OslcTitle(value="Hint Height")
    public String getHintHeight() {
        return this.hintHeight;
    }

    @OslcDescription(value="Values MUST be expressed in relative length units as defined in the W3C Cascading Style Sheets Specification (CSS 2.1) Em and ex units are interpreted relative to the default system font (at 100% size)")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#hintWidth")
    @OslcReadOnly
    @OslcTitle(value="Hint Width")
    public String getHintWidth() {
        return this.hintWidth;
    }

    @OslcDescription(value="Very short label for use in menu items")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#label")
    @OslcReadOnly
    @OslcTitle(value="Label")
    public String getLabel() {
        return this.label;
    }

    @OslcDescription(value="The expected resource type URI for the resources that will be returned when using this dialog. These would be the URIs found in the result resource's rdf:type property")
    @OslcName(value="resourceType")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#resourceType")
    @OslcReadOnly
    @OslcTitle(value="Resource Types")
    public URI[] getResourceTypes() {
        return this.resourceTypes.toArray(new URI[this.resourceTypes.size()]);
    }

    @OslcDescription(value="Title string that could be used for display")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcReadOnly
    @OslcTitle(value="Title")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getTitle() {
        return this.title;
    }

    @OslcDescription(value="An identifier URI for the domain specified usage of this dialog. If a service provides multiple selection or creation dialogs, it may designate the primary or default one that should be used with a property value of http://open-services/ns/core#default")
    @OslcName(value="usage")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#usage")
    @OslcReadOnly
    @OslcTitle(value="Usages")
    public URI[] getUsages() {
        return this.usages.toArray(new URI[this.usages.size()]);
    }

    public void setDialog(URI dialog) {
        this.dialog = dialog;
    }

    public void setHintHeight(String hintHeight) {
        this.hintHeight = hintHeight;
    }

    public void setHintWidth(String hintWidth) {
        this.hintWidth = hintWidth;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setResourceTypes(URI[] resourceTypes) {
        this.resourceTypes.clear();
        if (resourceTypes != null) {
            this.resourceTypes.addAll(Arrays.asList(resourceTypes));
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUsages(URI[] usages) {
        this.usages.clear();
        if (usages != null) {
            this.usages.addAll(Arrays.asList(usages));
        }
    }
}

