/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionEndsCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetPropertyCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.TreeGraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeRouting;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.EdgeCreationDescriptionQuery;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.ReconnectEdgeDescriptionQuery;
import org.eclipse.sirius.diagram.description.CenteringStyle;
import org.eclipse.sirius.diagram.description.CompositeLayout;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.Layout;
import org.eclipse.sirius.diagram.description.OrderedTreeLayout;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ReconnectEdgeDescription;
import org.eclipse.sirius.diagram.description.tool.ReconnectionKind;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionEditPartQuery;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.command.SetReconnectingConnectionBendpointsCommand;
import org.eclipse.sirius.diagram.ui.business.internal.command.SiriusSetConnectionAnchorsCommand;
import org.eclipse.sirius.diagram.ui.business.internal.command.TreeLayoutSetConnectionAnchorsCommand;
import org.eclipse.sirius.diagram.ui.business.internal.helper.CreateConnectionRequestHelper;
import org.eclipse.sirius.diagram.ui.business.internal.query.DEdgeQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.business.internal.view.EdgeLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.RootLayoutData;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramEdgeEditPartOperation;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SetConnectionBendpointsAndLabelCommmand;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.InitialPointsOfRequestDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.api.util.GMFNotationHelper;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.swt.widgets.Display;

public class SiriusGraphicalNodeEditPolicy
extends TreeGraphicalNodeEditPolicy {
    public static final String GMF_EDGE_CREATION_DESCRIPTION = "edge.creation.description";
    public static final String GMF_EDGE_TARGET_SOURCE = "edgeTarget.source";
    public static final String GMF_EDGE_LOCATION_SOURCE = "edge.location.source";
    public static final String GMF_EDGE_SOURCE_TERMINAL = "edge.newSourceTerminal";
    public static final String GMF_EDGE_FEEDBACK = "edge.feedback.figure";
    private static final int WIDTH_FEEDBACK = 2;
    private RectangleFigure highlightFigure;

    protected org.eclipse.gef.commands.Command getReconnectSourceCommand(ReconnectRequest request) {
        Edge edge;
        if (request.getConnectionEditPart().getModel() instanceof Edge && GMFNotationHelper.isNoteAttachment(edge = (Edge)request.getConnectionEditPart().getModel())) {
            return super.getReconnectSourceCommand(request);
        }
        edge = null;
        EdgeTarget target = null;
        org.eclipse.gef.ConnectionEditPart connectionEditPart = request.getConnectionEditPart();
        if (connectionEditPart.getModel() instanceof View && ((View)connectionEditPart.getModel()).getElement() instanceof DEdge) {
            edge = (DEdge)((View)connectionEditPart.getModel()).getElement();
        }
        EdgeTarget source = null;
        if (edge != null) {
            source = edge.getSourceNode();
        }
        if (request.getTarget().getModel() instanceof View && ((View)request.getTarget().getModel()).getElement() instanceof EdgeTarget) {
            target = (EdgeTarget)((View)request.getTarget().getModel()).getElement();
        }
        Object cmd = UnexecutableCommand.INSTANCE;
        if (source != null && target != null) {
            if (target != source) {
                ReconnectEdgeDescription tool;
                Option edgeMapping = new IEdgeMappingQuery(edge.getActualMapping()).getEdgeMapping();
                ReconnectEdgeDescription reconnectEdgeDescription = tool = edgeMapping.some() ? this.getBestTool((EdgeMapping)edgeMapping.get(), true, source, target, (DEdge)edge, true) : null;
                if (tool != null) {
                    CompoundCommand result = new CompoundCommand();
                    result.add(this.getToolCommand(tool, (DEdge)edge, source, target));
                    result.add(this.getReconnectSourceCommandAfterTool(request));
                    cmd = result;
                }
            } else {
                ConnectionEditPartQuery cepq;
                cmd = this.isCenteredEnd(connectionEditPart, (DEdge)edge, CenteringStyle.SOURCE) ? UnexecutableCommand.INSTANCE : (this.applySpecificTreeLayout(request.getConnectionEditPart()) ? this.getReconnectSourceForTreeLayoutCommand(request) : ((cepq = new ConnectionEditPartQuery(request.getConnectionEditPart())).isEdgeWithObliqueRoutingStyle() || cepq.isEdgeWithRectilinearRoutingStyle() ? this.getReconnectSourceOrTargetForObliqueOrRectilinearCommand(request, true) : super.getReconnectSourceCommand(request)));
            }
        }
        return cmd;
    }

    private org.eclipse.gef.commands.Command getReconnectSourceCommandAfterTool(ReconnectRequest request) {
        INodeEditPart node = this.getConnectableEditPart();
        if (node == null) {
            return null;
        }
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        ConnectionAnchor sourceAnchor = node.getSourceConnectionAnchor((Request)request);
        View sourceView = (View)request.getTarget().getModel();
        SiriusSetConnectionAnchorsCommand scaCommand = new SiriusSetConnectionAnchorsCommand(editingDomain, DiagramUIMessages.Commands_SetConnectionEndsCommand_Source, sourceView, (List<Edge>)sourceView.getSourceEdges(), ReconnectionKind.RECONNECT_SOURCE_LITERAL);
        scaCommand.setNewSourceTerminal(node.mapConnectionAnchorToTerminal(sourceAnchor));
        Connection connection = (Connection)request.getConnectionEditPart().getFigure();
        ConnectionAnchor connectionAnchor = connection.getTargetAnchor();
        if (connectionAnchor instanceof BaseSlidableAnchor) {
            String targetTerminal = ((BaseSlidableAnchor)connectionAnchor).getTerminal();
            scaCommand.setNewTargetTerminal(targetTerminal);
        }
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_SetConnectionEndsCommand_Source);
        cc.compose((IUndoableOperation)scaCommand);
        Point tempSourceRefPoint = connection.getSourceAnchor().getReferencePoint();
        connection.translateToRelative((Translatable)tempSourceRefPoint);
        Point tempTargetRefPoint = connection.getTargetAnchor().getReferencePoint();
        connection.translateToRelative((Translatable)tempTargetRefPoint);
        PointList connectionPointList = connection.getPoints().getCopy();
        this.restoreMissingBendpointOverCandidate(request, connectionPointList);
        SetReconnectingConnectionBendpointsCommand sbbCommand = new SetReconnectingConnectionBendpointsCommand(editingDomain, sourceView, (List<Edge>)sourceView.getSourceEdges(), ReconnectionKind.RECONNECT_SOURCE_LITERAL);
        sbbCommand.setNewPointList(connectionPointList, tempSourceRefPoint, tempTargetRefPoint);
        if (request.getConnectionEditPart() instanceof ConnectionEditPart) {
            sbbCommand.setLabelsToUpdate((ConnectionEditPart)request.getConnectionEditPart());
        }
        cc.compose((IUndoableOperation)sbbCommand);
        return new ICommandProxy((ICommand)cc);
    }

    protected org.eclipse.gef.commands.Command getReconnectTargetCommand(ReconnectRequest request) {
        Edge edge;
        if (request.getConnectionEditPart().getModel() instanceof Edge && GMFNotationHelper.isNoteAttachment(edge = (Edge)request.getConnectionEditPart().getModel())) {
            return super.getReconnectTargetCommand(request);
        }
        edge = null;
        EdgeTarget target = null;
        org.eclipse.gef.ConnectionEditPart connectionEditPart = request.getConnectionEditPart();
        if (connectionEditPart.getModel() instanceof View && ((View)connectionEditPart.getModel()).getElement() instanceof DEdge) {
            edge = (DEdge)((View)connectionEditPart.getModel()).getElement();
        }
        EdgeTarget source = null;
        if (edge != null) {
            source = edge.getTargetNode();
        }
        if (request.getTarget().getModel() instanceof View && ((View)request.getTarget().getModel()).getElement() instanceof EdgeTarget) {
            target = (EdgeTarget)((View)request.getTarget().getModel()).getElement();
        }
        Object cmd = UnexecutableCommand.INSTANCE;
        if (source != null && target != null) {
            if (target != source) {
                ReconnectEdgeDescription tool;
                Option edgeMapping = new IEdgeMappingQuery(edge.getActualMapping()).getEdgeMapping();
                ReconnectEdgeDescription reconnectEdgeDescription = tool = edgeMapping.some() ? this.getBestTool((EdgeMapping)edgeMapping.get(), false, source, target, (DEdge)edge, true) : null;
                if (tool != null) {
                    CompoundCommand result = new CompoundCommand();
                    result.add(this.getToolCommand(tool, (DEdge)edge, source, target));
                    result.add(this.getReconnectTargetCommandAfterTool(request));
                    cmd = result;
                }
            } else {
                ConnectionEditPartQuery cepq;
                cmd = this.isCenteredEnd(connectionEditPart, (DEdge)edge, CenteringStyle.TARGET) ? UnexecutableCommand.INSTANCE : ((cepq = new ConnectionEditPartQuery(request.getConnectionEditPart())).isEdgeWithTreeRoutingStyle() && this.applySpecificTreeLayout(request.getConnectionEditPart()) ? this.getReconnectTargetForTreeLayoutCommand(request) : (cepq.isEdgeWithObliqueRoutingStyle() || cepq.isEdgeWithRectilinearRoutingStyle() ? this.getReconnectSourceOrTargetForObliqueOrRectilinearCommand(request, false) : super.getReconnectTargetCommand(request)));
            }
        }
        return cmd;
    }

    private org.eclipse.gef.commands.Command getReconnectSourceOrTargetForObliqueOrRectilinearCommand(ReconnectRequest request, boolean source) {
        INodeEditPart node = this.getConnectableEditPart();
        INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
        if (node == null || targetEP == null) {
            return null;
        }
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        ConnectionAnchor targetAnchor = this.getConnectionTargetAnchor((Request)request);
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
        sceCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)request.getConnectionEditPart().getModel()));
        if (source) {
            sceCommand.setNewSourceAdaptor((IAdaptable)targetEP);
        } else {
            sceCommand.setNewTargetAdaptor((IAdaptable)targetEP);
        }
        SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(editingDomain, "");
        scaCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)request.getConnectionEditPart().getModel()));
        if (source) {
            scaCommand.setNewSourceTerminal(targetEP.mapConnectionAnchorToTerminal(targetAnchor));
        } else {
            scaCommand.setNewTargetTerminal(targetEP.mapConnectionAnchorToTerminal(targetAnchor));
        }
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_SetConnectionEndsCommand_Target);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        Connection connection = (Connection)request.getConnectionEditPart().getFigure();
        Point tempSourceRefPoint = connection.getSourceAnchor().getReferencePoint();
        connection.translateToRelative((Translatable)tempSourceRefPoint);
        Point tempTargetRefPoint = connection.getTargetAnchor().getReferencePoint();
        connection.translateToRelative((Translatable)tempTargetRefPoint);
        PointList connectionPointList = connection.getPoints().getCopy();
        SetConnectionBendpointsAndLabelCommmand sbbCommand = new SetConnectionBendpointsAndLabelCommmand(editingDomain);
        sbbCommand.setEdgeAdapter((IAdaptable)request.getConnectionEditPart());
        sbbCommand.setNewPointList(connectionPointList, tempSourceRefPoint, tempTargetRefPoint);
        if (request.getConnectionEditPart() instanceof ConnectionEditPart) {
            sbbCommand.setLabelsToUpdate((ConnectionEditPart)request.getConnectionEditPart(), InitialPointsOfRequestDataManager.getOriginalPoints((LocationRequest)request));
        }
        cc.compose((IUndoableOperation)sbbCommand);
        return new ICommandProxy((ICommand)cc);
    }

    private boolean isCenteredEnd(org.eclipse.gef.ConnectionEditPart connectionEditPart, DEdge edge, CenteringStyle centeringStyle) {
        boolean returnValue = false;
        EdgeStyle edgeStyle = edge.getOwnedStyle();
        if (edgeStyle != null) {
            IFigure figure;
            boolean bl = returnValue = edgeStyle.getCentered() == CenteringStyle.BOTH || edgeStyle.getCentered() == centeringStyle;
            if (!returnValue && EdgeRouting.MANHATTAN_LITERAL.getLiteral().equals(edgeStyle.getRoutingStyle().getLiteral()) && (figure = connectionEditPart.getFigure()) instanceof Connection) {
                returnValue = ((Connection)figure).getPoints().size() <= 2;
            }
        }
        return returnValue;
    }

    private org.eclipse.gef.commands.Command getReconnectTargetCommandAfterTool(ReconnectRequest request) {
        org.eclipse.gef.commands.Command cmdRouter;
        INodeEditPart node = this.getConnectableEditPart();
        if (node == null || this.getConnectionCompleteEditPart((Request)request) == null) {
            return null;
        }
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        ConnectionAnchor targetAnchor = this.getConnectionTargetAnchor((Request)request);
        INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
        View targetView = (View)targetEP.getModel();
        SiriusSetConnectionAnchorsCommand scaCommand = new SiriusSetConnectionAnchorsCommand(editingDomain, DiagramUIMessages.Commands_SetConnectionEndsCommand_Target, targetView, (List<Edge>)targetView.getTargetEdges(), ReconnectionKind.RECONNECT_TARGET_LITERAL);
        scaCommand.setNewTargetTerminal(targetEP.mapConnectionAnchorToTerminal(targetAnchor));
        org.eclipse.gef.ConnectionEditPart cep = request.getConnectionEditPart();
        Connection connection = (Connection)cep.getFigure();
        ConnectionAnchor connectionAnchor = connection.getSourceAnchor();
        if (connectionAnchor instanceof BaseSlidableAnchor) {
            String sourceTerminal = ((BaseSlidableAnchor)connectionAnchor).getTerminal();
            scaCommand.setNewSourceTerminal(sourceTerminal);
        }
        ICommandProxy cmd = new ICommandProxy((ICommand)scaCommand);
        RoutingStyle style = (RoutingStyle)((View)cep.getModel()).getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
        Routing currentRouter = Routing.MANUAL_LITERAL;
        if (style != null) {
            currentRouter = style.getRouting();
        }
        if ((cmdRouter = this.getRoutingAdjustment((IAdaptable)request.getConnectionEditPart(), this.getSemanticHint((Request)request), currentRouter, request.getTarget())) != null) {
            ICommandProxy cmdBP;
            cmd = cmd.chain(cmdRouter);
            ConnectionAnchor sourceAnchor = node.getSourceConnectionAnchor((Request)request);
            PointList pointList = new PointList();
            pointList.addPoint(sourceAnchor.getLocation(targetAnchor.getReferencePoint()));
            pointList.addPoint(targetAnchor.getLocation(sourceAnchor.getReferencePoint()));
            SetReconnectingConnectionBendpointsCommand sbbCommand = new SetReconnectingConnectionBendpointsCommand(editingDomain, targetView, (List<Edge>)targetView.getTargetEdges(), ReconnectionKind.RECONNECT_TARGET_LITERAL);
            sbbCommand.setNewPointList(pointList, sourceAnchor.getReferencePoint(), targetAnchor.getReferencePoint());
            if (request.getConnectionEditPart() instanceof ConnectionEditPart) {
                sbbCommand.setLabelsToUpdate((ConnectionEditPart)request.getConnectionEditPart());
            }
            if ((cmdBP = new ICommandProxy((ICommand)sbbCommand)) != null) {
                cmd = cmd.chain((org.eclipse.gef.commands.Command)cmdBP);
            }
        } else {
            ICommandProxy cmdBP;
            Point tempSourceRefPoint = connection.getSourceAnchor().getReferencePoint();
            connection.translateToRelative((Translatable)tempSourceRefPoint);
            Point tempTargetRefPoint = connection.getTargetAnchor().getReferencePoint();
            connection.translateToRelative((Translatable)tempTargetRefPoint);
            PointList connectionPointList = connection.getPoints().getCopy();
            this.restoreMissingBendpointOverCandidate(request, connectionPointList);
            SetReconnectingConnectionBendpointsCommand sbbCommand = new SetReconnectingConnectionBendpointsCommand(editingDomain, targetView, (List<Edge>)targetView.getTargetEdges(), ReconnectionKind.RECONNECT_TARGET_LITERAL);
            sbbCommand.setNewPointList(connectionPointList, tempSourceRefPoint, tempTargetRefPoint);
            if (request.getConnectionEditPart() instanceof ConnectionEditPart) {
                sbbCommand.setLabelsToUpdate((ConnectionEditPart)request.getConnectionEditPart());
            }
            if ((cmdBP = new ICommandProxy((ICommand)sbbCommand)) != null) {
                cmd = cmd == null ? cmdBP : cmd.chain((org.eclipse.gef.commands.Command)cmdBP);
            }
        }
        return cmd;
    }

    private void restoreMissingBendpointOverCandidate(ReconnectRequest request, PointList connectionPointList) {
        Edge edge = (Edge)request.getConnectionEditPart().getModel();
        Bendpoints bendpoints = edge.getBendpoints();
        Point sourceEndAnchorLocation = null;
        Point targetEndAnchorLocation = null;
        DEdge dedge = (DEdge)edge.getElement();
        if (!EdgeRouting.STRAIGHT_LITERAL.equals((Object)((EdgeStyle)dedge.getStyle()).getRoutingStyle()) || bendpoints instanceof RelativeBendpoints && connectionPointList.size() == ((RelativeBendpoints)bendpoints).getPoints().size()) {
            return;
        }
        sourceEndAnchorLocation = this.getAnchorLocation(((GraphicalEditPart)request.getConnectionEditPart().getSource()).getFigure().getBounds(), edge.getSourceAnchor());
        targetEndAnchorLocation = this.getAnchorLocation(((GraphicalEditPart)request.getConnectionEditPart().getTarget()).getFigure().getBounds(), edge.getTargetAnchor());
        ArrayList previousBendpoints = Lists.newArrayList();
        if (bendpoints instanceof RelativeBendpoints && sourceEndAnchorLocation != null && targetEndAnchorLocation != null) {
            RelativeBendpoints relativeBendpoints = (RelativeBendpoints)bendpoints;
            List points = relativeBendpoints.getPoints();
            for (RelativeBendpoint rbp : Iterables.filter((Iterable)points, RelativeBendpoint.class)) {
                Point benpointLocationFromTarget;
                Point benpointLocationFromSource = sourceEndAnchorLocation.getTranslated(rbp.getSourceX(), rbp.getSourceY());
                if (!benpointLocationFromSource.equals((Object)(benpointLocationFromTarget = targetEndAnchorLocation.getTranslated(rbp.getTargetX(), rbp.getTargetY())))) {
                    return;
                }
                previousBendpoints.add(benpointLocationFromSource);
            }
        }
        LinkedHashMap pointToAddByIndexMap = Maps.newLinkedHashMap();
        int i = 1;
        while (i <= previousBendpoints.size() - 2) {
            if (connectionPointList.size() > i - pointToAddByIndexMap.keySet().size() && !connectionPointList.getPoint(i - pointToAddByIndexMap.keySet().size()).equals(previousBendpoints.get(i))) {
                pointToAddByIndexMap.put(i, (Point)previousBendpoints.get(i));
            }
            ++i;
        }
        pointToAddByIndexMap.forEach((index, point) -> connectionPointList.insertPoint(point, index.intValue()));
    }

    private Point getAnchorLocation(Rectangle untouchedEndBounds, Anchor previousAnchor) {
        PrecisionPoint result = null;
        PrecisionPoint rel = new PrecisionPoint(0.5, 0.5);
        if (previousAnchor instanceof IdentityAnchor) {
            rel = BaseSlidableAnchor.parseTerminalString((String)((IdentityAnchor)previousAnchor).getId());
        }
        result = new PrecisionPoint((double)untouchedEndBounds.getLocation().x + (double)untouchedEndBounds.width * rel.preciseX(), (double)untouchedEndBounds.getLocation().y + (double)untouchedEndBounds.height * rel.preciseY());
        return result;
    }

    private ReconnectEdgeDescription getBestTool(EdgeMapping mapping, boolean source, EdgeTarget oldTarget, EdgeTarget newTarget, DEdge edge, boolean computePreCondition) {
        ArrayList<ReconnectEdgeDescription> candidateTool = new ArrayList<ReconnectEdgeDescription>((Collection<ReconnectEdgeDescription>)mapping.getReconnections());
        ReconnectEdgeDescription bestTool = null;
        EObject semanticSource = null;
        EObject semanticTarget = null;
        EObject semanticElement = null;
        if (oldTarget instanceof DSemanticDecorator) {
            semanticSource = ((DSemanticDecorator)oldTarget).getTarget();
        }
        if (newTarget instanceof DSemanticDecorator) {
            semanticTarget = ((DSemanticDecorator)newTarget).getTarget();
        }
        semanticElement = edge.getTarget();
        this.selectReconnectionToolCandidates(candidateTool, source);
        if (!candidateTool.isEmpty()) {
            ReconnectEdgeDescription myTool;
            Iterator toolIterator = candidateTool.iterator();
            while (toolIterator.hasNext()) {
                myTool = (ReconnectEdgeDescription)toolIterator.next();
                String precondition = myTool.getPrecondition();
                if (!computePreCondition || precondition == null || StringUtil.isEmpty((String)precondition)) continue;
                IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semanticElement);
                interpreter.setVariable("diagram", (Object)edge.getParentDiagram());
                interpreter.setVariable("source", (Object)semanticSource);
                interpreter.setVariable("sourceView", (Object)oldTarget);
                interpreter.setVariable("target", (Object)semanticTarget);
                interpreter.setVariable("targetView", (Object)newTarget);
                interpreter.setVariable("element", (Object)semanticElement);
                boolean preconditionOK = RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateBoolean(semanticElement, (EObject)myTool, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition());
                if (!preconditionOK) {
                    toolIterator.remove();
                }
                interpreter.unSetVariable("source");
                interpreter.unSetVariable("target");
                interpreter.unSetVariable("element");
                interpreter.unSetVariable("diagram");
                interpreter.unSetVariable("sourceView");
                interpreter.unSetVariable("targetView");
            }
            toolIterator = candidateTool.iterator();
            while (toolIterator.hasNext()) {
                myTool = (ReconnectEdgeDescription)toolIterator.next();
                if (new ReconnectEdgeDescriptionQuery(myTool).isEndAuthorized(source, newTarget)) continue;
                toolIterator.remove();
            }
        }
        if (!candidateTool.isEmpty()) {
            bestTool = (ReconnectEdgeDescription)candidateTool.get(0);
        }
        return bestTool;
    }

    private void selectReconnectionToolCandidates(List<ReconnectEdgeDescription> candidateTool, boolean source) {
        Iterator<ReconnectEdgeDescription> iterTools = candidateTool.iterator();
        while (iterTools.hasNext()) {
            ReconnectEdgeDescription currentTool = iterTools.next();
            if ((!source || currentTool.getReconnectionKind() != ReconnectionKind.RECONNECT_TARGET_LITERAL) && (source || currentTool.getReconnectionKind() != ReconnectionKind.RECONNECT_SOURCE_LITERAL)) continue;
            iterTools.remove();
        }
    }

    private org.eclipse.gef.commands.Command getToolCommand(ReconnectEdgeDescription tool, DEdge edge, EdgeTarget source, EdgeTarget target) {
        final DDiagramEditor diagramEditor = (DDiagramEditor)this.getHost().getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        if (diagramEditor != null) {
            Object adapter = diagramEditor.getAdapter(IDiagramCommandFactoryProvider.class);
            IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)source);
            IDiagramCommandFactory emfCommandFactory = cmdFactoryProvider.getCommandFactory(domain);
            Command reconnectCommand = emfCommandFactory.buildReconnectEdgeCommandFromTool(tool, edge, source, target);
            org.eclipse.emf.common.command.CompoundCommand cc = new org.eclipse.emf.common.command.CompoundCommand(reconnectCommand.getLabel());
            cc.append((Command)new AbstractCommand("Disable fire notification"){

                public void redo() {
                }

                public void execute() {
                    diagramEditor.disableFireNotification();
                }

                protected boolean prepare() {
                    return true;
                }
            });
            cc.append(reconnectCommand);
            return new ICommandProxy((ICommand)new GMFCommandWrapper(domain, (Command)cc));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected org.eclipse.gef.commands.Command getConnectionCreateCommand(CreateConnectionRequest request) {
        org.eclipse.gef.commands.Command connectionCreateCommand = null;
        if (request instanceof CreateConnectionViewRequest) {
            connectionCreateCommand = super.getConnectionCreateCommand(request);
        } else if (CreateConnectionRequestHelper.computeConnectionStartExtendedData(request, this.getConnectableEditPart())) {
            connectionCreateCommand = new ICommandProxy((ICommand)IdentityCommand.INSTANCE);
        }
        if (connectionCreateCommand == null) {
            connectionCreateCommand = super.getConnectionCreateCommand(request);
        }
        return connectionCreateCommand;
    }

    protected org.eclipse.gef.commands.Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        org.eclipse.gef.commands.Command connectionCompleteCommand = null;
        connectionCompleteCommand = new RequestQuery((Request)request).isNoteAttachmentCreationRequest() ? super.getConnectionCompleteCommand(request) : this.buildSiriusConnectionCreationCmd(request);
        return connectionCompleteCommand;
    }

    private org.eclipse.gef.commands.Command buildSiriusConnectionCreationCmd(CreateConnectionRequest request) {
        org.eclipse.gef.commands.Command viewpointConnectionCreationCmd = null;
        INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
        if (targetEP != null) {
            EdgeTarget source;
            View view;
            INodeEditPart sourceEditPart = (INodeEditPart)request.getSourceEditPart();
            Point sourceLocation = this.getEdgeLocationSource(request);
            Point targetLocation = this.getConvertedLocation((CreateRequest)request);
            EdgeLayoutData edgeLayoutData = GraphicalHelper.isSnapToGridEnabled((EditPart)sourceEditPart) ? this.getEdgeLayoutDataWithSnapToGrid(request, sourceEditPart, targetEP, sourceLocation, targetLocation) : this.getEdgeLayoutData(request, sourceEditPart, targetEP, sourceLocation, targetLocation);
            DSemanticDecorator decorateSemanticElement = null;
            if (this.getHost().getModel() instanceof View && (view = (View)this.getHost().getModel()).getElement() instanceof DSemanticDecorator) {
                decorateSemanticElement = (DSemanticDecorator)view.getElement();
            }
            if (decorateSemanticElement instanceof EdgeTarget && request.getExtendedData().get(GMF_EDGE_CREATION_DESCRIPTION) instanceof EdgeCreationDescription && (source = (EdgeTarget)request.getExtendedData().get(GMF_EDGE_TARGET_SOURCE)) != null) {
                EdgeTarget target = (EdgeTarget)decorateSemanticElement;
                EdgeCreationDescription edgeCreationDescription = (EdgeCreationDescription)request.getExtendedData().get(GMF_EDGE_CREATION_DESCRIPTION);
                boolean canCreate = new EdgeCreationDescriptionQuery(edgeCreationDescription).canBeAppliedOn((DMappingBased)source, (DMappingBased)target);
                if (canCreate) {
                    DDiagramEditor diagramEditor = (DDiagramEditor)this.getHost().getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
                    IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)diagramEditor.getAdapter(IDiagramCommandFactoryProvider.class);
                    viewpointConnectionCreationCmd = this.buildCreateEdgeCommand(request, source, target, edgeCreationDescription, cmdFactoryProvider, edgeLayoutData);
                }
            }
        }
        return viewpointConnectionCreationCmd;
    }

    protected EdgeLayoutData getEdgeLayoutData(CreateConnectionRequest request, INodeEditPart sourceEditPart, INodeEditPart targetEditPart, Point sourceLocation, Point targetLocation) {
        String newSourceTerminal = this.getEdgeTerminalSource(request);
        ConnectionAnchor sourceAnchor = sourceEditPart.mapTerminalToConnectionAnchor(newSourceTerminal);
        ConnectionAnchor targetAnchor = targetEditPart.getTargetConnectionAnchor((Request)request);
        String newTargetTerminal = targetEditPart.mapConnectionAnchorToTerminal(targetAnchor);
        Point sourceRefPoint = sourceAnchor.getReferencePoint();
        Point targetRefPoint = targetAnchor.getReferencePoint();
        PointList pointList = new PointList();
        if (request.getLocation() == null) {
            pointList.addPoint(sourceAnchor.getLocation(targetAnchor.getReferencePoint()));
            pointList.addPoint(targetAnchor.getLocation(sourceAnchor.getReferencePoint()));
        } else {
            pointList.addPoint(sourceAnchor.getLocation(request.getLocation()));
            pointList.addPoint(targetAnchor.getLocation(request.getLocation()));
        }
        RootLayoutData sourceLayoutData = new RootLayoutData((EditPart)sourceEditPart, sourceLocation.getCopy(), null);
        RootLayoutData targetLayoutData = new RootLayoutData((EditPart)targetEditPart, targetLocation.getCopy(), null);
        EdgeLayoutData edgeLayoutData = new EdgeLayoutData(sourceLayoutData, targetLayoutData);
        edgeLayoutData.setSourceTerminal(newSourceTerminal);
        edgeLayoutData.setTargetTerminal(newTargetTerminal);
        edgeLayoutData.setPointList(pointList.getCopy());
        edgeLayoutData.setSourceRefPoint(sourceRefPoint.getCopy());
        edgeLayoutData.setTargetRefPoint(targetRefPoint.getCopy());
        return edgeLayoutData;
    }

    protected EdgeLayoutData getEdgeLayoutDataWithSnapToGrid(CreateConnectionRequest request, INodeEditPart sourceEditPart, INodeEditPart targetEditPart, Point sourceLocation, Point targetLocation) {
        IGraphicalEditPart srcEditPart = (IGraphicalEditPart)sourceEditPart;
        IGraphicalEditPart tgtEditPart = (IGraphicalEditPart)targetEditPart;
        Rectangle absoluteSourceBoundsIn100Percent = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)sourceEditPart);
        Point absoluteSourceLocationIn100Percent = sourceLocation.getTranslated(absoluteSourceBoundsIn100Percent.getTopLeft());
        Rectangle absoluteTargetBoundsIn100Percent = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)targetEditPart);
        Point absoluteTargetLocationIn100Percent = targetLocation.getTranslated(absoluteTargetBoundsIn100Percent.getTopLeft());
        Optional intersectionSourcePoint = GraphicalHelper.getIntersection((Point)absoluteSourceLocationIn100Percent, (Point)absoluteTargetLocationIn100Percent, (IGraphicalEditPart)srcEditPart, (boolean)false, (boolean)true);
        Optional intersectionTargetPoint = GraphicalHelper.getIntersection((Point)absoluteSourceLocationIn100Percent, (Point)absoluteTargetLocationIn100Percent, (IGraphicalEditPart)tgtEditPart, (boolean)true, (boolean)true);
        if (intersectionSourcePoint.isPresent() && intersectionTargetPoint.isPresent()) {
            PointList sourceSnappedPoints = this.snapLocationToGridAndToParentBorder(absoluteSourceLocationIn100Percent, absoluteSourceBoundsIn100Percent, (Point)intersectionSourcePoint.get());
            PointList targetSnappedPoints = this.snapLocationToGridAndToParentBorder(absoluteTargetLocationIn100Percent, absoluteTargetBoundsIn100Percent, (Point)intersectionTargetPoint.get());
            EdgeLayoutData edgeLayoutData = this.createEdgeLayoutData(srcEditPart, tgtEditPart, absoluteSourceBoundsIn100Percent, absoluteTargetBoundsIn100Percent, sourceSnappedPoints.getFirstPoint(), targetSnappedPoints.getFirstPoint());
            EdgeLayoutData edgeLayoutData2 = this.createEdgeLayoutData(srcEditPart, tgtEditPart, absoluteSourceBoundsIn100Percent, absoluteTargetBoundsIn100Percent, sourceSnappedPoints.getLastPoint(), targetSnappedPoints.getLastPoint());
            edgeLayoutData.setEdgeLayoutDataForBorderNodes(edgeLayoutData2);
            return edgeLayoutData;
        }
        return this.getEdgeLayoutData(request, sourceEditPart, targetEditPart, sourceLocation, targetLocation);
    }

    private EdgeLayoutData createEdgeLayoutData(IGraphicalEditPart sourceEditPart, IGraphicalEditPart targetEditPart, Rectangle absoluteSourceBoundsIn100Percent, Rectangle absoluteTargetBoundsIn100Percent, Point absoluteSourceLocationSnapIn100Percent, Point absoluteTargetLocationSnapIn100Percent) {
        Point sourceLocationSnapIn100Percent = this.getTranslatedToRelative(absoluteSourceLocationSnapIn100Percent, absoluteSourceBoundsIn100Percent);
        RootLayoutData sourceLayoutData = new RootLayoutData((EditPart)sourceEditPart, sourceLocationSnapIn100Percent, null);
        Point targetLocationSnapIn100Percent = this.getTranslatedToRelative(absoluteTargetLocationSnapIn100Percent, absoluteTargetBoundsIn100Percent);
        RootLayoutData targetLayoutData = new RootLayoutData((EditPart)targetEditPart, targetLocationSnapIn100Percent, null);
        EdgeLayoutData edgeLayoutData = new EdgeLayoutData(sourceLayoutData, targetLayoutData);
        PrecisionPoint sourceTerminalPosition = new PrecisionPoint((double)sourceLocationSnapIn100Percent.x / (double)absoluteSourceBoundsIn100Percent.width, (double)sourceLocationSnapIn100Percent.y / (double)absoluteSourceBoundsIn100Percent.height);
        String sourceTerminal = new SlidableAnchor(null, sourceTerminalPosition).getTerminal();
        edgeLayoutData.setSourceTerminal(sourceTerminal);
        PrecisionPoint targetTerminalPosition = new PrecisionPoint((double)targetLocationSnapIn100Percent.x / (double)absoluteTargetBoundsIn100Percent.width, (double)targetLocationSnapIn100Percent.y / (double)absoluteTargetBoundsIn100Percent.height);
        String targetTerminal = new SlidableAnchor(null, targetTerminalPosition).getTerminal();
        edgeLayoutData.setTargetTerminal(targetTerminal);
        PrecisionPoint absoluteSourceLocationSnap = new PrecisionPoint(absoluteSourceLocationSnapIn100Percent);
        GraphicalHelper.logical2screen((Point)absoluteSourceLocationSnap, (IGraphicalEditPart)sourceEditPart);
        PrecisionPoint absoluteTargteLoactionSnap = new PrecisionPoint(absoluteTargetLocationSnapIn100Percent);
        GraphicalHelper.logical2screen((Point)absoluteTargteLoactionSnap, (IGraphicalEditPart)targetEditPart);
        edgeLayoutData.setSourceRefPoint((Point)absoluteSourceLocationSnap);
        edgeLayoutData.setTargetRefPoint((Point)absoluteTargteLoactionSnap);
        PointList pointList = new PointList();
        pointList.addPoint(absoluteSourceLocationSnap.getCopy());
        pointList.addPoint(absoluteTargteLoactionSnap.getCopy());
        edgeLayoutData.setPointList(pointList.getCopy());
        return edgeLayoutData;
    }

    private PointList snapLocationToGridAndToParentBorder(Point absoluteLocation, Rectangle absoluteParentBounds, Point intersectionPoint) {
        Point absoluteLocationSnapIn100PercentOnNearestSide;
        Point absoluteLocationSnapIn100PercentOnIntersection;
        PointList result = new PointList();
        if (intersectionPoint.x == absoluteParentBounds.x || intersectionPoint.x == absoluteParentBounds.x + absoluteParentBounds.width) {
            int yCoordinate = absoluteLocation.y;
            if (absoluteParentBounds.y > yCoordinate) {
                yCoordinate = absoluteParentBounds.y;
            } else if (yCoordinate > absoluteParentBounds.y + absoluteParentBounds.height) {
                yCoordinate = absoluteParentBounds.y + absoluteParentBounds.height;
            }
            absoluteLocationSnapIn100PercentOnIntersection = new Point(intersectionPoint.x, yCoordinate);
            int cfr_ignored_0 = intersectionPoint.x;
            if (absoluteLocation.x - absoluteParentBounds.x > absoluteParentBounds.getRight().x - absoluteLocation.x) {
                int cfr_ignored_1 = absoluteParentBounds.getRight().x;
            }
            absoluteLocationSnapIn100PercentOnNearestSide = absoluteLocation.getCopy();
        } else {
            int xCoordinate = absoluteLocation.x;
            if (absoluteParentBounds.x > xCoordinate) {
                xCoordinate = absoluteParentBounds.x;
            } else if (xCoordinate > absoluteParentBounds.x + absoluteParentBounds.width) {
                xCoordinate = absoluteParentBounds.x + absoluteParentBounds.width;
            }
            absoluteLocationSnapIn100PercentOnIntersection = new Point(xCoordinate, intersectionPoint.y);
            int cfr_ignored_2 = absoluteLocation.y;
            if (absoluteLocation.y - absoluteParentBounds.y > absoluteParentBounds.getBottom().y - absoluteLocation.y) {
                int cfr_ignored_3 = absoluteParentBounds.getBottom().y;
            }
            absoluteLocationSnapIn100PercentOnNearestSide = absoluteLocation.getCopy();
        }
        result.addPoint(absoluteLocationSnapIn100PercentOnIntersection);
        result.addPoint(absoluteLocationSnapIn100PercentOnNearestSide);
        return result;
    }

    private Point getTranslatedToRelative(Point absoluteLocation, Rectangle absoluteParentBounds) {
        return new Point(absoluteLocation.x - absoluteParentBounds.x, absoluteLocation.y - absoluteParentBounds.y);
    }

    private Point getConvertedLocation(CreateRequest request) {
        return this.getConvertedLocation(request.getLocation().getCopy(), this.getHost(), false);
    }

    private Point getConvertedLocation(Point pointToConvert, EditPart referencePart, boolean feedbackCoordinates) {
        Point realLocation;
        if (pointToConvert != null && referencePart instanceof GraphicalEditPart) {
            IFigure fig = ((GraphicalEditPart)referencePart).getFigure();
            if (feedbackCoordinates) {
                pointToConvert.translate(GraphicalHelper.getScrollSize((GraphicalEditPart)((GraphicalEditPart)referencePart)).negate());
            }
            fig.translateToRelative((Translatable)pointToConvert);
            Point containerLocation = fig.getBounds().getLocation();
            realLocation = new Point(pointToConvert.x - containerLocation.x, pointToConvert.y - containerLocation.y);
            if (fig instanceof ResizableCompartmentFigure) {
                Point scrollOffset = ((ResizableCompartmentFigure)fig).getScrollPane().getViewport().getViewLocation();
                realLocation = new Point(realLocation.x + scrollOffset.x, realLocation.y + scrollOffset.y);
            }
        } else {
            realLocation = pointToConvert;
        }
        return realLocation;
    }

    private String getEdgeTerminalSource(CreateConnectionRequest request) {
        ICommandProxy commandProxy;
        org.eclipse.gef.commands.Command startCommand;
        String edgeTerminalSource = (String)request.getExtendedData().get(GMF_EDGE_SOURCE_TERMINAL);
        if (edgeTerminalSource == null && (startCommand = request.getStartCommand()) instanceof ICommandProxy && (commandProxy = (ICommandProxy)startCommand).getICommand() instanceof CompositeCommand) {
            CompositeCommand compositeCommand = (CompositeCommand)commandProxy.getICommand();
            for (Object cmd : compositeCommand) {
                if (!(cmd instanceof SetConnectionAnchorsCommand)) continue;
                SetConnectionAnchorsCommand setConnectionAnchorsCommand = (SetConnectionAnchorsCommand)cmd;
                edgeTerminalSource = setConnectionAnchorsCommand.getNewSourceTerminal();
            }
        }
        return edgeTerminalSource;
    }

    private Point getEdgeLocationSource(CreateConnectionRequest request) {
        Point edgeLocationSource = (Point)request.getExtendedData().get(GMF_EDGE_LOCATION_SOURCE);
        return edgeLocationSource;
    }

    protected org.eclipse.gef.commands.Command buildCreateEdgeCommand(CreateConnectionRequest request, EdgeTarget source, EdgeTarget target, EdgeCreationDescription edgeCreationDescription, IDiagramCommandFactoryProvider cmdFactoryProvider, EdgeLayoutData edgeLayoutData) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)source);
        CompoundCommand result = new CompoundCommand(edgeCreationDescription.getName());
        this.addStoreLayoutDataCommand(result, edgeLayoutData, request);
        Command emfCommand = cmdFactoryProvider.getCommandFactory(domain).buildCreateEdgeCommandFromTool(source, target, edgeCreationDescription);
        result.add((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)new GMFCommandWrapper(domain, emfCommand)));
        return result;
    }

    protected void addStoreLayoutDataCommand(CompoundCommand result, EdgeLayoutData edgeLayoutData) {
        this.addStoreLayoutDataCommand(result, edgeLayoutData, null);
    }

    protected void addStoreLayoutDataCommand(CompoundCommand result, final EdgeLayoutData edgeLayoutData, final CreateConnectionRequest request) {
        result.add(new org.eclipse.gef.commands.Command(){

            public void execute() {
                Connection connectionFeedback;
                EdgeLayoutData feedbackEdgeLayoutData = null;
                if (request != null && (connectionFeedback = (Connection)request.getExtendedData().get(SiriusGraphicalNodeEditPolicy.GMF_EDGE_FEEDBACK)) != null && connectionFeedback.getPoints().size() == 2 && (connectionFeedback.getPoints().getFirstPoint().x == connectionFeedback.getPoints().getLastPoint().x || connectionFeedback.getPoints().getFirstPoint().y == connectionFeedback.getPoints().getLastPoint().y)) {
                    Point sourceLocationFromFeedback = connectionFeedback.getPoints().getFirstPoint();
                    if ((sourceLocationFromFeedback = SiriusGraphicalNodeEditPolicy.this.getConvertedLocation(sourceLocationFromFeedback, request.getSourceEditPart(), true)) != null) {
                        Point targetLocationFromFeedback = connectionFeedback.getPoints().getLastPoint();
                        targetLocationFromFeedback = SiriusGraphicalNodeEditPolicy.this.getConvertedLocation(targetLocationFromFeedback, request.getTargetEditPart(), true);
                        feedbackEdgeLayoutData = GraphicalHelper.isSnapToGridEnabled((EditPart)request.getSourceEditPart()) ? SiriusGraphicalNodeEditPolicy.this.getEdgeLayoutDataWithSnapToGrid(request, (INodeEditPart)request.getSourceEditPart(), (INodeEditPart)request.getTargetEditPart(), sourceLocationFromFeedback, targetLocationFromFeedback) : SiriusGraphicalNodeEditPolicy.this.getEdgeLayoutData(request, (INodeEditPart)request.getSourceEditPart(), (INodeEditPart)request.getTargetEditPart(), sourceLocationFromFeedback, targetLocationFromFeedback);
                    }
                }
                if (feedbackEdgeLayoutData != null) {
                    SiriusLayoutDataManager.INSTANCE.addData(feedbackEdgeLayoutData);
                } else {
                    SiriusLayoutDataManager.INSTANCE.addData(edgeLayoutData);
                }
            }
        });
    }

    protected org.eclipse.gef.commands.Command getRoutingAdjustment(IAdaptable connection, String connectionHint, Routing currentRouterType, EditPart target) {
        org.eclipse.gef.commands.Command cmd = null;
        if (connectionHint == null || target == null || target.getModel() == null || ((View)target.getModel()).getElement() == null) {
            return null;
        }
        Routing newRouterType = null;
        if (connection instanceof IDiagramEdgeEditPart) {
            TransactionalEditingDomain domain;
            SetPropertyCommand spc;
            ICommandProxy cmdRouter;
            DEdge dEdge;
            DDiagramElement element = ((IDiagramEdgeEditPart)connection).resolveDiagramElement();
            if (element instanceof DEdge && (newRouterType = new DEdgeQuery(dEdge = (DEdge)element).getRouting()) != null && !currentRouterType.equals(newRouterType) && (cmdRouter = new ICommandProxy((ICommand)(spc = new SetPropertyCommand(domain = TransactionUtil.getEditingDomain((EObject)element), connection, Properties.ID_ROUTING, "", (Object)newRouterType)))) != null) {
                cmd = cmdRouter;
            }
        } else {
            cmd = super.getRoutingAdjustment(connection, connectionHint, currentRouterType, target);
        }
        return cmd;
    }

    protected ConnectionAnchor getConnectionTargetAnchor(Request request) {
        INodeEditPart node;
        ReconnectRequest reconnectRequest;
        if (request instanceof ReconnectRequest && (reconnectRequest = (ReconnectRequest)request).getTarget() instanceof DEdgeEditPart && reconnectRequest.getConnectionEditPart() instanceof DEdgeEditPart && (node = this.getConnectableEditPart()) != null) {
            return node.getTargetConnectionAnchor(request);
        }
        return super.getConnectionTargetAnchor(request);
    }

    protected INodeEditPart getConnectionCompleteEditPart(Request request) {
        ReconnectRequest reconnectRequest;
        if (request instanceof ReconnectRequest && (reconnectRequest = (ReconnectRequest)request).getTarget() instanceof DEdgeEditPart && reconnectRequest.getConnectionEditPart() instanceof DEdgeEditPart && this.getHost() instanceof INodeEditPart) {
            return (INodeEditPart)this.getHost();
        }
        return super.getConnectionCompleteEditPart(request);
    }

    protected void showTargetConnectionFeedback(DropRequest request) {
        this.removeHighlight();
        this.addHighlight(request);
    }

    private void addHighlight(DropRequest request) {
        Rectangle bounds = this.getHostFigure().getBounds().getCopy();
        this.getHostFigure().getParent().translateToAbsolute((Translatable)bounds);
        this.getFeedbackLayer().translateToRelative((Translatable)bounds);
        if (this.getHostFigure() instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
            if (this.getHostFigure() != null && Display.getCurrent() != null && this.shouldBeHighlighted(request)) {
                this.getHostFigure().setForegroundColor(Display.getCurrent().getSystemColor(26));
                ((AbstractDiagramEdgeEditPart.ViewEdgeFigure)this.getHostFigure()).setLineWidth(DiagramEdgeEditPartOperation.getLineWidth((IDiagramEdgeEditPart)this.getHost()) + 2);
                for (Object child : this.getHostFigure().getChildren()) {
                    if (!(child instanceof PolylineDecoration)) continue;
                    PolylineDecoration decoration = (PolylineDecoration)child;
                    decoration.setLineWidth(DiagramEdgeEditPartOperation.getLineWidth((IDiagramEdgeEditPart)this.getHost()) + 2);
                }
            }
        } else {
            this.highlightFigure = new RectangleFigure(){

                public void paint(Graphics graphics) {
                    graphics.setAlpha(128);
                    super.paint(graphics);
                }
            };
            this.highlightFigure.setBounds(bounds);
            this.highlightFigure.setBackgroundColor(Display.getCurrent().getSystemColor(26));
            this.addFeedback((IFigure)this.highlightFigure);
        }
    }

    private boolean shouldBeHighlighted(DropRequest request) {
        if (request instanceof ReconnectRequest) {
            Option edgeMapping;
            boolean returnValue = false;
            DEdge dEdge = this.getCurrentDEdge((ReconnectRequest)request);
            if (dEdge != null && (edgeMapping = new IEdgeMappingQuery(dEdge.getActualMapping()).getEdgeMapping()).some()) {
                returnValue = this.canCreateNewEdge(request, dEdge, (EdgeMapping)edgeMapping.get());
            }
            return returnValue;
        }
        return true;
    }

    private boolean canCreateNewEdge(DropRequest request, DEdge dEdge, EdgeMapping actualIEdgeMapping) {
        ReconnectEdgeDescription bestTool = null;
        EdgeTarget reconnectionTarget = this.getTargetElement((ReconnectRequest)request);
        if (reconnectionTarget != null) {
            if ("Reconnection source".equals(((ReconnectRequest)request).getType())) {
                bestTool = this.getBestTool(actualIEdgeMapping, true, dEdge.getSourceNode(), reconnectionTarget, dEdge, false);
            } else if ("Reconnection target".equals(((ReconnectRequest)request).getType())) {
                bestTool = this.getBestTool(actualIEdgeMapping, false, dEdge.getTargetNode(), reconnectionTarget, dEdge, false);
            }
        }
        return bestTool != null;
    }

    private EdgeTarget getTargetElement(ReconnectRequest request) {
        EObject element;
        EditPart target = request.getTarget();
        if (target instanceof IGraphicalEditPart && (element = ((IGraphicalEditPart)target).resolveSemanticElement()) instanceof EdgeTarget) {
            return (EdgeTarget)element;
        }
        return null;
    }

    private DEdge getCurrentDEdge(ReconnectRequest request) {
        EObject semanticElement;
        org.eclipse.gef.ConnectionEditPart connectionEditPart = request.getConnectionEditPart();
        if (connectionEditPart instanceof IGraphicalEditPart && (semanticElement = ((IGraphicalEditPart)connectionEditPart).resolveSemanticElement()) instanceof DEdge) {
            return (DEdge)semanticElement;
        }
        return null;
    }

    protected void eraseTargetConnectionFeedback(DropRequest request) {
        this.removeHighlight();
    }

    public void deactivate() {
        this.removeHighlight();
        super.deactivate();
    }

    private void removeHighlight() {
        if (this.highlightFigure != null) {
            this.removeFeedback((IFigure)this.highlightFigure);
            this.highlightFigure = null;
        }
        if (this.getHostFigure() instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
            ((IDiagramEdgeEditPart)this.getHost()).refreshForegroundColor();
            ((IDiagramEdgeEditPart)this.getHost()).refreshLineStyle();
        }
    }

    private boolean applySpecificTreeLayout(org.eclipse.gef.ConnectionEditPart connectionEditPart) {
        Diagram diagram;
        boolean isLayoutComponent = false;
        if (!this.isSourceOrTargetIsEdge(connectionEditPart) && (diagram = this.getDiagram(connectionEditPart)) != null && diagram.getElement() instanceof DSemanticDiagram) {
            DSemanticDiagram dSemanticDiagram = (DSemanticDiagram)diagram.getElement();
            Layout layout = dSemanticDiagram.getDescription().getLayout();
            isLayoutComponent = this.isOrderedTreeLayoutOrCompositeLayout(layout);
        }
        return isLayoutComponent;
    }

    private boolean isSourceOrTargetIsEdge(org.eclipse.gef.ConnectionEditPart connectionEditPart) {
        return connectionEditPart.getSource() instanceof org.eclipse.gef.ConnectionEditPart || connectionEditPart.getTarget() instanceof org.eclipse.gef.ConnectionEditPart;
    }

    private Diagram getDiagram(org.eclipse.gef.ConnectionEditPart connectionEditPart) {
        DiagramEditPart diagramEditPart;
        DiagramRootEditPart diagramRootEditPart;
        Diagram diagram = null;
        if (connectionEditPart.getParent() instanceof DiagramRootEditPart && (diagramRootEditPart = (DiagramRootEditPart)connectionEditPart.getParent()).getChildren().get(0) instanceof DiagramEditPart && (diagramEditPart = (DiagramEditPart)diagramRootEditPart.getChildren().get(0)).getModel() instanceof Diagram) {
            diagram = (Diagram)diagramEditPart.getModel();
        }
        return diagram;
    }

    private boolean isOrderedTreeLayoutOrCompositeLayout(Layout layout) {
        return layout instanceof OrderedTreeLayout || layout instanceof CompositeLayout;
    }

    private org.eclipse.gef.commands.Command getReconnectTargetForTreeLayoutCommand(ReconnectRequest request) {
        INodeEditPart node = this.getConnectableEditPart();
        ICommandProxy cmd = null;
        if (node != null) {
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            ConnectionAnchor targetAnchor = this.getConnectionTargetAnchor((Request)request);
            INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
            if (targetEP != null) {
                SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
                sceCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)request.getConnectionEditPart().getModel()));
                sceCommand.setNewTargetAdaptor((IAdaptable)targetEP);
                TreeLayoutSetConnectionAnchorsCommand scaCommand = new TreeLayoutSetConnectionAnchorsCommand(editingDomain, "");
                scaCommand.setEdgeAdaptor((IAdaptable)request.getConnectionEditPart());
                scaCommand.setNewTargetTerminal(targetEP.mapConnectionAnchorToTerminal(targetAnchor));
                CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_SetConnectionEndsCommand_Target);
                cc.compose((IUndoableOperation)sceCommand);
                cc.compose((IUndoableOperation)scaCommand);
                cmd = new ICommandProxy((ICommand)cc);
            }
        }
        return cmd;
    }

    private org.eclipse.gef.commands.Command getReconnectSourceForTreeLayoutCommand(ReconnectRequest request) {
        INodeEditPart node = this.getConnectableEditPart();
        if (node == null) {
            return null;
        }
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        ConnectionAnchor sourceAnchor = node.getSourceConnectionAnchor((Request)request);
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
        sceCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)request.getConnectionEditPart().getModel())));
        sceCommand.setNewSourceAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)node.getModel())));
        TreeLayoutSetConnectionAnchorsCommand scaCommand = new TreeLayoutSetConnectionAnchorsCommand(editingDomain, "");
        scaCommand.setEdgeAdaptor((IAdaptable)request.getConnectionEditPart());
        scaCommand.setNewSourceTerminal(node.mapConnectionAnchorToTerminal(sourceAnchor));
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_SetConnectionEndsCommand_Source);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        return new ICommandProxy((ICommand)cc);
    }

    protected void showCreationFeedback(CreateConnectionRequest request) {
        super.showCreationFeedback(request);
        request.getExtendedData().put(GMF_EDGE_FEEDBACK, this.connectionFeedback);
    }
}

