/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.util.Bag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BagImpl<E>
extends AbstractCollection<E>
implements Bag<E> {
    public static Bag<?> EMPTY_BAG = new BagImpl();
    private Map<E, MutableInteger> coll = new HashMap<E, MutableInteger>();
    private int size = 0;

    public BagImpl() {
    }

    public BagImpl(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    public static <E> Bag<E> emptyBag() {
        return EMPTY_BAG;
    }

    @Override
    public boolean remove(Object o) {
        MutableInteger count = this.coll.remove(o);
        if (count != null) {
            this.size -= count.i;
        }
        return count != null;
    }

    @Override
    public boolean add(E o) {
        MutableInteger count = this.coll.get(o);
        if (count == null) {
            this.coll.put(o, new MutableInteger(1));
        } else {
            ++count.i;
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return this.count(o) > 0;
    }

    @Override
    public int count(Object o) {
        MutableInteger count = this.coll.get(o);
        if (count != null) {
            return count.i;
        }
        return 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.coll.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BagImpl) {
            BagImpl b = (BagImpl)o;
            if (this.size() == b.size()) {
                for (E obj : this) {
                    MutableInteger count = this.coll.get(obj);
                    MutableInteger otherCount = b.coll.get(obj);
                    if (otherCount != null && otherCount.i == count.i) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 37;
        result = 37 * result + this.coll.hashCode();
        result = 37 * result + this.size;
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyIterator
        implements Iterator<E> {
            private Iterator<E> it;
            private int offset;
            private E curr;
            private boolean currInitialized;

            public MyIterator() {
                this.it = BagImpl.this.coll.keySet().iterator();
                this.offset = 0;
                this.curr = null;
                this.currInitialized = false;
            }

            @Override
            public boolean hasNext() {
                if (this.it.hasNext()) {
                    return true;
                }
                MutableInteger count = (MutableInteger)BagImpl.this.coll.get(this.curr);
                return this.currInitialized && this.offset < count.i - 1;
            }

            @Override
            public E next() {
                MutableInteger count;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.currInitialized && (count = (MutableInteger)BagImpl.this.coll.get(this.curr)) != null && this.offset < count.i - 1) {
                    ++this.offset;
                    return this.curr;
                }
                this.curr = this.it.next();
                this.currInitialized = true;
                this.offset = 0;
                return this.curr;
            }

            @Override
            public void remove() {
                UnsupportedOperationException error = new UnsupportedOperationException(OCLMessages.RemoveUnsupported_ERROR_);
                OCLPlugin.throwing(this.getClass(), "remove", error);
                throw error;
            }
        }
        return new MyIterator();
    }

    @Override
    public String toString() {
        return this.coll.toString();
    }

    private static class MutableInteger {
        public int i;

        public MutableInteger(int i) {
            this.i = i;
        }

        public String toString() {
            return Integer.toString(this.i);
        }
    }
}

