/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.quickfix;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.part.ValidateAction;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public abstract class AbstractValidationFix
implements IMarkerResolution {
    public void run(IMarker marker) {
        IResource airdFile = marker.getResource();
        if (airdFile instanceof IFile) {
            try {
                this.tryToOpenEditorAndApplyFix(airdFile, marker);
            }
            catch (PartInitException e) {
                SiriusPlugin.getDefault().error(MessageFormat.format(Messages.ValidationFixResolution_editorOpeningError, airdFile), (Throwable)e);
            }
        }
    }

    private void tryToOpenEditorAndApplyFix(IResource airdFile, IMarker marker) throws PartInitException {
        IEditorPart editor;
        block11: {
            IFile markerFile = (IFile)marker.getResource();
            editor = null;
            try {
                String markerEditorID = (String)marker.getAttribute("org.eclipse.ui.editorID");
                if (markerFile == null || markerEditorID == null) break block11;
                List collect = Arrays.asList(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences()).stream().map(editorReference -> editorReference.getEditor(true)).collect(Collectors.toList());
                for (IEditorPart iEditorPart : collect) {
                    IEditorInput editorInput;
                    String editorId = iEditorPart.getEditorSite().getId();
                    if (!markerEditorID.equals(editorId) || !((editorInput = iEditorPart.getEditorInput()) instanceof SessionEditorInput)) continue;
                    String fileString = ((SessionEditorInput)editorInput).getSession().getSessionResource().getURI().toPlatformString(true);
                    IResource editorIFile = ResourcesPlugin.getWorkspace().getRoot().findMember(fileString);
                    if (!markerFile.equals((Object)editorIFile)) continue;
                    editor = iEditorPart;
                    break;
                }
            }
            catch (CoreException coreException) {}
        }
        if (editor == null) {
            editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IMarker)marker);
        } else {
            IDE.gotoMarker(editor, (IMarker)marker);
        }
        if (editor != null) {
            View markedView;
            Session currentSession = null;
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput instanceof SessionEditorInput) {
                Session editorInputSession = ((SessionEditorInput)editorInput).getSession();
                if (editorInputSession != null && editorInputSession.isOpen()) {
                    currentSession = editorInputSession;
                } else {
                    URI markedResource = URI.createPlatformResourceURI((String)airdFile.getFullPath().toString(), (boolean)true);
                    Session existingSession = SessionManager.INSTANCE.getExistingSession(markedResource);
                    if (existingSession == null || !existingSession.isOpen()) {
                        return;
                    }
                    currentSession = existingSession;
                }
            }
            if ((markedView = this.getMarkedView(currentSession, marker)) != null) {
                this.doExecuteFix(marker, editor, markedView, currentSession.getTransactionalEditingDomain());
            }
        }
    }

    protected abstract void doExecuteFix(IMarker var1, IEditorPart var2, View var3, TransactionalEditingDomain var4);

    protected View getMarkedView(Session session, IMarker marker) {
        String elementID = marker.getAttribute("elementId", null);
        String diagramDescriptorURI = marker.getAttribute("DIAGRAM_DESCRIPTOR_URI", null);
        if (diagramDescriptorURI == null || elementID == null) {
            return null;
        }
        ResourceSet set = session.getTransactionalEditingDomain().getResourceSet();
        if (set != null) {
            EObject markerTarget;
            EObject markedDiagramDescriptor = set.getEObject(URI.createURI((String)diagramDescriptorURI), true);
            EObject markedDiagram = Optional.ofNullable(markedDiagramDescriptor).filter(DRepresentationDescriptor.class::isInstance).map(d -> ((DRepresentationDescriptor)d).getRepresentation()).orElse(null);
            EObject eObject = markerTarget = markedDiagram instanceof DDiagram ? markedDiagram.eResource().getEObject(elementID) : null;
            if (markerTarget instanceof View) {
                return (View)markerTarget;
            }
        }
        return null;
    }

    protected void revalidate(IEditorPart editor, View view) {
        if (org.eclipse.sirius.viewpoint.provider.Messages.SessionEditorInput_defaultEditorName.equals(editor.getTitle()) || !(editor instanceof DialectEditor)) {
            ValidateAction.runNonUIValidation(view);
        } else {
            ((DialectEditor)editor).validateRepresentation();
        }
    }
}

