/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.InlineMethodDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.code.CallInliner;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.code.SourceProvider;
import org.eclipse.jdt.internal.corext.refactoring.code.TargetProvider;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class InlineMethodRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_MODE = "mode";
    private static final String ATTRIBUTE_DELETE = "delete";
    private ITypeRoot fInitialTypeRoot;
    private ASTNode fInitialNode;
    private TextChangeManager fChangeManager;
    private SourceProvider fSourceProvider;
    private TargetProvider fTargetProvider;
    private boolean fDeleteSource;
    private Mode fCurrentMode;
    private Mode fInitialMode;
    private int fSelectionStart;
    private int fSelectionLength;

    private InlineMethodRefactoring(ITypeRoot typeRoot, ASTNode node, int offset, int length) {
        Assert.isNotNull((Object)typeRoot);
        Assert.isTrue((boolean)JavaElementUtil.isSourceAvailable((ISourceReference)typeRoot));
        Assert.isNotNull((Object)node);
        this.fInitialTypeRoot = typeRoot;
        this.fInitialNode = node;
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
    }

    private InlineMethodRefactoring(ICompilationUnit unit, MethodInvocation node, int offset, int length) {
        this((ITypeRoot)unit, (ASTNode)node, offset, length);
        this.fTargetProvider = TargetProvider.create(unit, node);
        this.fInitialMode = this.fCurrentMode = Mode.INLINE_SINGLE;
        this.fDeleteSource = false;
    }

    private InlineMethodRefactoring(ICompilationUnit unit, SuperMethodInvocation node, int offset, int length) {
        this((ITypeRoot)unit, (ASTNode)node, offset, length);
        this.fTargetProvider = TargetProvider.create(unit, node);
        this.fInitialMode = this.fCurrentMode = Mode.INLINE_SINGLE;
        this.fDeleteSource = false;
    }

    private InlineMethodRefactoring(ICompilationUnit unit, ConstructorInvocation node, int offset, int length) {
        this((ITypeRoot)unit, (ASTNode)node, offset, length);
        this.fTargetProvider = TargetProvider.create(unit, node);
        this.fInitialMode = this.fCurrentMode = Mode.INLINE_SINGLE;
        this.fDeleteSource = false;
    }

    private InlineMethodRefactoring(ITypeRoot typeRoot, MethodDeclaration node, int offset, int length) {
        this(typeRoot, (ASTNode)node, offset, length);
        this.fSourceProvider = new SourceProvider(typeRoot, node);
        this.fTargetProvider = TargetProvider.create(node);
        this.fInitialMode = this.fCurrentMode = Mode.INLINE_ALL;
        this.fDeleteSource = this.canEnableDeleteSource();
    }

    public static InlineMethodRefactoring create(ITypeRoot unit, CompilationUnit node, int selectionStart, int selectionLength) {
        ASTNode target = RefactoringAvailabilityTester.getInlineableMethodNode(unit, node, selectionStart, selectionLength);
        if (target == null) {
            return null;
        }
        if (target.getNodeType() == 31) {
            return new InlineMethodRefactoring(unit, (MethodDeclaration)target, selectionStart, selectionLength);
        }
        ICompilationUnit cu = (ICompilationUnit)unit;
        if (target.getNodeType() == 32) {
            return new InlineMethodRefactoring(cu, (MethodInvocation)target, selectionStart, selectionLength);
        }
        if (target.getNodeType() == 48) {
            return new InlineMethodRefactoring(cu, (SuperMethodInvocation)target, selectionStart, selectionLength);
        }
        if (target.getNodeType() == 17) {
            return new InlineMethodRefactoring(cu, (ConstructorInvocation)target, selectionStart, selectionLength);
        }
        return null;
    }

    public String getName() {
        return RefactoringCoreMessages.InlineMethodRefactoring_name;
    }

    public IMethod getMethod() {
        if (this.fSourceProvider == null) {
            return null;
        }
        IMethodBinding binding = this.fSourceProvider.getDeclaration().resolveBinding();
        if (binding == null) {
            return null;
        }
        return (IMethod)binding.getJavaElement();
    }

    public boolean canEnableDeleteSource() {
        return !(this.fSourceProvider.getTypeRoot() instanceof IClassFile);
    }

    public boolean getDeleteSource() {
        return this.fDeleteSource;
    }

    public void setDeleteSource(boolean remove) {
        if (remove) {
            Assert.isTrue((boolean)this.canEnableDeleteSource());
        }
        this.fDeleteSource = remove;
    }

    public Mode getInitialMode() {
        return this.fInitialMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus setCurrentMode(Mode mode) throws JavaModelException {
        if (this.fCurrentMode == mode) {
            return new RefactoringStatus();
        }
        Assert.isTrue((this.getInitialMode() == Mode.INLINE_SINGLE ? 1 : 0) != 0);
        this.fCurrentMode = mode;
        if (mode == Mode.INLINE_SINGLE) {
            if (this.fInitialNode instanceof MethodInvocation) {
                this.fTargetProvider = TargetProvider.create((ICompilationUnit)this.fInitialTypeRoot, (MethodInvocation)this.fInitialNode);
                return this.fTargetProvider.checkActivation();
            } else if (this.fInitialNode instanceof SuperMethodInvocation) {
                this.fTargetProvider = TargetProvider.create((ICompilationUnit)this.fInitialTypeRoot, (SuperMethodInvocation)this.fInitialNode);
                return this.fTargetProvider.checkActivation();
            } else {
                if (!(this.fInitialNode instanceof ConstructorInvocation)) throw new IllegalStateException(String.valueOf(this.fInitialNode));
                this.fTargetProvider = TargetProvider.create((ICompilationUnit)this.fInitialTypeRoot, (ConstructorInvocation)this.fInitialNode);
            }
            return this.fTargetProvider.checkActivation();
        } else {
            this.fTargetProvider = TargetProvider.create(this.fSourceProvider.getDeclaration());
        }
        return this.fTargetProvider.checkActivation();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.fSourceProvider == null && Invocations.isInvocation(this.fInitialNode)) {
            this.fSourceProvider = InlineMethodRefactoring.resolveSourceProvider(result, this.fInitialTypeRoot, this.fInitialNode);
            if (result.hasFatalError()) {
                return result;
            }
        }
        result.merge(this.fSourceProvider.checkActivation());
        result.merge(this.fTargetProvider.checkActivation());
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 20);
        this.fChangeManager = new TextChangeManager();
        RefactoringStatus result = new RefactoringStatus();
        this.fSourceProvider.initialize();
        this.fTargetProvider.initialize();
        pm.setTaskName(RefactoringCoreMessages.InlineMethodRefactoring_searching);
        RefactoringStatus searchStatus = new RefactoringStatus();
        String binaryRefsDescription = Messages.format(RefactoringCoreMessages.ReferencesInBinaryContext_ref_in_binaries_description, BasicElementLabels.getJavaElementName((String)this.fSourceProvider.getMethodName()));
        ReferencesInBinaryContext binaryRefs = new ReferencesInBinaryContext(binaryRefsDescription);
        ICompilationUnit[] units = this.fTargetProvider.getAffectedCompilationUnits(searchStatus, binaryRefs, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        binaryRefs.addErrorIfNecessary(searchStatus);
        if (searchStatus.hasFatalError()) {
            result.merge(searchStatus);
            return result;
        }
        IFile[] filesToBeModified = this.getFilesToBeModified(units);
        result.merge(Checks.validateModifiesFiles(filesToBeModified, this.getValidationContext()));
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(ResourceChangeChecker.checkFilesToBeChanged((IFile[])filesToBeModified, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        this.checkOverridden(result, (IProgressMonitor)new SubProgressMonitor(pm, 4));
        SubProgressMonitor sub = new SubProgressMonitor(pm, 15);
        sub.beginTask("", units.length * 3);
        int c = 0;
        while (c < units.length) {
            block17: {
                ICompilationUnit unit = units[c];
                sub.subTask(Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_processing, BasicElementLabels.getFileName((ITypeRoot)unit)));
                CallInliner inliner = null;
                try {
                    boolean added = false;
                    MultiTextEdit root = new MultiTextEdit();
                    CompilationUnitChange change = (CompilationUnitChange)this.fChangeManager.get(unit);
                    change.setEdit((TextEdit)root);
                    BodyDeclaration[] bodies = this.fTargetProvider.getAffectedBodyDeclarations(unit, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    if (bodies.length == 0) break block17;
                    inliner = new CallInliner(unit, (CompilationUnit)bodies[0].getRoot(), this.fSourceProvider);
                    int b = 0;
                    while (b < bodies.length) {
                        BodyDeclaration body = bodies[b];
                        inliner.initialize(body);
                        RefactoringStatus nestedInvocations = new RefactoringStatus();
                        ASTNode[] invocations = this.removeNestedCalls(nestedInvocations, unit, this.fTargetProvider.getInvocations(body, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sub, 2)));
                        int i = 0;
                        while (i < invocations.length) {
                            ASTNode invocation = invocations[i];
                            result.merge(inliner.initialize(invocation, this.fTargetProvider.getStatusSeverity()));
                            if (result.hasFatalError()) break;
                            if (result.getSeverity() < this.fTargetProvider.getStatusSeverity()) {
                                added = true;
                                TextEditGroup group = new TextEditGroup(RefactoringCoreMessages.InlineMethodRefactoring_edit_inline);
                                change.addTextEditGroup(group);
                                result.merge(inliner.perform(group));
                            } else {
                                this.fDeleteSource = false;
                            }
                            ++i;
                        }
                        if (!nestedInvocations.isOK()) {
                            result.merge(nestedInvocations);
                            this.fDeleteSource = false;
                        }
                        ++b;
                    }
                    if (!added) {
                        this.fChangeManager.remove(unit);
                    } else {
                        TextEdit edit;
                        root.addChild(inliner.getModifications());
                        ImportRewrite rewrite = inliner.getImportEdit();
                        if (rewrite.hasRecordedChanges() && (!((edit = rewrite.rewriteImports(null)) instanceof MultiTextEdit) || ((MultiTextEdit)edit).getChildrenSize() > 0)) {
                            root.addChild(edit);
                            change.addTextEditGroup(new TextEditGroup(RefactoringCoreMessages.InlineMethodRefactoring_edit_import, new TextEdit[]{edit}));
                        }
                    }
                }
                finally {
                    if (inliner != null) {
                        inliner.dispose();
                    }
                }
                sub.worked(1);
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++c;
        }
        result.merge(searchStatus);
        sub.done();
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (this.fDeleteSource && this.fCurrentMode == Mode.INLINE_ALL) {
            TextChange change = this.fChangeManager.get((ICompilationUnit)this.fSourceProvider.getTypeRoot());
            TextEdit delete = this.fSourceProvider.getDeleteEdit();
            TextEditGroup description = new TextEditGroup(RefactoringCoreMessages.InlineMethodRefactoring_edit_delete, new TextEdit[]{delete});
            TextEdit root = change.getEdit();
            if (root != null) {
                TextChangeCompatibility.insert((TextEdit)root, (TextEdit)delete);
            } else {
                change.setEdit(delete);
            }
            change.addTextEditGroup(description);
        }
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fInitialTypeRoot.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        int flags = 786434;
        IMethodBinding binding = this.fSourceProvider.getDeclaration().resolveBinding();
        ITypeBinding declaring = binding.getDeclaringClass();
        if (!Modifier.isPrivate((int)binding.getModifiers())) {
            flags |= 4;
        }
        String description = Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName((String)binding.getName()));
        String header = Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_descriptor_description, new String[]{BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_FULLY_QUALIFIED), BindingLabelProvider.getBindingLabel((IBinding)declaring, JavaElementLabels.ALL_FULLY_QUALIFIED)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_original_pattern, BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        if (this.fDeleteSource) {
            comment.addSetting(RefactoringCoreMessages.InlineMethodRefactoring_remove_method);
        }
        if (this.fCurrentMode == Mode.INLINE_ALL) {
            comment.addSetting(RefactoringCoreMessages.InlineMethodRefactoring_replace_references);
        }
        InlineMethodDescriptor descriptor = RefactoringSignatureDescriptorFactory.createInlineMethodDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)flags);
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fInitialTypeRoot));
        arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        arguments.put(ATTRIBUTE_DELETE, Boolean.valueOf(this.fDeleteSource).toString());
        arguments.put(ATTRIBUTE_MODE, new Integer(this.fCurrentMode == Mode.INLINE_ALL ? 1 : 0).toString());
        return new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)descriptor, RefactoringCoreMessages.InlineMethodRefactoring_edit_inlineCall, (Change[])this.fChangeManager.getAllChanges());
    }

    private static SourceProvider resolveSourceProvider(RefactoringStatus status, ITypeRoot typeRoot, ASTNode invocation) {
        CompilationUnit root = (CompilationUnit)invocation.getRoot();
        IMethodBinding methodBinding = Invocations.resolveBinding(invocation);
        if (methodBinding == null) {
            status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_error_noMethodDeclaration);
            return null;
        }
        MethodDeclaration declaration = (MethodDeclaration)root.findDeclaringNode((IBinding)methodBinding);
        if (declaration != null) {
            return new SourceProvider(typeRoot, declaration);
        }
        IMethod method = (IMethod)methodBinding.getJavaElement();
        if (method != null) {
            CompilationUnit methodDeclarationAstRoot;
            ICompilationUnit methodCu = method.getCompilationUnit();
            if (methodCu != null) {
                methodDeclarationAstRoot = new RefactoringASTParser(10).parse((ITypeRoot)methodCu, true);
            } else {
                IClassFile classFile = method.getClassFile();
                if (!JavaElementUtil.isSourceAvailable((ISourceReference)classFile)) {
                    String methodLabel = JavaElementLabels.getTextLabel(method, 129L);
                    status.addFatalError(Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_error_classFile, methodLabel));
                    return null;
                }
                methodDeclarationAstRoot = new RefactoringASTParser(10).parse((ITypeRoot)classFile, true);
            }
            ASTNode node = methodDeclarationAstRoot.findDeclaringNode(methodBinding.getMethodDeclaration().getKey());
            if (node instanceof MethodDeclaration) {
                return new SourceProvider(methodDeclarationAstRoot.getTypeRoot(), (MethodDeclaration)node);
            }
        }
        status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_error_noMethodDeclaration);
        return null;
    }

    private IFile[] getFilesToBeModified(ICompilationUnit[] units) {
        IFile file;
        ArrayList<IFile> result = new ArrayList<IFile>(units.length + 1);
        int i = 0;
        while (i < units.length) {
            file = this.getFile(units[i]);
            if (file != null) {
                result.add(file);
            }
            ++i;
        }
        if (this.fDeleteSource && (file = this.getFile((ICompilationUnit)this.fSourceProvider.getTypeRoot())) != null && !result.contains(file)) {
            result.add(file);
        }
        return result.toArray(new IFile[result.size()]);
    }

    private IFile getFile(ICompilationUnit unit) {
        IResource resource = (unit = unit.getPrimary()).getResource();
        if (resource != null && resource.getType() == 1) {
            return (IFile)resource;
        }
        return null;
    }

    private void checkOverridden(RefactoringStatus status, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 9);
        pm.setTaskName(RefactoringCoreMessages.InlineMethodRefactoring_checking_overridden);
        MethodDeclaration decl = this.fSourceProvider.getDeclaration();
        IMethod method = (IMethod)decl.resolveBinding().getJavaElement();
        if (method == null || Flags.isPrivate((int)method.getFlags())) {
            pm.worked(8);
            return;
        }
        IType type = method.getDeclaringType();
        ITypeHierarchy hierarchy = type.newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(pm, 6));
        this.checkSubTypes(status, method, hierarchy.getAllSubtypes(type), (IProgressMonitor)new SubProgressMonitor(pm, 1));
        this.checkSuperClasses(status, method, hierarchy.getAllSuperclasses(type), (IProgressMonitor)new SubProgressMonitor(pm, 1));
        this.checkSuperInterfaces(status, method, hierarchy.getAllSuperInterfaces(type), (IProgressMonitor)new SubProgressMonitor(pm, 1));
        pm.setTaskName("");
    }

    private void checkSubTypes(RefactoringStatus result, IMethod method, IType[] types, IProgressMonitor pm) {
        this.checkTypes(result, method, types, RefactoringCoreMessages.InlineMethodRefactoring_checking_overridden_error, pm);
    }

    private void checkSuperClasses(RefactoringStatus result, IMethod method, IType[] types, IProgressMonitor pm) {
        this.checkTypes(result, method, types, RefactoringCoreMessages.InlineMethodRefactoring_checking_overrides_error, pm);
    }

    private void checkSuperInterfaces(RefactoringStatus result, IMethod method, IType[] types, IProgressMonitor pm) {
        this.checkTypes(result, method, types, RefactoringCoreMessages.InlineMethodRefactoring_checking_implements_error, pm);
    }

    private void checkTypes(RefactoringStatus result, IMethod method, IType[] types, String key, IProgressMonitor pm) {
        pm.beginTask("", types.length);
        int i = 0;
        while (i < types.length) {
            pm.worked(1);
            IMethod[] overridden = types[i].findMethods(method);
            if (overridden != null && overridden.length > 0) {
                result.addError(Messages.format(key, JavaElementLabels.getElementLabel((IJavaElement)types[i], JavaElementLabels.ALL_DEFAULT)), JavaStatusContext.create((IMember)overridden[0]));
            }
            ++i;
        }
    }

    private ASTNode[] removeNestedCalls(RefactoringStatus status, ICompilationUnit unit, ASTNode[] invocations) {
        if (invocations.length <= 1) {
            return invocations;
        }
        ASTNode[] parents = new ASTNode[invocations.length];
        int i = 0;
        while (i < invocations.length) {
            parents[i] = invocations[i].getParent();
            ++i;
        }
        i = 0;
        while (i < invocations.length) {
            this.removeNestedCalls(status, unit, parents, invocations, i);
            ++i;
        }
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        int i2 = 0;
        while (i2 < invocations.length) {
            if (invocations[i2] != null) {
                result.add(invocations[i2]);
            }
            ++i2;
        }
        return result.toArray(new ASTNode[result.size()]);
    }

    private void removeNestedCalls(RefactoringStatus status, ICompilationUnit unit, ASTNode[] parents, ASTNode[] invocations, int index) {
        ASTNode invocation = invocations[index];
        int i = 0;
        while (i < parents.length) {
            ASTNode parent = parents[i];
            while (parent != null) {
                if (parent == invocation) {
                    status.addError(RefactoringCoreMessages.InlineMethodRefactoring_nestedInvocation, JavaStatusContext.create((ITypeRoot)unit, parent));
                    invocations[index] = null;
                }
                parent = parent.getParent();
            }
            ++i;
        }
    }

    public static class Mode {
        public static final Mode INLINE_ALL = new Mode();
        public static final Mode INLINE_SINGLE = new Mode();

        private Mode() {
        }
    }
}

