/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ModuleDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ModuleEncapsulationDetail;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ModuleAddReadsBlock {
    private final IStatusChangeListener fContext;
    private StringDialogField fSourceModule;
    private StringDialogField fTargetModule;
    private IStatus fSourceModuleStatus;
    private IStatus fTargetModuleStatus;
    private Control fSWTWidget;
    private final ModuleEncapsulationDetail.ModuleAddReads fInitialValue;
    private IJavaElement[] fSourceJavaElements;

    public ModuleAddReadsBlock(IStatusChangeListener context, IJavaElement[] sourceJavaElements, ModuleEncapsulationDetail.ModuleAddReads initialValue) {
        this.fContext = context;
        this.fInitialValue = initialValue;
        this.fSourceJavaElements = sourceJavaElements;
        this.fSourceModuleStatus = new StatusInfo();
        IDialogFieldListener adapter = field -> this.addReadsDialogFieldChanged(field);
        this.fSourceModule = new StringDialogField();
        this.fSourceModule.setDialogFieldListener(adapter);
        this.fSourceModule.setLabelText(NewWizardMessages.AddReadsBlock_sourceModule_label);
        this.fTargetModule = new StringDialogField();
        this.fTargetModule.setDialogFieldListener(adapter);
        this.fTargetModule.setLabelText(NewWizardMessages.AddReadsBlock_targetModule_label);
        this.setDefaults();
    }

    private void setDefaults() {
        if (this.fInitialValue != null) {
            this.fSourceModule.setText(this.fInitialValue.fSourceModule);
            if (!(this.fInitialValue.fSourceModule.isEmpty() || this.fSourceJavaElements != null && this.fSourceJavaElements.length > 1)) {
                this.fSourceModule.setEnabled(false);
            }
            this.fTargetModule.setText(this.fInitialValue.fTargetModule);
            this.fTargetModule.setEnabled(true);
        }
    }

    private Set<String> moduleNames() {
        HashSet<String> moduleNames = new HashSet<String>();
        if (this.fSourceJavaElements != null) {
            int i = 0;
            while (i < this.fSourceJavaElements.length) {
                IModuleDescription module;
                if (this.fSourceJavaElements[i] instanceof IPackageFragmentRoot && (module = ((IPackageFragmentRoot)this.fSourceJavaElements[i]).getModuleDescription()) != null) {
                    moduleNames.add(module.getElementName());
                }
                ++i;
            }
        }
        return moduleNames;
    }

    private String getSourceModuleText() {
        return this.fSourceModule.getText().trim();
    }

    private String getTargetModulesText() {
        return this.fTargetModule.getText().trim();
    }

    public String getValue() {
        String sourceModule = this.getSourceModuleText();
        String targetModules = this.getTargetModulesText();
        if (sourceModule.isEmpty() || targetModules.isEmpty()) {
            return "";
        }
        return String.valueOf(sourceModule) + '=' + targetModules;
    }

    public ModuleEncapsulationDetail.ModuleAddReads getReads(CPListElementAttribute parentAttribute) {
        String sourceModule = this.getSourceModuleText();
        String targetModules = this.getTargetModulesText();
        if (sourceModule.isEmpty() || targetModules.isEmpty()) {
            return null;
        }
        return new ModuleEncapsulationDetail.ModuleAddReads(sourceModule, targetModules, parentAttribute);
    }

    public Control createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        this.fSWTWidget = parent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        int widthHint = converter.convertWidthInCharsToPixels(60);
        GridData gd = new GridData(4, 1, false, false, 2, 1);
        gd.widthHint = converter.convertWidthInCharsToPixels(50);
        Label message = new Label(composite, 16448);
        message.setLayoutData((Object)gd);
        message.setText(NewWizardMessages.AddReadsBlock_message);
        DialogField.createEmptySpace(composite, 2);
        this.fSourceModule.doFillIntoGrid(composite, 2);
        Text sourceModuleField = this.fSourceModule.getTextControl(null);
        LayoutUtil.setWidthHint((Control)sourceModuleField, widthHint);
        LayoutUtil.setHorizontalGrabbing((Control)sourceModuleField);
        BidiUtils.applyBidiProcessing((Text)sourceModuleField, (String)"java");
        if (this.fSourceJavaElements != null) {
            ModuleDialog.configureModuleContentAssist(this.fSourceModule.getTextControl(composite), this.moduleNames());
        }
        DialogField.createEmptySpace(composite, 2);
        this.fTargetModule.doFillIntoGrid(composite, 2);
        Text targetModulesField = this.fTargetModule.getTextControl(null);
        LayoutUtil.setWidthHint((Control)targetModulesField, widthHint);
        LayoutUtil.setHorizontalGrabbing((Control)targetModulesField);
        BidiUtils.applyBidiProcessing((Text)targetModulesField, (String)"java");
        DialogField.createEmptySpace(composite, 2);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.annotations_attachment_dialog_context");
        return composite;
    }

    private void addReadsDialogFieldChanged(DialogField field) {
        if (this.fSWTWidget != null) {
            if (field == this.fSourceModule && this.fSourceModule.isEnabled()) {
                this.updateSourceModuleStatus();
            } else if (field == this.fTargetModule && this.fTargetModule.isEnabled()) {
                this.updateTargetModuleStatus();
            }
            this.doStatusLineUpdate();
        }
    }

    private void updateSourceModuleStatus() {
        this.fSourceModuleStatus = this.computeSourceModuleStatus(this.getSourceModuleText());
        if (this.fSourceModuleStatus.isOK() && this.getTargetModulesText().isEmpty() && this.fTargetModuleStatus == null) {
            this.fTargetModuleStatus = ModuleDialog.newSilentError();
        }
    }

    private void updateTargetModuleStatus() {
        this.fTargetModuleStatus = this.computeTargetModuleStatus(this.getTargetModulesText());
    }

    private IStatus computeSourceModuleStatus(String value) {
        StatusInfo status = new StatusInfo();
        if (value.isEmpty()) {
            status.setError(NewWizardMessages.ModuleAddExportsBlock_sourceModuleEmpty_error);
            return status;
        }
        if (this.moduleNames().contains(value)) {
            return status;
        }
        status.setError(Messages.format(NewWizardMessages.ModuleAddExportsBlock_wrongSourceModule_error, value));
        return status;
    }

    private IStatus computeTargetModuleStatus(String value) {
        StatusInfo status = new StatusInfo();
        if (value.isEmpty()) {
            status.setError(NewWizardMessages.ModuleAddExportsBlock_targetModuleEmpty_error);
            return status;
        }
        String source = "9";
        String compliance = "9";
        if (this.fSourceJavaElements != null && this.fSourceJavaElements.length > 0) {
            IJavaProject project = this.fSourceJavaElements[0].getJavaProject();
            source = project.getOption("org.eclipse.jdt.core.compiler.source", true);
            compliance = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        }
        if (JavaConventions.validateModuleName((String)value, (String)source, (String)compliance).getSeverity() == 4) {
            status.setError(Messages.format(NewWizardMessages.ModuleAddExportsBlock_illegalTargetModule_error, value));
        }
        return status;
    }

    private void doStatusLineUpdate() {
        IStatus status = null;
        status = !this.fSourceModuleStatus.isOK() ? this.fSourceModuleStatus : this.fTargetModuleStatus;
        if (status == null) {
            status = Status.OK_STATUS;
        }
        this.fContext.statusChanged(status);
    }
}

