/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.project;

import java.util.Arrays;
import java.util.List;

public class MicroProfileConfigPropertyInformation {
    public static final String DEFAULT_PROFILE = "";
    private final String propertyNameWithProfile;
    private final String value;
    private final String configFileName;
    private final String sourceConfigFileURI;
    private String profile;
    private String property;

    public MicroProfileConfigPropertyInformation(String propertyNameWithProfile, String value, String sourceConfigFileURI, String configFileName) {
        this.propertyNameWithProfile = propertyNameWithProfile;
        this.value = value;
        this.sourceConfigFileURI = sourceConfigFileURI;
        this.configFileName = configFileName;
        this.profile = null;
        this.property = null;
    }

    public String getProfile() {
        if (this.profile == null) {
            this.profile = this.propertyNameWithProfile.charAt(0) == '%' ? this.propertyNameWithProfile.substring(1, this.propertyNameWithProfile.indexOf(46)) : DEFAULT_PROFILE;
        }
        return this.profile;
    }

    public String getPropertyNameWithProfile() {
        return this.propertyNameWithProfile;
    }

    public String getPropertyNameWithoutProfile() {
        if (this.property == null) {
            this.property = MicroProfileConfigPropertyInformation.getPropertyNameWithoutProfile(this.propertyNameWithProfile);
        }
        return this.property;
    }

    public String getValue() {
        return this.value;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public String getSourceConfigFileURI() {
        return this.sourceConfigFileURI;
    }

    public static String getPropertyNameWithoutProfile(String propertyNameWithProfile) {
        if (propertyNameWithProfile.charAt(0) == '%') {
            int firstPeriodIndex = propertyNameWithProfile.indexOf(46);
            return propertyNameWithProfile.substring(firstPeriodIndex + 1);
        }
        return propertyNameWithProfile;
    }

    public static List<String> getSegments(String propertyNameWithProfile) {
        return Arrays.asList(propertyNameWithProfile.split("\\."));
    }
}

