/**
 */
package org.eclipse.lsat.common.mpt.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.lsat.common.mpt.MPTFactory;
import org.eclipse.lsat.common.mpt.MPTPackage;
import org.eclipse.lsat.common.mpt.MaxPlusSpecification;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

/**
 * This is the item provider adapter for a {@link org.eclipse.lsat.common.mpt.MaxPlusSpecification} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class MaxPlusSpecificationItemProvider 
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MaxPlusSpecificationItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addControllablePropertyDescriptor(object);
			addUncontrollablePropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Controllable feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addControllablePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_MaxPlusSpecification_controllable_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_MaxPlusSpecification_controllable_feature", "_UI_MaxPlusSpecification_type"),
				 MPTPackage.Literals.MAX_PLUS_SPECIFICATION__CONTROLLABLE,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Uncontrollable feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addUncontrollablePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_MaxPlusSpecification_uncontrollable_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_MaxPlusSpecification_uncontrollable_feature", "_UI_MaxPlusSpecification_type"),
				 MPTPackage.Literals.MAX_PLUS_SPECIFICATION__UNCONTROLLABLE,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(MPTPackage.Literals.MAX_PLUS_SPECIFICATION__MATRICES);
			childrenFeatures.add(MPTPackage.Literals.MAX_PLUS_SPECIFICATION__GRAPHS);
			childrenFeatures.add(MPTPackage.Literals.MAX_PLUS_SPECIFICATION__CONTROLLABLE);
			childrenFeatures.add(MPTPackage.Literals.MAX_PLUS_SPECIFICATION__UNCONTROLLABLE);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns MaxPlusSpecification.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/MaxPlusSpecification"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		return getString("_UI_MaxPlusSpecification_type");
	}
	

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(MaxPlusSpecification.class)) {
			case MPTPackage.MAX_PLUS_SPECIFICATION__MATRICES:
			case MPTPackage.MAX_PLUS_SPECIFICATION__GRAPHS:
			case MPTPackage.MAX_PLUS_SPECIFICATION__CONTROLLABLE:
			case MPTPackage.MAX_PLUS_SPECIFICATION__UNCONTROLLABLE:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(MPTPackage.Literals.MAX_PLUS_SPECIFICATION__MATRICES,
				 MPTFactory.eINSTANCE.createMatrix()));

		newChildDescriptors.add
			(createChildParameter
				(MPTPackage.Literals.MAX_PLUS_SPECIFICATION__GRAPHS,
				 MPTFactory.eINSTANCE.createFSM()));

		newChildDescriptors.add
			(createChildParameter
				(MPTPackage.Literals.MAX_PLUS_SPECIFICATION__GRAPHS,
				 MPTFactory.eINSTANCE.createMPS()));

		newChildDescriptors.add
			(createChildParameter
				(MPTPackage.Literals.MAX_PLUS_SPECIFICATION__GRAPHS,
				 MPTFactory.eINSTANCE.createMPA()));

		newChildDescriptors.add
			(createChildParameter
				(MPTPackage.Literals.MAX_PLUS_SPECIFICATION__CONTROLLABLE,
				 MPTFactory.eINSTANCE.createEvent()));

		newChildDescriptors.add
			(createChildParameter
				(MPTPackage.Literals.MAX_PLUS_SPECIFICATION__UNCONTROLLABLE,
				 MPTFactory.eINSTANCE.createEvent()));
	}

	/**
	 * This returns the label text for {@link org.eclipse.emf.edit.command.CreateChildCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
		Object childFeature = feature;
		Object childObject = child;

		boolean qualify =
			childFeature == MPTPackage.Literals.MAX_PLUS_SPECIFICATION__CONTROLLABLE ||
			childFeature == MPTPackage.Literals.MAX_PLUS_SPECIFICATION__UNCONTROLLABLE;

		if (qualify) {
			return getString
				("_UI_CreateChild_text2",
				 new Object[] { getTypeText(childObject), getFeatureText(childFeature), getTypeText(owner) });
		}
		return super.getCreateChildText(owner, feature, child, selection);
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return MaxPlusEditPlugin.INSTANCE;
	}

}
