/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.activity.teditor;

import org.eclipse.xtext.common.services.Ecore2XtextTerminalConverters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.nodemodel.INode;

public class ActivityValueConvertorService extends Ecore2XtextTerminalConverters {
    @ValueConverter(rule = "BooleanLiteral")
    public IValueConverter<Boolean> booleanLiteral() {
        return new IValueConverter<Boolean>() {
            @Override
            public Boolean toValue(String string, INode node) {
                return "True".equals(string);
            }

            @Override
            public String toString(Boolean value) {
                return value ? "True" : "False";
            }
        };
    }
}
