/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.keystore;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.crypto.CryptoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemKeystoreServiceOptions {
    private static final Logger logger = LoggerFactory.getLogger(FilesystemKeystoreServiceOptions.class);
    private static final String KEY_SERVICE_PID = "kura.service.pid";
    static final String KEY_KEYSTORE_PATH = "keystore.path";
    static final String KEY_KEYSTORE_PASSWORD = "keystore.password";
    static final String KEY_RANDOMIZE_PASSWORD = "randomize.password";
    private static final String DEFAULT_KEYSTORE_PATH = "/tmp/keystore.ks";
    private static final boolean DEFAULT_RANDOMIZE_PASSWORD = false;
    static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    private final Map<String, Object> properties;
    private final String pid;
    private final String keystorePath;
    private final Password keystorePassword;
    private final boolean randomPassword;

    public FilesystemKeystoreServiceOptions(Map<String, Object> properties, CryptoService cryptoService) {
        if (Objects.isNull(properties) || Objects.isNull(cryptoService)) {
            throw new IllegalArgumentException("Input parameters cannot be null!");
        }
        this.properties = properties;
        this.pid = (String)properties.get(KEY_SERVICE_PID);
        String keyStorePath = (String)properties.getOrDefault(KEY_KEYSTORE_PATH, DEFAULT_KEYSTORE_PATH);
        try {
            this.keystorePath = this.validateAndNormalize(keyStorePath);
        }
        catch (Exception exception) {
            logger.error("Keystore path {} not valid", (Object)keyStorePath);
            throw new IllegalArgumentException("Invalid keystore path");
        }
        this.keystorePassword = FilesystemKeystoreServiceOptions.extractPassword(properties, cryptoService);
        this.randomPassword = (Boolean)properties.getOrDefault(KEY_RANDOMIZE_PASSWORD, false);
    }

    private String validateAndNormalize(String keystorePath) throws URISyntaxException, InvalidPathException {
        Paths.get(keystorePath, new String[0]);
        return new URI(keystorePath).normalize().toString();
    }

    private static Password extractPassword(Map<String, Object> properties, CryptoService cryptoService) {
        Object optionsPassword = properties.get(KEY_KEYSTORE_PASSWORD);
        if (optionsPassword instanceof String) {
            return new Password((String)optionsPassword);
        }
        try {
            return new Password(cryptoService.encryptAes(DEFAULT_KEYSTORE_PASSWORD.toCharArray()));
        }
        catch (Exception e) {
            logger.warn("failed to encrypt default keystore password", (Throwable)e);
            return new Password(DEFAULT_KEYSTORE_PASSWORD);
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getPid() {
        return this.pid;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public char[] getKeystorePassword(CryptoService cryptoService) {
        try {
            return cryptoService.decryptAes(this.keystorePassword.getPassword());
        }
        catch (Exception exception) {
            return this.keystorePassword.getPassword();
        }
    }

    public boolean needsRandomPassword() {
        return this.randomPassword;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.keystorePassword.getPassword()), this.keystorePath, this.pid, this.randomPassword);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilesystemKeystoreServiceOptions other = (FilesystemKeystoreServiceOptions)obj;
        return Arrays.equals(this.keystorePassword.getPassword(), other.keystorePassword.getPassword()) && Objects.equals(this.keystorePath, other.keystorePath) && Objects.equals(this.pid, other.pid) && this.randomPassword == other.randomPassword;
    }
}

