/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.linux.bluetooth.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothSafeProcess {
    private static final Logger s_logger = LoggerFactory.getLogger(BluetoothSafeProcess.class);
    private static final ExecutorService s_streamGobblers = Executors.newFixedThreadPool(2);
    private Process process;
    private Future<byte[]> futureInputGobbler;
    private Future<byte[]> futureErrorGobbler;
    private byte[] inBytes;
    private byte[] errBytes;
    private boolean waited;
    private int exitValue;

    BluetoothSafeProcess() {
    }

    public OutputStream getOutputStream() {
        s_logger.warn("getOutputStream() is unsupported");
        return null;
    }

    public InputStream getInputStream() {
        if (!this.waited) {
            s_logger.warn("getInputStream() must be called after waitFor()");
        }
        return new ByteArrayInputStream(this.inBytes);
    }

    public InputStream getErrorStream() {
        if (!this.waited) {
            s_logger.warn("getErrorStream() must be called after waitFor()");
        }
        return new ByteArrayInputStream(this.errBytes);
    }

    void exec(String[] cmdarray) throws IOException {
        s_logger.debug("Executing: {}", (Object)Arrays.toString(cmdarray));
        ProcessBuilder pb = new ProcessBuilder(cmdarray);
        this.process = pb.start();
        this.futureInputGobbler = s_streamGobblers.submit(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                Thread.currentThread().setName("SafeProcess InputStream Gobbler");
                return BluetoothSafeProcess.this.readStreamFully(BluetoothSafeProcess.this.process.getInputStream());
            }
        });
        this.futureErrorGobbler = s_streamGobblers.submit(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                Thread.currentThread().setName("SafeProcess ErrorStream Gobbler");
                return BluetoothSafeProcess.this.readStreamFully(BluetoothSafeProcess.this.process.getErrorStream());
            }
        });
        try {
            try {
                this.inBytes = this.futureInputGobbler.get();
                this.errBytes = this.futureErrorGobbler.get();
                this.exitValue = this.process.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
        finally {
            this.closeQuietly(this.process.getInputStream());
            this.closeQuietly(this.process.getErrorStream());
            this.closeQuietly(this.process.getOutputStream());
            this.process.destroy();
            this.process = null;
            this.waited = true;
        }
    }

    public int waitFor() throws InterruptedException {
        return this.exitValue;
    }

    public int exitValue() {
        return this.exitValue;
    }

    public void destroy() {
        if (!this.waited) {
            s_logger.warn("Calling destroy() before waitFor() might lead to resource leaks");
            Thread.dumpStack();
            if (this.process != null) {
                this.process.destroy();
            }
        }
        this.inBytes = null;
        this.errBytes = null;
        this.process = null;
    }

    private byte[] readStreamFully(InputStream is) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        ByteArrayOutputStream inBaos = new ByteArrayOutputStream(1024);
        while ((len = is.read(buf)) != -1) {
            inBaos.write(buf, 0, len);
        }
        return inBaos.toByteArray();
    }

    private void closeQuietly(InputStream is) {
        if (is != null) {
            try {
                is.close();
                is = null;
            }
            catch (IOException e) {
                s_logger.warn("Failed to close process input stream", (Throwable)e);
            }
        }
    }

    private void closeQuietly(OutputStream os) {
        if (os != null) {
            try {
                os.close();
                os = null;
            }
            catch (IOException e) {
                s_logger.warn("Failed to close process output stream", (Throwable)e);
            }
        }
    }
}

