/*
 * Copyright (c) 2024, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

// Generated by jextract

package jdk.internal.ffi.generated.kqueue;

import java.lang.foreign.*;
import java.util.function.*;

import static java.lang.foreign.MemoryLayout.PathElement.*;
import static java.lang.foreign.ValueLayout.*;

/**
 * {@snippet lang=c :
 * struct kevent {
 *     uintptr_t ident;
 *     int16_t filter;
 *     uint16_t flags;
 *     uint32_t fflags;
 *     intptr_t data;
 *     void *udata;
 * }
 * }
 */
@SuppressWarnings("restricted")
public class kevent {

    kevent() {
        // Should not be called directly
    }

    private static final GroupLayout $LAYOUT = MemoryLayout.structLayout(
        kqueue_h.align(kqueue_h.C_LONG, 4).withName("ident"),
        kqueue_h.C_SHORT.withName("filter"),
        kqueue_h.C_SHORT.withName("flags"),
        kqueue_h.C_INT.withName("fflags"),
        kqueue_h.align(kqueue_h.C_LONG, 4).withName("data"),
        kqueue_h.align(kqueue_h.C_POINTER, 4).withName("udata")
    ).withName("kevent");

    /**
     * The layout of this struct
     */
    public static final GroupLayout layout() {
        return $LAYOUT;
    }

    private static final OfLong ident$LAYOUT = (OfLong)$LAYOUT.select(groupElement("ident"));

    /**
     * Layout for field:
     * {@snippet lang=c :
     * uintptr_t ident
     * }
     */
    public static final OfLong ident$layout() {
        return ident$LAYOUT;
    }

    private static final long ident$OFFSET = $LAYOUT.byteOffset(groupElement("ident"));

    /**
     * Offset for field:
     * {@snippet lang=c :
     * uintptr_t ident
     * }
     */
    public static final long ident$offset() {
        return ident$OFFSET;
    }

    /**
     * Getter for field:
     * {@snippet lang=c :
     * uintptr_t ident
     * }
     */
    public static long ident(MemorySegment struct) {
        return struct.get(ident$LAYOUT, ident$OFFSET);
    }

    /**
     * Setter for field:
     * {@snippet lang=c :
     * uintptr_t ident
     * }
     */
    public static void ident(MemorySegment struct, long fieldValue) {
        struct.set(ident$LAYOUT, ident$OFFSET, fieldValue);
    }

    private static final OfShort filter$LAYOUT = (OfShort)$LAYOUT.select(groupElement("filter"));

    /**
     * Layout for field:
     * {@snippet lang=c :
     * int16_t filter
     * }
     */
    public static final OfShort filter$layout() {
        return filter$LAYOUT;
    }

    private static final long filter$OFFSET = $LAYOUT.byteOffset(groupElement("filter"));

    /**
     * Offset for field:
     * {@snippet lang=c :
     * int16_t filter
     * }
     */
    public static final long filter$offset() {
        return filter$OFFSET;
    }

    /**
     * Getter for field:
     * {@snippet lang=c :
     * int16_t filter
     * }
     */
    public static short filter(MemorySegment struct) {
        return struct.get(filter$LAYOUT, filter$OFFSET);
    }

    /**
     * Setter for field:
     * {@snippet lang=c :
     * int16_t filter
     * }
     */
    public static void filter(MemorySegment struct, short fieldValue) {
        struct.set(filter$LAYOUT, filter$OFFSET, fieldValue);
    }

    private static final OfShort flags$LAYOUT = (OfShort)$LAYOUT.select(groupElement("flags"));

    /**
     * Layout for field:
     * {@snippet lang=c :
     * uint16_t flags
     * }
     */
    public static final OfShort flags$layout() {
        return flags$LAYOUT;
    }

    private static final long flags$OFFSET = $LAYOUT.byteOffset(groupElement("flags"));

    /**
     * Offset for field:
     * {@snippet lang=c :
     * uint16_t flags
     * }
     */
    public static final long flags$offset() {
        return flags$OFFSET;
    }

    /**
     * Getter for field:
     * {@snippet lang=c :
     * uint16_t flags
     * }
     */
    public static short flags(MemorySegment struct) {
        return struct.get(flags$LAYOUT, flags$OFFSET);
    }

    /**
     * Setter for field:
     * {@snippet lang=c :
     * uint16_t flags
     * }
     */
    public static void flags(MemorySegment struct, short fieldValue) {
        struct.set(flags$LAYOUT, flags$OFFSET, fieldValue);
    }

    private static final OfInt fflags$LAYOUT = (OfInt)$LAYOUT.select(groupElement("fflags"));

    /**
     * Layout for field:
     * {@snippet lang=c :
     * uint32_t fflags
     * }
     */
    public static final OfInt fflags$layout() {
        return fflags$LAYOUT;
    }

    private static final long fflags$OFFSET = $LAYOUT.byteOffset(groupElement("fflags"));

    /**
     * Offset for field:
     * {@snippet lang=c :
     * uint32_t fflags
     * }
     */
    public static final long fflags$offset() {
        return fflags$OFFSET;
    }

    /**
     * Getter for field:
     * {@snippet lang=c :
     * uint32_t fflags
     * }
     */
    public static int fflags(MemorySegment struct) {
        return struct.get(fflags$LAYOUT, fflags$OFFSET);
    }

    /**
     * Setter for field:
     * {@snippet lang=c :
     * uint32_t fflags
     * }
     */
    public static void fflags(MemorySegment struct, int fieldValue) {
        struct.set(fflags$LAYOUT, fflags$OFFSET, fieldValue);
    }

    private static final OfLong data$LAYOUT = (OfLong)$LAYOUT.select(groupElement("data"));

    /**
     * Layout for field:
     * {@snippet lang=c :
     * intptr_t data
     * }
     */
    public static final OfLong data$layout() {
        return data$LAYOUT;
    }

    private static final long data$OFFSET = $LAYOUT.byteOffset(groupElement("data"));

    /**
     * Offset for field:
     * {@snippet lang=c :
     * intptr_t data
     * }
     */
    public static final long data$offset() {
        return data$OFFSET;
    }

    /**
     * Getter for field:
     * {@snippet lang=c :
     * intptr_t data
     * }
     */
    public static long data(MemorySegment struct) {
        return struct.get(data$LAYOUT, data$OFFSET);
    }

    /**
     * Setter for field:
     * {@snippet lang=c :
     * intptr_t data
     * }
     */
    public static void data(MemorySegment struct, long fieldValue) {
        struct.set(data$LAYOUT, data$OFFSET, fieldValue);
    }

    private static final AddressLayout udata$LAYOUT = (AddressLayout)$LAYOUT.select(groupElement("udata"));

    /**
     * Layout for field:
     * {@snippet lang=c :
     * void *udata
     * }
     */
    public static final AddressLayout udata$layout() {
        return udata$LAYOUT;
    }

    private static final long udata$OFFSET = $LAYOUT.byteOffset(groupElement("udata"));

    /**
     * Offset for field:
     * {@snippet lang=c :
     * void *udata
     * }
     */
    public static final long udata$offset() {
        return udata$OFFSET;
    }

    /**
     * Getter for field:
     * {@snippet lang=c :
     * void *udata
     * }
     */
    public static MemorySegment udata(MemorySegment struct) {
        return struct.get(udata$LAYOUT, udata$OFFSET);
    }

    /**
     * Setter for field:
     * {@snippet lang=c :
     * void *udata
     * }
     */
    public static void udata(MemorySegment struct, MemorySegment fieldValue) {
        struct.set(udata$LAYOUT, udata$OFFSET, fieldValue);
    }

    /**
     * Obtains a slice of {@code arrayParam} which selects the array element at {@code index}.
     * The returned segment has address {@code arrayParam.address() + index * layout().byteSize()}
     */
    public static MemorySegment asSlice(MemorySegment array, long index) {
        return array.asSlice(layout().byteSize() * index);
    }

    /**
     * The size (in bytes) of this struct
     */
    public static long sizeof() { return layout().byteSize(); }

    /**
     * Allocate a segment of size {@code layout().byteSize()} using {@code allocator}
     */
    public static MemorySegment allocate(SegmentAllocator allocator) {
        return allocator.allocate(layout());
    }

    /**
     * Allocate an array of size {@code elementCount} using {@code allocator}.
     * The returned segment has size {@code elementCount * layout().byteSize()}.
     */
    public static MemorySegment allocateArray(long elementCount, SegmentAllocator allocator) {
        return allocator.allocate(MemoryLayout.sequenceLayout(elementCount, layout()));
    }

    /**
     * Reinterprets {@code addr} using target {@code arena} and {@code cleanupAction} (if any).
     * The returned segment has size {@code layout().byteSize()}
     */
    public static MemorySegment reinterpret(MemorySegment addr, Arena arena, Consumer<MemorySegment> cleanup) {
        return reinterpret(addr, 1, arena, cleanup);
    }

    /**
     * Reinterprets {@code addr} using target {@code arena} and {@code cleanupAction} (if any).
     * The returned segment has size {@code elementCount * layout().byteSize()}
     */
    public static MemorySegment reinterpret(MemorySegment addr, long elementCount, Arena arena, Consumer<MemorySegment> cleanup) {
        return addr.reinterpret(layout().byteSize() * elementCount, arena, cleanup);
    }
}
