/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_hu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_zbl = "Bliss jelképrendszer";
        final String metaValue_JP = "Japán";
        final String metaValue_Hant = "Hagyományos";
        final Object[][] data = new Object[][] {
            { "001", "Világ" },
            { "002", "Afrika" },
            { "003", "Észak-Amerika" },
            { "005", "Dél-Amerika" },
            { "009", "Óceánia" },
            { "011", "Nyugat-Afrika" },
            { "013", "Közép-Amerika" },
            { "014", "Kelet-Afrika" },
            { "015", "Észak-Afrika" },
            { "017", "Közép-Afrika" },
            { "018", "Afrika déli része" },
            { "019", "Amerika" },
            { "021", "Amerika északi része" },
            { "029", "Karib-térség" },
            { "030", "Kelet-Ázsia" },
            { "034", "Dél-Ázsia" },
            { "035", "Délkelet-Ázsia" },
            { "039", "Dél-Európa" },
            { "053", "Ausztrálázsia" },
            { "054", "Melanézia" },
            { "057", "Mikronéziai régió" },
            { "061", "Polinézia" },
            { "142", "Ázsia" },
            { "143", "Közép-Ázsia" },
            { "145", "Nyugat-Ázsia" },
            { "150", "Európa" },
            { "151", "Kelet-Európa" },
            { "154", "Észak-Európa" },
            { "155", "Nyugat-Európa" },
            { "202", "Szubszaharai Afrika" },
            { "419", "Latin-Amerika" },
            { "AC", "Ascension-sziget" },
            { "AD", "Andorra" },
            { "AE", "Egyesült Arab Emírségek" },
            { "AF", "Afganisztán" },
            { "AG", "Antigua és Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albánia" },
            { "AM", "Örményország" },
            { "AO", "Angola" },
            { "AQ", "Antarktisz" },
            { "AR", "Argentína" },
            { "AS", "Amerikai Szamoa" },
            { "AT", "Ausztria" },
            { "AU", "Ausztrália" },
            { "AW", "Aruba" },
            { "AX", "Åland-szigetek" },
            { "AZ", "Azerbajdzsán" },
            { "BA", "Bosznia-Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Banglades" },
            { "BE", "Belgium" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgária" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barthélemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolívia" },
            { "BQ", "Holland Karib-térség" },
            { "BR", "Brazília" },
            { "BS", "Bahama-szigetek" },
            { "BT", "Bhután" },
            { "BV", "Bouvet-sziget" },
            { "BW", "Botswana" },
            { "BY", "Belarusz" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kókusz (Keeling)-szigetek" },
            { "CD", "Kongó – Kinshasa" },
            { "CF", "Közép-afrikai Köztársaság" },
            { "CG", "Kongó – Brazzaville" },
            { "CH", "Svájc" },
            { "CI", "Elefántcsontpart" },
            { "CK", "Cook-szigetek" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "Kína" },
            { "CO", "Kolumbia" },
            { "CP", "Clipperton-sziget" },
            { "CQ", "Sark" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Zöld-foki Köztársaság" },
            { "CW", "Curaçao" },
            { "CX", "Karácsony-sziget" },
            { "CY", "Ciprus" },
            { "CZ", "Csehország" },
            { "DE", "Németország" },
            { "DG", "Diego Garcia" },
            { "DJ", "Dzsibuti" },
            { "DK", "Dánia" },
            { "DM", "Dominika" },
            { "DO", "Dominikai Köztársaság" },
            { "DZ", "Algéria" },
            { "EA", "Ceuta és Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Észtország" },
            { "EG", "Egyiptom" },
            { "EH", "Nyugat-Szahara" },
            { "ER", "Eritrea" },
            { "ES", "Spanyolország" },
            { "ET", "Etiópia" },
            { "EU", "Európai Unió" },
            { "EZ", "Eurózóna" },
            { "FI", "Finnország" },
            { "FJ", "Fidzsi" },
            { "FK", "Falkland-szigetek" },
            { "FM", "Mikronézia" },
            { "FO", "Feröer szigetek" },
            { "FR", "Franciaország" },
            { "GA", "Gabon" },
            { "GB", "Egyesült Királyság" },
            { "GD", "Grenada" },
            { "GE", "Grúzia" },
            { "GF", "Francia Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghána" },
            { "GI", "Gibraltár" },
            { "GL", "Grönland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Egyenlítői-Guinea" },
            { "GR", "Görögország" },
            { "GS", "Déli-Georgia és Déli-Sandwich-szigetek" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Bissau-Guinea" },
            { "GY", "Guyana" },
            { "HK", "Hongkong KKT" },
            { "HM", "Heard-sziget és McDonald-szigetek" },
            { "HN", "Honduras" },
            { "HR", "Horvátország" },
            { "HT", "Haiti" },
            { "HU", "Magyarország" },
            { "IC", "Kanári-szigetek" },
            { "ID", "Indonézia" },
            { "IE", "Írország" },
            { "IL", "Izrael" },
            { "IM", "Man-sziget" },
            { "IN", "India" },
            { "IO", "Brit Indiai-óceáni Terület" },
            { "IQ", "Irak" },
            { "IR", "Irán" },
            { "IS", "Izland" },
            { "IT", "Olaszország" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordánia" },
            { "JP", metaValue_JP },
            { "KE", "Kenya" },
            { "KG", "Kirgizisztán" },
            { "KH", "Kambodzsa" },
            { "KI", "Kiribati" },
            { "KM", "Comore-szigetek" },
            { "KN", "Saint Kitts és Nevis" },
            { "KP", "Észak-Korea" },
            { "KR", "Dél-Korea" },
            { "KW", "Kuvait" },
            { "KY", "Kajmán-szigetek" },
            { "KZ", "Kazahsztán" },
            { "LA", "Laosz" },
            { "LB", "Libanon" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Srí Lanka" },
            { "LR", "Libéria" },
            { "LS", "Lesotho" },
            { "LT", "Litvánia" },
            { "LU", "Luxemburg" },
            { "LV", "Lettország" },
            { "LY", "Líbia" },
            { "MA", "Marokkó" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegró" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaszkár" },
            { "MH", "Marshall-szigetek" },
            { "MK", "Észak-Macedónia" },
            { "ML", "Mali" },
            { "MM", "Mianmar" },
            { "MN", "Mongólia" },
            { "MO", "Makaó KKT" },
            { "MP", "Északi Mariana-szigetek" },
            { "MQ", "Martinique" },
            { "MR", "Mauritánia" },
            { "MS", "Montserrat" },
            { "MT", "Málta" },
            { "MU", "Mauritius" },
            { "MV", "Maldív-szigetek" },
            { "MW", "Malawi" },
            { "MX", "Mexikó" },
            { "MY", "Malajzia" },
            { "MZ", "Mozambik" },
            { "NA", "Namíbia" },
            { "NC", "Új-Kaledónia" },
            { "NE", "Niger" },
            { "NF", "Norfolk-sziget" },
            { "NG", "Nigéria" },
            { "NI", "Nicaragua" },
            { "NL", "Hollandia" },
            { "NO", "Norvégia" },
            { "NP", "Nepál" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Új-Zéland" },
            { "OM", "Omán" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Francia Polinézia" },
            { "PG", "Pápua Új-Guinea" },
            { "PH", "Fülöp-szigetek" },
            { "PK", "Pakisztán" },
            { "PL", "Lengyelország" },
            { "PM", "Saint-Pierre és Miquelon" },
            { "PN", "Pitcairn-szigetek" },
            { "PR", "Puerto Rico" },
            { "PS", "Palesztin Autonómia" },
            { "PT", "Portugália" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Katar" },
            { "QO", "Külső-Óceánia" },
            { "RE", "Réunion" },
            { "RO", "Románia" },
            { "RS", "Szerbia" },
            { "RU", "Oroszország" },
            { "RW", "Ruanda" },
            { "SA", "Szaúd-Arábia" },
            { "SB", "Salamon-szigetek" },
            { "SC", "Seychelle-szigetek" },
            { "SD", "Szudán" },
            { "SE", "Svédország" },
            { "SG", "Szingapúr" },
            { "SH", "Szent Ilona" },
            { "SI", "Szlovénia" },
            { "SJ", "Svalbard és Jan Mayen" },
            { "SK", "Szlovákia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Szenegál" },
            { "SO", "Szomália" },
            { "SR", "Suriname" },
            { "SS", "Dél-Szudán" },
            { "ST", "São Tomé és Príncipe" },
            { "SV", "Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Szíria" },
            { "SZ", "Szváziföld" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- és Caicos-szigetek" },
            { "TD", "Csád" },
            { "TF", "Francia Déli Területek" },
            { "TG", "Togo" },
            { "TH", "Thaiföld" },
            { "TJ", "Tádzsikisztán" },
            { "TK", "Tokelau" },
            { "TL", "Kelet-Timor" },
            { "TM", "Türkmenisztán" },
            { "TN", "Tunézia" },
            { "TO", "Tonga" },
            { "TR", "Törökország" },
            { "TT", "Trinidad és Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tajvan" },
            { "TZ", "Tanzánia" },
            { "UA", "Ukrajna" },
            { "UG", "Uganda" },
            { "UM", "Az USA lakatlan külbirtokai" },
            { "UN", "Egyesült Nemzetek Szervezete" },
            { "US", "Egyesült Államok" },
            { "UY", "Uruguay" },
            { "UZ", "Üzbegisztán" },
            { "VA", "Vatikán" },
            { "VC", "Saint Vincent és a Grenadine-szigetek" },
            { "VE", "Venezuela" },
            { "VG", "Brit Virgin-szigetek" },
            { "VI", "Amerikai Virgin-szigetek" },
            { "VN", "Vietnám" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis és Futuna" },
            { "WS", "Szamoa" },
            { "XA", "Pszeudo-nyelvjárások" },
            { "XB", "Pszeudo-kétirányú" },
            { "XK", "Koszovó" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Dél-afrikai Köztársaság" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Ismeretlen körzet" },
            { "aa", "afar" },
            { "ab", "abház" },
            { "ae", "avesztán" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhara" },
            { "an", "aragonéz" },
            { "ar", "arab" },
            { "as", "asszámi" },
            { "av", "avar" },
            { "ay", "ajmara" },
            { "az", "azerbajdzsáni" },
            { "ba", "baskír" },
            { "be", "belarusz" },
            { "bg", "bolgár" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bangla" },
            { "bo", "tibeti" },
            { "br", "breton" },
            { "bs", "bosnyák" },
            { "ca", "katalán" },
            { "ce", "csecsen" },
            { "ch", "csamoró" },
            { "co", "korzikai" },
            { "cr", "krí" },
            { "cs", "cseh" },
            { "cu", "egyházi szláv" },
            { "cv", "csuvas" },
            { "cy", "walesi" },
            { "da", "dán" },
            { "de", "német" },
            { "dv", "divehi" },
            { "dz", "dzsonga" },
            { "ee", "eve" },
            { "el", "görög" },
            { "en", "angol" },
            { "eo", "eszperantó" },
            { "es", "spanyol" },
            { "et", "észt" },
            { "eu", "baszk" },
            { "fa", "perzsa" },
            { "ff", "fulani" },
            { "fi", "finn" },
            { "fj", "fidzsi" },
            { "fo", "feröeri" },
            { "fr", "francia" },
            { "fy", "nyugati fríz" },
            { "ga", "ír" },
            { "gd", "skóciai kelta" },
            { "gl", "gallego" },
            { "gn", "guarani" },
            { "gu", "gudzsaráti" },
            { "gv", "man-szigeti" },
            { "ha", "hausza" },
            { "he", "héber" },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "horvát" },
            { "ht", "haiti kreol" },
            { "hu", "magyar" },
            { "hy", "örmény" },
            { "hz", "herero" },
            { "ia", "interlingva" },
            { "id", "indonéz" },
            { "ie", "interlingue" },
            { "ig", "igbó" },
            { "ii", "szecsuán ji" },
            { "ik", "inupiak" },
            { "io", "idó" },
            { "is", "izlandi" },
            { "it", "olasz" },
            { "iu", "inuktitut" },
            { "ja", "japán" },
            { "jv", "jávai" },
            { "ka", "grúz" },
            { "kg", "kongo" },
            { "ki", "kikuju" },
            { "kj", "kuanyama" },
            { "kk", "kazah" },
            { "kl", "grönlandi" },
            { "km", "khmer" },
            { "kn", "kannada" },
            { "ko", "koreai" },
            { "kr", "kanuri" },
            { "ks", "kasmíri" },
            { "ku", "kurd" },
            { "kv", "komi" },
            { "kw", "korni" },
            { "ky", "kirgiz" },
            { "la", "latin" },
            { "lb", "luxemburgi" },
            { "lg", "ganda" },
            { "li", "limburgi" },
            { "ln", "lingala" },
            { "lo", "lao" },
            { "lt", "litván" },
            { "lu", "luba-katanga" },
            { "lv", "lett" },
            { "mg", "malgas" },
            { "mh", "marshalli" },
            { "mi", "maori" },
            { "mk", "macedón" },
            { "ml", "malajálam" },
            { "mn", "mongol" },
            { "mr", "maráthi" },
            { "ms", "maláj" },
            { "mt", "máltai" },
            { "my", "burmai" },
            { "na", "naurui" },
            { "nb", "norvég (bokmål)" },
            { "nd", "északi ndebele" },
            { "ne", "nepáli" },
            { "ng", "ndonga" },
            { "nl", "holland" },
            { "nn", "norvég (nynorsk)" },
            { "no", "norvég" },
            { "nr", "déli ndebele" },
            { "nv", "navahó" },
            { "ny", "nyandzsa" },
            { "oc", "okszitán" },
            { "oj", "ojibva" },
            { "om", "oromo" },
            { "or", "odia" },
            { "os", "oszét" },
            { "pa", "pandzsábi" },
            { "pi", "pali" },
            { "pl", "lengyel" },
            { "ps", "pastu" },
            { "pt", "portugál" },
            { "qu", "kecsua" },
            { "rm", "rétoromán" },
            { "rn", "kirundi" },
            { "ro", "román" },
            { "ru", "orosz" },
            { "rw", "kinyarvanda" },
            { "sa", "szanszkrit" },
            { "sc", "szardíniai" },
            { "sd", "szindhi" },
            { "se", "északi számi" },
            { "sg", "szangó" },
            { "sh", "szerbhorvát" },
            { "si", "szingaléz" },
            { "sk", "szlovák" },
            { "sl", "szlovén" },
            { "sm", "szamoai" },
            { "sn", "sona" },
            { "so", "szomáli" },
            { "sq", "albán" },
            { "sr", "szerb" },
            { "ss", "sziszuati" },
            { "st", "déli szeszotó" },
            { "su", "szundanéz" },
            { "sv", "svéd" },
            { "sw", "szuahéli" },
            { "ta", "tamil" },
            { "te", "telugu" },
            { "tg", "tadzsik" },
            { "th", "thai" },
            { "ti", "tigrinya" },
            { "tk", "türkmén" },
            { "tl", "tagalog" },
            { "tn", "szecsuáni" },
            { "to", "tongai" },
            { "tr", "török" },
            { "ts", "conga" },
            { "tt", "tatár" },
            { "tw", "twi" },
            { "ty", "tahiti" },
            { "ug", "ujgur" },
            { "uk", "ukrán" },
            { "ur", "urdu" },
            { "uz", "üzbég" },
            { "ve", "venda" },
            { "vi", "vietnámi" },
            { "vo", "volapük" },
            { "wa", "vallon" },
            { "wo", "volof" },
            { "xh", "xhosza" },
            { "yi", "jiddis" },
            { "yo", "joruba" },
            { "za", "zsuang" },
            { "zh", "kínai" },
            { "zu", "zulu" },
            { "ace", "achinéz" },
            { "ach", "akoli" },
            { "ada", "adangme" },
            { "ady", "adyghe" },
            { "afh", "afrihili" },
            { "agq", "agem" },
            { "ain", "ainu" },
            { "akk", "akkád" },
            { "ale", "aleut" },
            { "alt", "dél-altaji" },
            { "ang", "óangol" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "apc", "levantei arab" },
            { "arc", "arámi" },
            { "arn", "mapucse" },
            { "arp", "arapaho" },
            { "ars", "nedzsdi arab" },
            { "arw", "aravak" },
            { "asa", "asu" },
            { "ast", "asztúr" },
            { "atj", "attikamek" },
            { "awa", "awádi" },
            { "bal", "balucsi" },
            { "ban", "balinéz" },
            { "bas", "basza" },
            { "bax", "bamun" },
            { "bbj", "gomala" },
            { "bej", "bedzsa" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bgc", "haryanvi" },
            { "bgn", "nyugati beludzs" },
            { "bho", "bodzspuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "blo", "anii" },
            { "bra", "braj" },
            { "brx", "bodo" },
            { "bss", "koszi" },
            { "bua", "burját" },
            { "bug", "buginéz" },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "karib" },
            { "cay", "kajuga" },
            { "cch", "atszam" },
            { "ccp", "csakma" },
            { "ceb", "szebuano" },
            { "cgg", "kiga" },
            { "chb", "csibcsa" },
            { "chg", "csagatáj" },
            { "chk", "csukéz" },
            { "chm", "mari" },
            { "chn", "csinuk zsargon" },
            { "cho", "csoktó" },
            { "chp", "csipevé" },
            { "chr", "cseroki" },
            { "chy", "csejen" },
            { "ckb", "közép-ázsiai kurd" },
            { "clc", "csilkotin" },
            { "cop", "kopt" },
            { "crg", "micsif" },
            { "crh", "krími tatár" },
            { "crj", "délkeleti krí" },
            { "crk", "síksági krí" },
            { "crl", "északkeleti krí" },
            { "crm", "moose krí" },
            { "crr", "karolinai algonkin" },
            { "crs", "szeszelva kreol francia" },
            { "csb", "kasub" },
            { "csw", "mocsári krí" },
            { "dak", "dakota" },
            { "dar", "dargva" },
            { "dav", "taita" },
            { "del", "delavár" },
            { "den", "szlevi" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "alsó-szorb" },
            { "dua", "duala" },
            { "dum", "közép holland" },
            { "dyo", "jola-fonyi" },
            { "dyu", "diula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "óegyiptomi" },
            { "eka", "ekadzsuk" },
            { "elx", "elamit" },
            { "enm", "közép angol" },
            { "ewo", "evondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filippínó" },
            { "fon", "fon" },
            { "frc", "cajun francia" },
            { "frm", "közép francia" },
            { "fro", "ófrancia" },
            { "frr", "északi fríz" },
            { "frs", "keleti fríz" },
            { "fur", "friuli" },
            { "gaa", "ga" },
            { "gag", "gagauz" },
            { "gan", "gan kínai" },
            { "gay", "gajo" },
            { "gba", "gbaja" },
            { "gez", "geez" },
            { "gil", "ikiribati" },
            { "gmh", "közép felső német" },
            { "goh", "ófelső német" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", "gót" },
            { "grb", "grebó" },
            { "grc", "ógörög" },
            { "gsw", "svájci német" },
            { "guz", "guszii" },
            { "gwi", "gvicsin" },
            { "hai", "haida" },
            { "hak", "hakka kínai" },
            { "haw", "hawaii" },
            { "hax", "déli haida" },
            { "hil", "ilokano" },
            { "hit", "hettita" },
            { "hmn", "hmong" },
            { "hsb", "felső-szorb" },
            { "hsn", "xiang kínai" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "nyugat-kanadai inuit" },
            { "ilo", "ilokó" },
            { "inh", "ingus" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "zsidó-perzsa" },
            { "jrb", "zsidó-arab" },
            { "kaa", "kara-kalpak" },
            { "kab", "kabije" },
            { "kac", "kacsin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardi" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kabuverdianu" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "kaszi" },
            { "kho", "kotanéz" },
            { "khq", "kojra-csíni" },
            { "kkj", "kakó" },
            { "kln", "kalendzsin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permják" },
            { "kok", "konkani" },
            { "kos", "kosrei" },
            { "kpe", "kpelle" },
            { "krc", "karacsáj-balkár" },
            { "krl", "karelai" },
            { "kru", "kuruh" },
            { "ksb", "sambala" },
            { "ksf", "bafia" },
            { "ksh", "kölsch" },
            { "kum", "kumük" },
            { "kut", "kutenai" },
            { "kwk", "kwakʼwala" },
            { "kxv", "kuvi" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezg" },
            { "lij", "ligur" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lmo", "lombard" },
            { "lol", "mongó" },
            { "lou", "louisianai kreol" },
            { "loz", "lozi" },
            { "lrc", "északi luri" },
            { "lsm", "samia" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "lus", "lushai" },
            { "luy", "lujia" },
            { "mad", "madurai" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makaszar" },
            { "man", "mandingó" },
            { "mas", "masai" },
            { "mde", "maba" },
            { "mdf", "moksán" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "mauritiusi kreol" },
            { "mga", "közép ír" },
            { "mgh", "makua-metó" },
            { "mgo", "meta’" },
            { "mic", "mikmak" },
            { "min", "minangkabau" },
            { "mnc", "mandzsu" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "moszi" },
            { "mua", "mundang" },
            { "mul", "többszörös nyelvek" },
            { "mus", "krík" },
            { "mwl", "mirandéz" },
            { "mwr", "márvári" },
            { "mye", "myene" },
            { "myv", "erzjány" },
            { "mzn", "mázanderáni" },
            { "nan", "min nan kínai" },
            { "nap", "nápolyi" },
            { "naq", "nama" },
            { "nds", "alsónémet" },
            { "new", "nevari" },
            { "nia", "nias" },
            { "niu", "niuei" },
            { "nmg", "ngumba" },
            { "nnh", "ngiemboon" },
            { "nog", "nogaj" },
            { "non", "óskandináv" },
            { "nqo", "n’kó" },
            { "nso", "északi szeszotó" },
            { "nus", "nuer" },
            { "nwc", "klasszikus newari" },
            { "nym", "nyamvézi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoró" },
            { "nzi", "nzima" },
            { "ojb", "északnyugati odzsibva" },
            { "ojc", "középvidéki odzsibva" },
            { "ojs", "odzsi-krí" },
            { "ojw", "nyugati odzsibva" },
            { "oka", "okanagan" },
            { "osa", "osage" },
            { "ota", "oszmán-török" },
            { "pag", "pangaszinan" },
            { "pal", "pahlavi" },
            { "pam", "pampangan" },
            { "pap", "papiamento" },
            { "pau", "palaui" },
            { "pcm", "nigériai pidgin" },
            { "peo", "óperzsa" },
            { "phn", "főniciai" },
            { "pis", "pidzsin" },
            { "pon", "pohnpei" },
            { "pqm", "maliseet-passamaquoddy" },
            { "prg", "porosz" },
            { "pro", "óprovánszi" },
            { "quc", "kicse" },
            { "raj", "radzsasztáni" },
            { "rap", "rapanui" },
            { "rar", "rarotongai" },
            { "rhg", "rohingja" },
            { "rof", "rombo" },
            { "rom", "roma" },
            { "rup", "aromán" },
            { "rwk", "rwo" },
            { "sad", "szandave" },
            { "sah", "szaha" },
            { "sam", "szamaritánus arámi" },
            { "saq", "szamburu" },
            { "sas", "sasak" },
            { "sat", "szantáli" },
            { "sba", "ngambay" },
            { "sbp", "szangu" },
            { "scn", "szicíliai" },
            { "sco", "skót" },
            { "sdh", "dél-kurd" },
            { "see", "szeneka" },
            { "seh", "szena" },
            { "sel", "szölkup" },
            { "ses", "kojra-szenni" },
            { "sga", "óír" },
            { "shi", "tachelhit" },
            { "shn", "san" },
            { "shu", "csádi arab" },
            { "sid", "szidamó" },
            { "slh", "déli lushootseed" },
            { "sma", "déli számi" },
            { "smj", "lulei számi" },
            { "smn", "inari számi" },
            { "sms", "kolta számi" },
            { "snk", "szoninke" },
            { "sog", "sogdien" },
            { "srn", "szranai tongó" },
            { "srr", "szerer" },
            { "ssy", "szahó" },
            { "str", "szorosmenti salish" },
            { "suk", "szukuma" },
            { "sus", "szuszu" },
            { "sux", "sumér" },
            { "swb", "comorei" },
            { "syc", "klasszikus szír" },
            { "syr", "szír" },
            { "szl", "sziléziai" },
            { "tce", "déli tutchone" },
            { "tem", "temne" },
            { "teo", "teszó" },
            { "ter", "terenó" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigré" },
            { "tiv", "tiv" },
            { "tkl", "tokelaui" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tmh", "tamasek" },
            { "tog", "nyugati nyasza" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "tarokó" },
            { "tsi", "csimsiáni" },
            { "ttm", "északi tutchone" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "szavák" },
            { "tyv", "tuvai" },
            { "tzm", "közép-atlaszi tamazigt" },
            { "udm", "udmurt" },
            { "uga", "ugariti" },
            { "umb", "umbundu" },
            { "und", "ismeretlen nyelv" },
            { "vec", "velencei" },
            { "vmw", "makua" },
            { "vot", "votják" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "valamo" },
            { "war", "varaó" },
            { "was", "vasó" },
            { "wbp", "warlpiri" },
            { "wuu", "wu kínai" },
            { "xal", "kalmük" },
            { "xnr", "kangri" },
            { "xog", "szoga" },
            { "yao", "jaó" },
            { "yap", "japi" },
            { "yav", "jangben" },
            { "ybb", "jemba" },
            { "yrl", "nheengatu" },
            { "yue", "kantoni" },
            { "zap", "zapoték" },
            { "zbl", metaValue_zbl },
            { "zen", "zenaga" },
            { "zgh", "marokkói tamazight" },
            { "zun", "zuni" },
            { "zxx", "nincs nyelvészeti tartalom" },
            { "zza", "zaza" },
            { "Adlm", "Adlam" },
            { "Aghb", "Kaukázusi albaniai" },
            { "Aran", "Nasztalik" },
            { "Armi", "Birodalmi arámi" },
            { "Armn", "Örmény" },
            { "Avst", "Avesztán" },
            { "Bali", "Balinéz" },
            { "Batk", "Batak" },
            { "Beng", "Bengáli" },
            { "Blis", metaValue_zbl },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brámi" },
            { "Brai", "Vakírás" },
            { "Bugi", "Buginéz" },
            { "Buhd", "Buhid" },
            { "Cakm", "Csakma" },
            { "Cans", "Egyesített kanadai őslakos jelek" },
            { "Cari", "Kari" },
            { "Cham", "Csám" },
            { "Cher", "Cseroki" },
            { "Copt", "Kopt" },
            { "Cpmn", "Ciprusi-minószi" },
            { "Cprt", "Ciprusi" },
            { "Cyrl", "Cirill" },
            { "Cyrs", "Óegyházi szláv cirill" },
            { "Deva", "Devanagári" },
            { "Dsrt", "Deseret" },
            { "Egyd", "Egyiptomi demotikus" },
            { "Egyh", "Egyiptomi hieratikus" },
            { "Egyp", "Egyiptomi hieroglifák" },
            { "Ethi", "Etióp" },
            { "Geok", "Grúz kucsuri" },
            { "Geor", "Grúz" },
            { "Glag", "Glagolitikus" },
            { "Goth", "Gót" },
            { "Grek", "Görög" },
            { "Gujr", "Gudzsaráti" },
            { "Guru", "Gurmuki" },
            { "Hanb", "Han bopomofóval" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hano", "Hanunoo" },
            { "Hans", "Egyszerűsített" },
            { "Hant", metaValue_Hant },
            { "Hebr", "Héber" },
            { "Hira", "Hiragana" },
            { "Hluw", "Anatóliai hieroglifák" },
            { "Hmng", "Pahawh hmong" },
            { "Hrkt", "Katakana vagy hiragana" },
            { "Hung", "Ómagyar" },
            { "Inds", "Indus" },
            { "Ital", "Régi olasz" },
            { "Java", "Jávai" },
            { "Jpan", metaValue_JP },
            { "Kali", "Kajah li" },
            { "Kana", "Katakana" },
            { "Khar", "Kharoshthi" },
            { "Khmr", "Khmer" },
            { "Knda", "Kannada" },
            { "Kore", "Koreai" },
            { "Kthi", "Kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", "Lao" },
            { "Latf", "Fraktur latin" },
            { "Latg", "Gael latin" },
            { "Latn", "Latin" },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Lineáris A" },
            { "Linb", "Lineáris B" },
            { "Lyci", "Líciai" },
            { "Lydi", "Lídiai" },
            { "Mand", "Mandai" },
            { "Mani", "Manicheus" },
            { "Maya", "Maja hieroglifák" },
            { "Mero", "Meroitikus" },
            { "Mlym", "Malajálam" },
            { "Mong", "Mongol" },
            { "Moon", "Moon" },
            { "Mtei", "Meitei mayek" },
            { "Mymr", "Burmai" },
            { "Nbat", "Nabateus" },
            { "Nkoo", "N’ko" },
            { "Ogam", "Ogham" },
            { "Olck", "Ol chiki" },
            { "Orkh", "Orhon" },
            { "Orya", "Oriya" },
            { "Osma", "Oszmán" },
            { "Perm", "Ópermikus" },
            { "Phag", "Phags-pa" },
            { "Phli", "Felriatos pahlavi" },
            { "Phlp", "Psalter pahlavi" },
            { "Phlv", "Könyv pahlavi" },
            { "Phnx", "Főniciai" },
            { "Plrd", "Pollard fonetikus" },
            { "Prti", "Feliratos parthian" },
            { "Qaag", "Zawgyi" },
            { "Rjng", "Redzsang" },
            { "Rohg", "Hanifi" },
            { "Roro", "Rongorongo" },
            { "Runr", "Runikus" },
            { "Samr", "Szamaritán" },
            { "Sara", "Szarati" },
            { "Saur", "Szaurastra" },
            { "Sgnw", "Jelírás" },
            { "Shaw", "Shaw ábécé" },
            { "Sidd", "Sziddham" },
            { "Sinh", "Szingaléz" },
            { "Sogd", "Szogd" },
            { "Sogo", "Ószogd" },
            { "Sund", "Szundanéz" },
            { "Sylo", "Sylheti nagári" },
            { "Syrc", "Szíriai" },
            { "Syre", "Estrangelo szíriai" },
            { "Syrj", "Nyugat-szíriai" },
            { "Syrn", "Kelet-szíriai" },
            { "Tagb", "Tagbanwa" },
            { "Tale", "Tai Le" },
            { "Talu", "Új tai lue" },
            { "Taml", "Tamil" },
            { "Tavt", "Tai viet" },
            { "Telu", "Telugu" },
            { "Teng", "Tengwar" },
            { "Tfng", "Berber" },
            { "Tglg", "Tagalog" },
            { "Thaa", "Thaana" },
            { "Tibt", "Tibeti" },
            { "Ugar", "Ugari" },
            { "Vaii", "Vai" },
            { "Visp", "Látható beszéd" },
            { "Xpeo", "Óperzsa" },
            { "Xsux", "Ékírásos suméro-akkád" },
            { "Yiii", "Ji" },
            { "Zinh", "Származtatott" },
            { "Zmth", "Matematikai jelrendszer" },
            { "Zsye", "Emoji" },
            { "Zsym", "Szimbólum" },
            { "Zxxx", "Íratlan nyelvek kódja" },
            { "Zyyy", "Meghatározatlan" },
            { "Zzzz", "Ismeretlen írásrendszer" },
            { "de_AT", "osztrák német" },
            { "de_CH", "svájci felnémet" },
            { "en_AU", "ausztrál angol" },
            { "en_CA", "kanadai angol" },
            { "en_GB", "brit angol" },
            { "en_US", "amerikai angol" },
            { "es_ES", "európai spanyol" },
            { "es_MX", "spanyol (mexikói)" },
            { "fa_AF", "dari" },
            { "fr_CA", "kanadai francia" },
            { "fr_CH", "svájci francia" },
            { "nl_BE", "flamand" },
            { "pt_BR", "brazíliai portugál" },
            { "pt_PT", "európai portugál" },
            { "ro_MD", "moldvai" },
            { "sw_CD", "kongói szuahéli" },
            { "%%1901", "Hagyományos német helyesírás" },
            { "%%1994", "Szabványosított reziján helyesírás" },
            { "%%1996", "1996-os német helyesírás" },
            { "ar_001", "modern szabványos arab" },
            { "es_419", "latin-amerikai spanyol" },
            { "key.ca", "Naptár" },
            { "key.cf", "Pénznemformátum" },
            { "key.co", "Rendezési sorrend" },
            { "key.cu", "Pénznem" },
            { "key.hc", "Óraformátum (12 – 24)" },
            { "key.lb", "Sortörés stílusa" },
            { "key.ms", "Mértékegységrendszer" },
            { "key.nu", "Számok" },
            { "key.tz", "Időzóna" },
            { "key.va", "Földrajzi helyvariáns" },
            { "nds_NL", "alsószász" },
            { "%%ALUKU", "Aluku dialektus" },
            { "%%BISKE", "San Giorgo/Bila tájszólás" },
            { "%%BOONT", "Boontling" },
            { "%%JAUER", "Jauer" },
            { "%%KKCOR", "Meghatározatlan helyesírás" },
            { "%%LIPAW", "Reziján lipovaz tájszólás" },
            { "%%NEDIS", "Natisone dialektus" },
            { "%%NJIVA", "Gniva/Njiva tájszólás" },
            { "%%OSOJS", "Oseacco/Osojane tájszólás" },
            { "%%POSIX", "Számítógép" },
            { "%%PUTER", "Puter" },
            { "%%ROZAJ", "Reziján" },
            { "%%RUMGR", "Rumgr" },
            { "%%SAAHO", "Saho" },
            { "%%SOLBA", "Stolvizza/Solbica tájszólás" },
            { "%%UCCOR", "Egyesített helyesírás" },
            { "hi_Latn", "hindi (latin)" },
            { "zh_Hans", "egyszerűsített kínai" },
            { "zh_Hant", "hagyományos kínai" },
            { "%%FONIPA", "IPA fonetika" },
            { "%%FONUPA", "UPA fonetika" },
            { "%%NDYUKA", "Ndyuka dialektus" },
            { "%%PAMAKA", "Pamaka dialektus" },
            { "%%PINYIN", "pinjin átírás" },
            { "%%SCOUSE", "Scouse" },
            { "%%TARASK", "Taraskijevica helyesírás" },
            { "%%UCRCOR", "Egyesített átdolgozott helyesírás" },
            { "%%ULSTER", "Ulster" },
            { "%%ALALC97", "ALA-LC romanizáció, 1997-es kiadás" },
            { "%%AREVELA", "Keleti örmény" },
            { "%%AREVMDA", "Nyugati örmény" },
            { "%%BAUDDHA", "Bauddha" },
            { "%%HEPBURN", "Hepburn romanizáció" },
            { "%%ITIHASA", "Itihasa" },
            { "%%LAUKIKA", "Laukika" },
            { "%%MONOTON", "Monoton" },
            { "%%POLYTON", "Politonikus" },
            { "%%REVISED", "Átdolgozott helyesírás" },
            { "%%SURSILV", "Sursilv" },
            { "%%SUTSILV", "Sutsilv" },
            { "%%VAIDIKA", "Vaidika" },
            { "%%1606NICT", "Késői közép francia 1606-ig" },
            { "%%1694ACAD", "Korai modern francia" },
            { "%%1959ACAD", "Akadémiai" },
            { "%%BAKU1926", "Egyesített türkic latin ábécé" },
            { "%%BISCAYAN", "Biszkajan" },
            { "%%FONXSAMP", "Fonxsamp" },
            { "%%HOGNORSK", "Hongorszk" },
            { "%%JYUTPING", "Jyutping" },
            { "%%LUNA1918", "Luna1918" },
            { "%%PETR1708", "Petr1708" },
            { "%%SCOTLAND", "Skót szabványos angol" },
            { "%%SURMIRAN", "Surmiran" },
            { "%%VALENCIA", "Valencia" },
            { "%%VALLADER", "Vallader" },
            { "%%WADEGILE", "Wade-Giles átírás" },
            { "type.ca.roc", "Kínai köztársasági naptár" },
            { "type.co.eor", "Európai rendezési szabályok" },
            { "type.hc.h11", "12 órás rendszer (0–11)" },
            { "type.hc.h12", "12 órás rendszer (0–12)" },
            { "type.hc.h23", "24 órás rendszer (0–23)" },
            { "type.hc.h24", "24 órás rendszer (0–24)" },
            { "type.m0.bgn", "BGN" },
            { "type.nu.arab", "Arab-indiai számjegyek" },
            { "type.nu.armn", "Örmény számok" },
            { "type.nu.beng", "Bengáli számjegyek" },
            { "type.nu.cakm", "Csakma számjegyek" },
            { "type.nu.deva", "Dévanágari számjegyek" },
            { "type.nu.ethi", "Etióp számok" },
            { "type.nu.geor", "Grúz számok" },
            { "type.nu.grek", "Görög számok" },
            { "type.nu.gujr", "Gudzsaráti számjegyek" },
            { "type.nu.guru", "Gurmuki számjegyek" },
            { "type.nu.hans", "Egyszerűsített kínai számok" },
            { "type.nu.hant", "Hagyományos kínai számok" },
            { "type.nu.hebr", "Héber számok" },
            { "type.nu.java", "Jávai számjegyek" },
            { "type.nu.jpan", "Japán számok" },
            { "type.nu.khmr", "Khmer számjegyek" },
            { "type.nu.knda", "Kannada számjegyek" },
            { "type.nu.laoo", "Lao számjegyek" },
            { "type.nu.latn", "Nyugati számjegyek" },
            { "type.nu.mlym", "Malajálam számjegyek" },
            { "type.nu.mong", "Mongol számjegyek" },
            { "type.nu.mtei", "Meitei Mayek számjegyek" },
            { "type.nu.mymr", "Mianmari számjegyek" },
            { "type.nu.olck", "Ol Chiki számjegyek" },
            { "type.nu.orya", "Orija számjegyek" },
            { "type.nu.taml", "Hagyományos tamil számjegyek" },
            { "type.nu.telu", "Telugu számjegyek" },
            { "type.nu.thai", "Thai számjegyek" },
            { "type.nu.tibt", "Tibeti számjegyek" },
            { "type.nu.vaii", "Vai számjegyek" },
            { "type.ca.dangi", "Dangi naptár" },
            { "type.co.ducet", "Alapértelmezett Unicode rendezési sorrend" },
            { "type.co.emoji", "Emodzsi rendezési sorrend" },
            { "type.lb.loose", "Tág stílusú sortörés" },
            { "type.nu.roman", "Római számok" },
            { "type.ca.coptic", "Kopt naptár" },
            { "type.ca.hebrew", "Héber naptár" },
            { "type.ca.indian", "Indiai nemzeti naptár" },
            { "type.co.compat", "Előző rendezési sorrend a kompatibilitás érdekében" },
            { "type.co.pinyin", "Pinyin sorrend" },
            { "type.co.search", "Általános célú keresés" },
            { "type.co.stroke", "Vonássorrend" },
            { "type.co.unihan", "Szótővonás rendezési sorrend" },
            { "type.co.zhuyin", "Zujin rendezési sorrend" },
            { "type.d0.fwidth", "Teljes szélesség" },
            { "type.d0.hwidth", "Fél szélesség" },
            { "type.lb.normal", "Normál stílusú sortörés" },
            { "type.lb.strict", "Szűk stílusú sortörés" },
            { "type.m0.ungegn", "UNGEGN" },
            { "type.ms.metric", "Méterrendszer" },
            { "type.nu.native", "Natív számjegyek" },
            { "type.ca.chinese", "Kínai naptár" },
            { "type.ca.islamic", "Hidzsra naptár" },
            { "type.ca.iso8601", "ISO-8601 naptár" },
            { "type.ca.persian", "Perzsa naptár" },
            { "type.cf.account", "Könyvelési pénznemformátum" },
            { "type.co.big5han", "Hagyományos kínai sorrend - Big5" },
            { "type.d0.npinyin", "Szám" },
            { "type.nu.arabext", "Kibővített arab-indiai számjegyek" },
            { "type.nu.armnlow", "Örmény kisbetűs számok" },
            { "type.nu.finance", "Pénzügyi számok" },
            { "type.nu.greklow", "Görög kisbetűs számok" },
            { "type.nu.hanidec", "Kínai tizedes számok" },
            { "type.nu.hansfin", "Egyszerűsített kínai pénzügyi számok" },
            { "type.nu.hantfin", "Hagyományos kínai pénzügyi számok" },
            { "type.nu.jpanfin", "Japán pénzügyi számok" },
            { "type.nu.tamldec", "Tamil számjegyek" },
            { "type.ca.buddhist", "Buddhista naptár" },
            { "type.ca.ethiopic", "Etióp naptár" },
            { "type.ca.japanese", "Japán naptár" },
            { "type.cf.standard", "Normál pénznemformátum" },
            { "type.co.phonetic", "Fonetikus rendezési sorrend" },
            { "type.co.searchjl", "Keresés hangul kezdő mássalhangzó szerint" },
            { "type.co.standard", "Normál rendezési sorrend" },
            { "type.ms.uksystem", "Angolszász mértékegységrendszer" },
            { "type.ms.ussystem", "Amerikai mértékegységrendszer" },
            { "type.nu.fullwide", "Teljes szélességű számjegyek" },
            { "type.nu.romanlow", "Római kisbetűs számok" },
            { "type.ca.gregorian", "Gergely-naptár" },
            { "type.co.gb2312han", "Egyszerűsített kínai sorrend - GB2312" },
            { "type.co.phonebook", "Telefonkönyv sorrend" },
            { "type.co.dictionary", "Szótári rendezési sorrend" },
            { "type.co.traditional", metaValue_Hant },
            { "type.nu.traditional", "Hagyományos számok" },
            { "type.ca.islamic-civil", "Hidzsra naptár (táblázatos, polgári)" },
            { "type.ca.islamic-umalqura", "Hidzsra naptár (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Etióp amete alem naptár" },
        };
        return data;
    }
}
