/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_ne extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_generic_narrow_AmPmMarkers = new String[] {
            "\u092a\u0942\u0930\u094d\u0935\u093e\u0939\u094d\u0928",
            "\u0905\u092a\u0930\u093e\u0939\u094d\u0928",
            "\u092e\u0927\u094d\u092f\u0930\u093e\u0924",
            "\u092e\u0927\u094d\u092f\u093e\u0928\u094d\u0939",
            "\u092c\u093f\u0939\u093e\u0928",
            "",
            "\u0905\u092a\u0930\u093e\u0928\u094d\u0939",
            "\u0938\u093e\u0901\u091d",
            "\u092c\u0947\u0932\u0941\u0915\u0940",
            "",
            "\u0930\u093e\u0924",
            "",
        };
        final String[] metaValue_MonthNames = new String[] {
            "\u091c\u0928\u0935\u0930\u0940",
            "\u092b\u0947\u092c\u094d\u0930\u0941\u0905\u0930\u0940",
            "\u092e\u093e\u0930\u094d\u091a",
            "\u0905\u092a\u094d\u0930\u093f\u0932",
            "\u092e\u0947",
            "\u091c\u0941\u0928",
            "\u091c\u0941\u0932\u093e\u0908",
            "\u0905\u0917\u0938\u094d\u091f",
            "\u0938\u0947\u092a\u094d\u091f\u0947\u092e\u094d\u092c\u0930",
            "\u0905\u0915\u094d\u091f\u094b\u092c\u0930",
            "\u0928\u094b\u092d\u0947\u092e\u094d\u092c\u0930",
            "\u0921\u093f\u0938\u0947\u092e\u094d\u092c\u0930",
            "",
        };
        final String[] metaValue_generic_DayNames = new String[] {
            "\u0906\u0907\u0924\u092c\u093e\u0930",
            "\u0938\u094b\u092e\u092c\u093e\u0930",
            "\u092e\u0919\u094d\u0917\u0932\u092c\u093e\u0930",
            "\u092c\u0941\u0927\u092c\u093e\u0930",
            "\u092c\u093f\u0939\u093f\u092c\u093e\u0930",
            "\u0936\u0941\u0915\u094d\u0930\u092c\u093e\u0930",
            "\u0936\u0928\u093f\u092c\u093e\u0930",
        };
        final String[] metaValue_generic_DayAbbreviations = new String[] {
            "\u0906\u0907\u0924",
            "\u0938\u094b\u092e",
            "\u092e\u0919\u094d\u0917\u0932",
            "\u092c\u0941\u0927",
            "\u092c\u093f\u0939\u093f",
            "\u0936\u0941\u0915\u094d\u0930",
            "\u0936\u0928\u093f",
        };
        final String[] metaValue_generic_DayNarrows = new String[] {
            "\u0906",
            "\u0938\u094b",
            "\u092e",
            "\u092c\u0941",
            "\u092c\u093f",
            "\u0936\u0941",
            "\u0936",
        };
        final String[] metaValue_generic_QuarterNames = new String[] {
            "\u092a\u0939\u093f\u0932\u094b \u0924\u094d\u0930\u0948\u092e\u093e\u0938\u093f\u0915",
            "\u0926\u094b\u0938\u094d\u0930\u094b \u0924\u094d\u0930\u0948\u092e\u093e\u0938\u093f\u0915",
            "\u0924\u0947\u0938\u094d\u0930\u094b \u0924\u094d\u0930\u0948\u092e\u093e\u0938\u093f\u0915",
            "\u091a\u094c\u0925\u094b \u0924\u094d\u0930\u0948\u092e\u093e\u0938\u093f\u0915",
        };
        final String[] metaValue_QuarterNarrows = new String[] {
            "\u0967",
            "\u0968",
            "\u0969",
            "\u096a",
        };
        final String[] metaValue_java_time_long_Eras = new String[] {
            "\u0908\u0938\u093e \u092a\u0942\u0930\u094d\u0935",
            "\u0938\u0928\u094d",
        };
        final String[] metaValue_generic_TimePatterns = new String[] {
            "HH:mm:ss zzzz",
            "HH:mm:ss z",
            "HH:mm:ss",
            "HH:mm",
        };
        final String metaValue_generic_DateFormatItem_yw = "Y \u0915\u094b w \u0939\u092a\u094d\u0924\u093e";
        final String metaValue_generic_DateFormatItem_GyMd = "M/d/y G";
        final String metaValue_generic_DateFormatItem_MMMMW = "MMMM \u0915\u094b W \u0939\u092a\u094d\u0924\u093e";
        final String metaValue_generic_DateFormatItem_Ed = "d E";
        final String[] metaValue_MonthNarrows = new String[] {
            "\u091c\u0928",
            "\u092b\u0947\u092c",
            "\u092e\u093e\u0930\u094d\u091a",
            "\u0905\u092a\u094d\u0930",
            "\u092e\u0947",
            "\u091c\u0941\u0928",
            "\u091c\u0941\u0932",
            "\u0905\u0917",
            "\u0938\u0947\u092a",
            "\u0905\u0915\u094d\u091f\u094b",
            "\u0928\u094b\u092d\u0947",
            "\u0921\u093f\u0938\u0947",
            "",
        };
        final String[] metaValue_java_time_generic_DatePatterns = new String[] {
            "G y MMMM d, EEEE",
            "G y MMMM d",
            "G y MMM d",
            "GGGGG y-MM-dd",
        };
        final String[] metaValue_generic_DatePatterns = new String[] {
            "GGGG y MMMM d, EEEE",
            "GGGG y MMMM d",
            "GGGG y MMM d",
            "G y-MM-dd",
        };
        final String metaValue_calendarname_gregorian = "\u0917\u094d\u0930\u0947\u0917\u094b\u0930\u093f\u092f\u0928 \u092a\u093e\u0924\u094d\u0930\u094b";
        final String[] metaValue_ListPatterns_standard = new String[] {
            "{0},{1}",
            "",
            "{0} \u0930 {1}",
            "{0} \u0930 {1}",
            "",
        };
        final String[] metaValue_ListPatterns_or = new String[] {
            "",
            "",
            "{0}, \u0935\u093e {1}",
            "{0} \u0935\u093e {1}",
            "",
        };
        final Object[][] data = new Object[][] {
            { "generic.DayNames", metaValue_generic_DayNames },
            { "generic.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "generic.DayNarrows", metaValue_generic_DayNarrows },
            { "generic.QuarterNames", metaValue_generic_QuarterNames },
            { "generic.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "generic.abbreviated.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "generic.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.generic.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "generic.DatePatterns", metaValue_generic_DatePatterns },
            { "generic.DateTimePatterns",
                new String[] {
                    "{1}, {0}",
                    "{1}, {0}",
                    "{1},{0}",
                    "{1},{0}",
                }
            },
            { "generic.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "generic.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_GyMd },
            { "generic.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "generic.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "generic.DateFormatItem.MEd", "MM/dd, E" },
            { "MonthNames", metaValue_MonthNames },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "MonthAbbreviations", metaValue_MonthNames },
            { "standalone.MonthAbbreviations", metaValue_MonthNames },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "standalone.MonthNarrows",
                new String[] {
                    "\u091c\u0928",
                    "\u092b\u0947\u0947\u092c",
                    "\u092e\u093e\u0930\u094d\u091a",
                    "\u0905\u092a\u094d\u0930",
                    "\u092e\u0947",
                    "\u091c\u0941\u0928",
                    "\u091c\u0941\u0932",
                    "\u0905\u0917",
                    "\u0938\u0947\u092a",
                    "\u0905\u0915\u094d\u091f\u094b",
                    "\u0928\u094b\u092d\u0947",
                    "\u0921\u093f\u0938\u0947",
                    "",
                }
            },
            { "DayNames", metaValue_generic_DayNames },
            { "standalone.DayNames", metaValue_generic_DayNames },
            { "DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "standalone.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "DayNarrows", metaValue_generic_DayNarrows },
            { "standalone.DayNarrows", metaValue_generic_DayNarrows },
            { "QuarterNames", metaValue_generic_QuarterNames },
            { "standalone.QuarterNames",
                new String[] {
                    "\u092a\u094d\u0930\u0925\u092e \u0924\u094d\u0930\u0948\u092e\u093e\u0938\u093f\u0915",
                    "\u0926\u094d\u0935\u093f\u0924\u0940\u092f \u0924\u094d\u0930\u0948\u092e\u093e\u0938\u093f\u0915",
                    "\u0924\u0943\u0924\u0940\u092f \u0924\u094d\u0930\u0948\u092e\u093e\u0938\u093f\u0915",
                    "\u091a\u0924\u0941\u0930\u094d\u0925 \u0924\u094d\u0930\u0948\u092e\u093e\u0938\u093f\u0915",
                }
            },
            { "QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "QuarterNarrows", metaValue_QuarterNarrows },
            { "standalone.QuarterNarrows", metaValue_QuarterNarrows },
            { "AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "abbreviated.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "java.time.long.Eras", metaValue_java_time_long_Eras },
            { "long.Eras", metaValue_java_time_long_Eras },
            { "java.time.Eras", metaValue_java_time_long_Eras },
            { "Eras", metaValue_java_time_long_Eras },
            { "java.time.narrow.Eras", metaValue_java_time_long_Eras },
            { "narrow.Eras", metaValue_java_time_long_Eras },
            { "field.era", "\u0915\u093e\u0932" },
            { "field.year", "\u0935\u0930\u094d\u0937" },
            { "field.month", "\u092e\u0939\u093f\u0928\u093e" },
            { "field.week", "\u0939\u092a\u094d\u0924\u093e" },
            { "field.weekday", "\u0939\u092a\u094d\u0924\u093e\u0915\u094b \u092c\u093e\u0930" },
            { "field.dayperiod", "\u092a\u0942\u0930\u094d\u0935\u093e\u0939\u094d\u0928 / \u0905\u092a\u0930\u093e\u0939\u094d\u0928" },
            { "field.hour", "\u0918\u0923\u094d\u091f\u093e" },
            { "timezone.regionFormat", "{0} \u0938\u092e\u092f" },
            { "timezone.regionFormat.daylight", "{0} (+\u0967)" },
            { "timezone.regionFormat.standard", "{0} (+\u0966)" },
            { "field.minute", "\u092e\u093f\u0928\u0947\u091f" },
            { "field.second", "\u0938\u0947\u0915\u0947\u0928\u094d\u0921" },
            { "field.zone", "\u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "TimePatterns", metaValue_generic_TimePatterns },
            { "DatePatterns",
                new String[] {
                    "y MMMM d, EEEE",
                    "y MMMM d",
                    "y MMM d",
                    "yy/M/d",
                }
            },
            { "DateTimePatterns",
                new String[] {
                    "{1} {0}",
                    "{1} {0}",
                    "{1}, {0}",
                    "{1}, {0}",
                }
            },
            { "PluralRules", "one:n = 1" },
            { "DayPeriodRules", "midnight:00:00;noon:12:00;night1:22:00-04:00;afternoon1:12:00-16:00;morning1:04:00-12:00;afternoon2:16:00-19:00;evening1:19:00-22:00" },
            { "DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "DateFormatItem.GyMd", metaValue_generic_DateFormatItem_GyMd },
            { "DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.DayNames", metaValue_generic_DayNames },
            { "buddhist.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "buddhist.QuarterNames", metaValue_generic_QuarterNames },
            { "buddhist.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "buddhist.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "buddhist.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "buddhist.DatePatterns", metaValue_generic_DatePatterns },
            { "buddhist.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "buddhist.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_GyMd },
            { "buddhist.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "buddhist.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "japanese.MonthAbbreviations", metaValue_MonthNames },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DayNames", metaValue_generic_DayNames },
            { "japanese.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "japanese.QuarterNames", metaValue_generic_QuarterNames },
            { "japanese.QuarterNarrows", metaValue_QuarterNarrows },
            { "japanese.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "japanese.abbreviated.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "japanese.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.japanese.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "japanese.DatePatterns", metaValue_generic_DatePatterns },
            { "japanese.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "japanese.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_GyMd },
            { "japanese.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "japanese.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "roc.MonthNames", metaValue_MonthNames },
            { "roc.MonthAbbreviations", metaValue_MonthNames },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "roc.DayNames", metaValue_generic_DayNames },
            { "roc.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "roc.DayNarrows", metaValue_generic_DayNarrows },
            { "roc.QuarterNames", metaValue_generic_QuarterNames },
            { "roc.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.abbreviated.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "roc.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.roc.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "roc.DatePatterns", metaValue_generic_DatePatterns },
            { "roc.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "roc.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_GyMd },
            { "roc.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "roc.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "islamic.DayNames", metaValue_generic_DayNames },
            { "islamic.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "islamic.QuarterNames", metaValue_generic_QuarterNames },
            { "islamic.abbreviated.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "islamic.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.islamic.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "islamic.DatePatterns", metaValue_generic_DatePatterns },
            { "islamic.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "islamic.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_GyMd },
            { "islamic.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "islamic.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "islamic-civil.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "islamic-civil.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_GyMd },
            { "islamic-civil.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "islamic-civil.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "islamic-umalqura.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "islamic-umalqura.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_GyMd },
            { "islamic-umalqura.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "islamic-umalqura.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "calendarname.islamic-civil", "\u0939\u093f\u091c\u0930\u0940 \u092a\u093e\u0924\u094d\u0930\u094b (\u091f\u0947\u092c\u0941\u0932\u0930, \u0928\u093e\u0917\u0930\u093f\u0915 \u092f\u0941\u0917)" },
            { "calendarname.islamic", "\u0939\u093f\u091c\u0930\u0940 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "calendarname.buddhist", "\u092c\u0941\u0926\u094d\u0927\u093f\u0937\u094d\u091f \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "calendarname.japanese", "\u091c\u093e\u092a\u093e\u0928\u0940 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "calendarname.roc", "\u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0917\u0923\u0924\u0928\u094d\u0924\u094d\u0930\u0915\u094b \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "calendarname.islamic-umalqura", "\u0907\u0938\u094d\u0932\u093e\u092e\u0940 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
            { "DefaultNumberingSystem", "deva" },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "latn.NumberPatterns",
                new String[] {
                    "#,##,##0.###",
                    "\u00a4\u00a0#,##,##0.00",
                    "#,##0%",
                    "",
                }
            },
            { "deva.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0966",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "deva.NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "\u00a4\u00a0#,##0.00",
                    "#,##,##0%",
                    "",
                }
            },
            { "short.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0\u00a0\u0939\u091c\u093e\u0930 other:0\u00a0\u0939\u091c\u093e\u0930}",
                    "{one:00\u00a0\u0939\u091c\u093e\u0930 other:00\u00a0\u0939\u091c\u093e\u0930}",
                    "{one:0\u00a0\u0932\u093e\u0916 other:0\u00a0\u0932\u093e\u0916}",
                    "{one:00\u00a0\u0932\u093e\u0916 other:00\u00a0\u0932\u093e\u0916}",
                    "{one:0\u00a0\u0915\u0930\u094b\u0921 other:0\u00a0\u0915\u0930\u094b\u0921}",
                    "{one:00\u00a0\u0915\u0930\u094b\u0921 other:00\u00a0\u0915\u0930\u094b\u0921}",
                    "{one:0\u00a0\u0905\u0930\u092c other:0\u00a0\u0905\u0930\u092c}",
                    "{one:00\u00a0\u0905\u0930\u092c other:00\u00a0\u0905\u0930\u092c}",
                    "{one:0\u00a0\u0916\u0930\u092c other:0\u00a0\u0916\u0930\u092c}",
                    "{one:00\u00a0\u0916\u0930\u092c other:00\u00a0\u0916\u0930\u092c}",
                    "{one:0\u00a0\u0936\u0902\u0916 other:0\u00a0\u0936\u0902\u0916}",
                    "{one:00\u00a0\u0936\u0902\u0916 other:00\u00a0\u0936\u0902\u0916}",
                }
            },
            { "long.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0' '\u0939\u091c\u093e\u0930 other:0' '\u0939\u091c\u093e\u0930}",
                    "{one:00' '\u0939\u091c\u093e\u0930 other:00' '\u0939\u091c\u093e\u0930}",
                    "{one:0' '\u0932\u093e\u0916 other:0' '\u0932\u093e\u0916}",
                    "{one:0' '\u0915\u0930\u094b\u0921 other:0' '\u0915\u0930\u094b\u0921}",
                    "{one:00' '\u0915\u0930\u094b\u0921 other:00' '\u0915\u0930\u094b\u0921}",
                    "{one:000' '\u0915\u0930\u094b\u0921 other:000' '\u0915\u0930\u094b\u0921}",
                    "{one:0' '\u0905\u0930\u092c other:0' '\u0905\u0930\u092c}",
                    "{one:00' '\u0905\u0930\u092c other:00' '\u0905\u0930\u092c}",
                    "{one:000' '\u0905\u0930\u092c other:000' '\u0905\u0930\u092c}",
                    "{one:00' '\u0916\u0930\u092c other:00' '\u0916\u0930\u092c}",
                    "{one:0' '\u0936\u0902\u0916 other:0' '\u0936\u0902\u0916}",
                    "{one:00' '\u0936\u0902\u0916 other:00' '\u0936\u0902\u0916}",
                }
            },
            { "ListPatterns_standard", metaValue_ListPatterns_standard },
            { "ListPatterns_standard-short", metaValue_ListPatterns_standard },
            { "ListPatterns_standard-narrow",
                new String[] {
                    "{0},{1}",
                    "",
                    "{0}, {1}",
                    "{0}, {1}",
                    "",
                }
            },
            { "ListPatterns_or", metaValue_ListPatterns_or },
            { "ListPatterns_or-short", metaValue_ListPatterns_or },
            { "ListPatterns_or-narrow", metaValue_ListPatterns_or },
            { "ListPatterns_unit",
                new String[] {
                    "{0},{1}",
                    "",
                    "{0} \u0930 {1}",
                    "{0},{1}",
                    "",
                }
            },
            { "ListPatterns_unit-short",
                new String[] {
                    "{0},{1}",
                    "",
                    "{0},{1}",
                    "{0} {1}",
                    "",
                }
            },
            { "ListPatterns_unit-narrow",
                new String[] {
                    "{0} {1}",
                    "{0}{1}",
                    "{0} {1}",
                    "{0} \u0930 {1}",
                    "",
                }
            },
        };
        return data;
    }
}
