/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jimage.decompressor;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CompressIndexes {
    private static final int COMPRESSED_FLAG = 128;
    private static final int HEADER_WIDTH = 3;
    private static final int HEADER_SHIFT = 5;

    public static List<Integer> decompressFlow(byte[] values) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        for (int i = 0; i < values.length; i += CompressIndexes.getHeaderLength(values[i])) {
            int decompressed = CompressIndexes.decompress(values, i);
            lst.add(decompressed);
        }
        return lst;
    }

    public static int readInt(DataInputStream cr) throws IOException {
        byte header = cr.readByte();
        int size = CompressIndexes.getHeaderLength(header);
        int result = CompressIndexes.getHeaderValue(header);
        for (int i = 1; i < size; ++i) {
            result <<= 8;
            result |= cr.readByte() & 0xFF;
        }
        return result;
    }

    private static boolean isCompressed(byte b) {
        return (b & 0x80) != 0;
    }

    private static int getHeaderLength(byte b) {
        return CompressIndexes.isCompressed(b) ? b >> 5 & 3 : 4;
    }

    private static int getHeaderValue(byte b) {
        return CompressIndexes.isCompressed((byte)b) ? b & 0x1F : b;
    }

    public static int decompress(byte[] value, int offset) {
        byte header = value[offset];
        int size = CompressIndexes.getHeaderLength(header);
        int result = CompressIndexes.getHeaderValue(header);
        for (int i = 1; i < size; ++i) {
            result <<= 8;
            result |= value[offset + i] & 0xFF;
        }
        return result;
    }

    public static byte[] compress(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value < 0");
        }
        int width = 32 - Integer.numberOfLeadingZeros(value);
        int size = Math.min((width + 3 - 1 >> 3) + 1, 4);
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)(value >> (size - i - 1) * 8);
        }
        if (size < 4) {
            result[0] = (byte)(result[0] | (byte)(0x80 | size << 5));
        }
        return result;
    }
}

