/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.httpd;

import com.sun.javatest.httpd.JThttpProvider;
import com.sun.javatest.httpd.RootRegistry;
import com.sun.javatest.httpd.httpURL;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;

class RequestHandler
implements Runnable {
    private static Hashtable urlMap;
    private Socket soc;
    private PrintWriter out;
    private LineNumberReader in;
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String BAD_METHOD = "405 Method Not Allowed";
    private static final String HTTP_CONTENT_TYPE = "Content-Type: ";
    private static final String HTTP_CONTENT_HTML = "Content-Type: text/html";
    private static I18NResourceBundle i18n;
    protected static boolean debug;

    public RequestHandler(Socket soc) {
        this.soc = soc;
    }

    @Override
    public void run() {
        String request = null;
        try {
            if (debug) {
                StringBuffer buf = new StringBuffer();
                buf.append("Handling request from ");
                buf.append(this.soc.getInetAddress().getHostName());
                buf.append(" (");
                buf.append(this.soc.getInetAddress().getHostAddress());
                buf.append(")");
                System.out.println(buf.toString());
                buf.setLength(0);
            }
            this.out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.soc.getOutputStream(), StandardCharsets.UTF_8)));
            this.in = new LineNumberReader(new InputStreamReader(this.soc.getInputStream(), StandardCharsets.UTF_8));
            request = this.in.readLine();
            if (debug) {
                System.out.println("-------------");
                System.out.println("RH-Full request:");
                System.out.println(request);
            }
            while (debug && this.in.ready()) {
                String line = this.in.readLine();
                System.out.println(line);
            }
            if (debug) {
                System.out.println("-------------");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] args = StringArray.split(request);
        if (debug) {
            System.out.print("Decode: " + request);
            System.out.println(" -> " + args.length + " params.");
        }
        if (args == null || args.length < 3) {
            if (debug) {
                System.err.println("RH-HTTP request too short.");
            }
            return;
        }
        if (args[0].equalsIgnoreCase(GET)) {
            if (debug) {
                System.out.println("RH-Processing HTTP GET request.");
            }
            this.doGet(args);
        } else if (args[0].equalsIgnoreCase(POST)) {
            if (debug) {
                System.out.println("RH-Processing HTTP POST request.");
            }
            this.doPost(args);
        } else {
            if (debug) {
                System.err.println("RH-Unsupported request method: " + args[0]);
            }
            this.error(this.out, BAD_METHOD, args[0] + " is an unsupported request method. " + BAD_METHOD);
            this.out.close();
            return;
        }
    }

    protected void doGet(String[] args) {
        if (debug) {
            System.out.println("RH-Get processing URL: \"" + args[1] + "\"");
        }
        httpURL url = new httpURL(args[1]);
        JThttpProvider handler = RootRegistry.getInstance().getHandler(url);
        if (handler != null) {
            handler.serviceRequest(url, this.out);
        } else if (debug) {
            System.out.println("No handler found for: " + args[1]);
        }
    }

    protected void doPost(String[] args) {
    }

    protected void notFound(String[] args) {
    }

    private void error(PrintWriter out, String code, String msg) {
        out.print("HTTP/1.1 ");
        out.println(code);
        out.println(HTTP_CONTENT_HTML);
        out.print("<html><head><title>");
        out.print(code);
        out.println("</title></head><body>");
        out.print(i18n.getString("handler.err.txt"));
        out.println("<br>");
        out.println(code);
        out.println("</body></html>");
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(RequestHandler.class);
        debug = Boolean.getBoolean("debug." + RequestHandler.class.getName());
    }
}

