/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.audit;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.audit.Audit;
import com.sun.javatest.audit.AuditPane;
import com.sun.javatest.report.HTMLWriterEx;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.jthelp.ContextHelpManager;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

class SummaryPane
extends AuditPane {
    private JEditorPane htmlPane = new JEditorPane();
    private Audit currAudit;
    private HTMLWriterEx out;
    private String OK;
    private String ERROR;

    SummaryPane(UIFactory uif) {
        super("smry", uif);
        this.htmlPane.setName("smry.html");
        this.htmlPane.setContentType("text/html");
        this.htmlPane.setEditable(false);
        this.htmlPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        uif.setAccessibleInfo(this.htmlPane, "smry.html");
        JScrollPane sp = uif.createScrollPane(this.htmlPane, 20, 31);
        this.setBody(sp);
        ContextHelpManager.setHelpIDString(this, "audit.summaryTab.csh");
        this.OK = uif.getI18NString("smry.state.OK");
        this.ERROR = uif.getI18NString("smry.state.error");
    }

    @Override
    void show(Audit audit) {
        if (audit == this.currAudit) {
            this.showBody();
        } else {
            this.currAudit = audit;
            StringWriter sw = new StringWriter();
            try {
                this.out = new HTMLWriterEx((Writer)sw, this.uif.getI18NResourceBundle());
                this.writeReport();
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.htmlPane.setText(sw.toString());
            this.showBody();
        }
    }

    private void writeReport() throws IOException {
        this.out.startTag("html");
        this.out.startTag("head");
        this.out.writeContentMeta();
        this.out.endTag("head");
        this.out.startTag("body");
        this.out.writeStyleAttr("font-family: SansSerif; font-size: 12pt");
        this.out.startTag("table");
        this.out.startTag("tr");
        this.out.startTag("th");
        this.out.writeAttr("align", "right");
        this.out.writeI18N("smry.category");
        this.out.startTag("th");
        this.out.writeAttr("align", "left");
        this.out.writeI18N("smry.state");
        this.out.startTag("th");
        this.out.writeAttr("align", "left");
        this.out.writeI18N("smry.details");
        this.writeResultFileDetails();
        this.writeChecksumDetails();
        this.writeTestDescriptionDetails();
        this.writeTestCaseDetails();
        this.writeStatusDetails();
        this.writeDateStampDetails();
        this.out.endTag("table");
        this.out.endTag("body");
        this.out.endTag("html");
    }

    private void writeResultFileDetails() throws IOException {
        int count;
        this.out.startTag("tr");
        this.out.startTag("td");
        this.out.writeAttr("align", "right");
        this.out.writeAttr("valign", "top");
        this.out.startTag("b");
        this.out.writeI18N("smry.tr.head");
        this.out.endTag("b");
        this.out.startTag("td");
        this.out.writeAttr("valign", "top");
        this.out.write(this.currAudit.isAllTestsOK() ? this.OK : this.ERROR);
        this.out.startTag("td");
        TestDescription[] bad = this.currAudit.getBadTests();
        int n = count = bad == null ? 0 : bad.length;
        if (count == 0) {
            this.out.writeI18N("smry.tr.allOK");
        } else {
            this.out.writeI18N("smry.tr.count", new Integer(count));
        }
    }

    private void writeChecksumDetails() throws IOException {
        this.out.startTag("tr");
        this.out.startTag("td");
        this.out.writeAttr("align", "right");
        this.out.writeAttr("valign", "top");
        this.out.startTag("b");
        this.out.writeI18N("smry.cs.head");
        this.out.endTag("b");
        this.out.startTag("td");
        this.out.writeAttr("valign", "top");
        this.out.write(this.currAudit.isChecksumCountsOK() ? this.OK : this.ERROR);
        this.out.startTag("td");
        int[] counts = this.currAudit.getChecksumCounts();
        int g = counts[2];
        int b = counts[1];
        int n = counts[0];
        if (b == 0 && n == 0) {
            this.out.writeI18N("smry.cs.allOK");
        } else {
            this.out.writeI18N("smry.cs.count", new Object[]{new Integer(g), new Integer(g > 0 && b + n > 0 ? 1 : 0), new Integer(b), new Integer(b > 0 && n > 0 ? 1 : 0), new Integer(n)});
        }
    }

    private void writeTestDescriptionDetails() throws IOException {
        int count;
        this.out.startTag("tr");
        this.out.startTag("td");
        this.out.writeAttr("align", "right");
        this.out.writeAttr("valign", "top");
        this.out.startTag("b");
        this.out.writeI18N("smry.td.head");
        this.out.endTag("b");
        this.out.startTag("td");
        this.out.writeAttr("valign", "top");
        this.out.write(this.currAudit.isAllTestDescriptionsOK() ? this.OK : this.ERROR);
        this.out.startTag("td");
        TestResult[] bad = this.currAudit.getBadTestDescriptions();
        int n = count = bad == null ? 0 : bad.length;
        if (count == 0) {
            this.out.writeI18N("smry.td.allOK");
        } else {
            this.out.writeI18N("smry.td.count", new Integer(count));
        }
    }

    private void writeTestCaseDetails() throws IOException {
        int count;
        this.out.startTag("tr");
        this.out.startTag("td");
        this.out.writeAttr("align", "right");
        this.out.writeAttr("valign", "top");
        this.out.startTag("b");
        this.out.writeI18N("smry.tc.head");
        this.out.endTag("b");
        this.out.startTag("td");
        this.out.writeAttr("valign", "top");
        this.out.write(this.currAudit.isAllTestsOK() ? this.OK : this.ERROR);
        this.out.startTag("td");
        TestResult[] bad = this.currAudit.getBadTestCaseTests();
        int n = count = bad == null ? 0 : bad.length;
        if (count == 0) {
            this.out.writeI18N("smry.tc.allOK");
        } else {
            this.out.writeI18N("smry.tc.count", new Integer(count));
        }
    }

    private void writeStatusDetails() throws IOException {
        this.out.startTag("tr");
        this.out.startTag("td");
        this.out.writeAttr("align", "right");
        this.out.writeAttr("valign", "top");
        this.out.startTag("b");
        this.out.writeI18N("smry.status.head");
        this.out.endTag("b");
        this.out.startTag("td");
        this.out.writeAttr("valign", "top");
        this.out.write(this.currAudit.isStatusCountsOK() ? this.OK : this.ERROR);
        this.out.startTag("td");
        int[] stats = this.currAudit.getStatusCounts();
        int p = stats[0];
        int f = stats[1];
        int e = stats[2];
        int nr = stats[3];
        if (p + f + e + nr == 0) {
            this.out.writeI18N("smry.status.noTests");
        } else if (f + e + nr == 0) {
            this.out.writeI18N("smry.status.allOK");
        } else {
            this.out.writeI18N("smry.status.count", new Object[]{new Integer(p), new Integer(p > 0 && f + e + nr > 0 ? 1 : 0), new Integer(f), new Integer(f > 0 && e + nr > 0 ? 1 : 0), new Integer(e), new Integer(e > 0 && nr > 0 ? 1 : 0), new Integer(nr)});
        }
    }

    private void writeDateStampDetails() throws IOException {
        this.out.startTag("tr");
        this.out.startTag("td");
        this.out.writeAttr("align", "right");
        this.out.writeAttr("valign", "top");
        this.out.startTag("b");
        this.out.writeI18N("smry.dates.head");
        this.out.endTag("b");
        this.out.startTag("td");
        this.out.writeAttr("valign", "top");
        this.out.write(this.currAudit.isDateStampsOK() ? this.OK : this.ERROR);
        this.out.startTag("td");
        Date earliestStart = this.currAudit.getEarliestStartTime();
        Date latestStart = this.currAudit.getLatestStartTime();
        boolean badStarts = this.currAudit.hasBadStartTimes();
        if (earliestStart == null || latestStart == null) {
            this.out.writeI18N("smry.dates.noStamps");
        } else {
            Integer b = new Integer(badStarts ? 1 : 0);
            this.out.writeI18N("smry.dates.earliest", new Object[]{earliestStart, b});
            this.out.startTag("br");
            this.out.writeI18N("smry.dates.latest", new Object[]{latestStart, b});
            if (badStarts) {
                this.out.startTag("br");
                this.out.writeI18N("smry.dates.badDatesFound");
            }
        }
    }

    private void writeEnvDetails() throws IOException {
    }
}

