/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javasoft.sqe.apiCheck.API;
import javasoft.sqe.apiCheck.ClassProcessor;
import javasoft.sqe.apiCheck.Constant;
import javasoft.sqe.apiCheck.Main;
import javasoft.sqe.apiCheck.PackageSet;
import javasoft.sqe.apiCheck.PathWalk;
import javasoft.sqe.apiCheck.ReadClasses;
import javasoft.sqe.apiCheck.XClass;
import javasoft.sqe.apiCheck.XClassConstructor;
import javasoft.sqe.apiCheck.XClassField;
import javasoft.sqe.apiCheck.XClassMethod;
import javasoft.sqe.apiCheck.XProg;
import javasoft.sqe.apiCheck.XType;
import javasoft.sqe.apiCheck.XTypes;

class ReadStatic
implements ReadClasses {
    XProg prog;
    boolean valuemode;

    ReadStatic(boolean v) {
        this.valuemode = v;
    }

    @Override
    public boolean ReadPath(API api, String classpath, PackageSet packs) {
        long t0 = Main.GetTimer();
        api.xprog = this.prog = new XProg();
        api.props.Add("date", new Date().toString());
        if (classpath == null || classpath.length() == 0) {
            classpath = System.getProperty("java.class.path");
        } else if (classpath.equals("$") || classpath.equals("@")) {
            classpath = System.getProperty("sun.boot.class.path");
            api.props.Add("version", System.getProperty("java.version"));
        }
        api.props.Add("classpath", classpath);
        if (!packs.IsEmpty()) {
            api.props.Add("package", packs.toString());
        }
        PathWalk path = new PathWalk(packs, new Processor());
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator, false);
        int errs = 0;
        while (st.hasMoreElements()) {
            if (path.Walk((String)st.nextElement())) continue;
            ++errs;
        }
        path.Close();
        this.prog = null;
        Main.PrintTimer("ReadStatic " + classpath, t0);
        return errs == 0;
    }

    class Processor
    implements ClassProcessor {
        String filename;
        String packname;
        String classname;
        String ownname;
        DataInputStream in;
        Constant[] constants;
        static final int CONSTANT_Class = 7;
        static final int CONSTANT_Fieldref = 9;
        static final int CONSTANT_Methodref = 10;
        static final int CONSTANT_InterfaceMethodref = 11;
        static final int CONSTANT_String = 8;
        static final int CONSTANT_Integer = 3;
        static final int CONSTANT_Float = 4;
        static final int CONSTANT_Long = 5;
        static final int CONSTANT_Double = 6;
        static final int CONSTANT_NameAndType = 12;
        static final int CONSTANT_Utf8 = 1;

        Processor() {
        }

        @Override
        public void ProcessClass(String pack, String name, Object src, Object sub) {
            this.packname = pack;
            this.classname = name;
            try {
                this.Process(src, sub);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        void Process(Object src, Object sub) {
            InputStream ins = null;
            int bcount = 0;
            if (src instanceof File) {
                File f = (File)src;
                this.filename = f.toString();
                try {
                    ins = new FileInputStream(f);
                    bcount = (int)f.length();
                }
                catch (FileNotFoundException fileNotFoundException) {}
            } else if (src instanceof ZipFile) {
                ZipFile zf = (ZipFile)src;
                ZipEntry ze = (ZipEntry)sub;
                this.filename = zf.getName();
                try {
                    ins = zf.getInputStream(ze);
                    bcount = (int)ze.getSize();
                }
                catch (IOException iOException) {}
            } else {
                System.err.println("Invalid class source " + src.toString());
            }
            if (ins == null) {
                System.err.println("Class not found ? " + this.packname + this.classname);
            } else {
                try {
                    byte[] data = new byte[bcount];
                    for (int total = 0; total < data.length; total += ins.read(data, total, data.length - total)) {
                    }
                    ByteArrayInputStream bs = new ByteArrayInputStream(data);
                    this.in = new DataInputStream(bs);
                    this.ReadClass();
                }
                catch (IOException x) {
                    System.err.println(x);
                }
                this.constants = null;
                try {
                    this.in.close();
                }
                catch (IOException x) {
                    System.err.println(x);
                }
                this.in = null;
                ins = null;
            }
        }

        void ReadClass() throws IOException {
            String s;
            if (this.in.readInt() != -889275714) {
                this.Err("Not a class file");
            }
            int minor = this.in.readUnsignedShort();
            int major = this.in.readUnsignedShort();
            this.ReadConstants();
            int access = this.in.readUnsignedShort();
            this.ownname = this.GetClassName(this.in.readUnsignedShort());
            if (this.ownname == null) {
                this.Err(null);
            }
            if (!this.ownname.equals(this.packname + this.classname)) {
                this.Err("Invalid class name \"" + this.ownname + "\"");
            }
            XClass xclass = ReadStatic.this.prog.DefineClass(this.ownname);
            if (xclass.defined) {
                this.Err("Duplicate class \"" + this.ownname + "\"");
            }
            if ((s = this.GetClassName(this.in.readUnsignedShort())) != null) {
                xclass.extend = ReadStatic.this.prog.DefineClass(s);
            }
            int n = this.in.readUnsignedShort();
            for (int i = 0; i < n; ++i) {
                s = this.GetClassName(this.in.readUnsignedShort());
                xclass.implement.Add(ReadStatic.this.prog.DefineClass(s));
            }
            this.ReadFields(xclass);
            this.ReadMethods(xclass);
            ClassAttrs attrs = new ClassAttrs();
            attrs.Read();
            xclass.modifier = attrs.access != -1 ? this.GetModifier(attrs.access & 0xFFFFFFDF, 1567) : this.GetModifier(access & 0xFFFFFFDF, 1553);
            if (xclass.IsInterface()) {
                xclass.extend = null;
            }
            xclass.defined = true;
        }

        void ReadConstants() throws IOException {
            int n = this.in.readUnsignedShort();
            this.constants = new Constant[n];
            this.constants[0] = null;
            block11: for (int i = 1; i < n; ++i) {
                Constant c;
                this.constants[i] = c = new Constant();
                c.tag = this.in.readByte();
                switch (c.tag) {
                    case 7: {
                        c.info = new Short(this.in.readShort());
                        continue block11;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        c.info = new Integer(this.in.readInt());
                        continue block11;
                    }
                    case 8: {
                        c.info = new Short(this.in.readShort());
                        continue block11;
                    }
                    case 3: {
                        c.info = new Integer(this.in.readInt());
                        continue block11;
                    }
                    case 4: {
                        c.info = new Float(this.in.readFloat());
                        continue block11;
                    }
                    case 5: {
                        c.info = new Long(this.in.readLong());
                        ++i;
                        continue block11;
                    }
                    case 6: {
                        c.info = new Double(this.in.readDouble());
                        ++i;
                        continue block11;
                    }
                    case 12: {
                        c.info = new Integer(this.in.readInt());
                        continue block11;
                    }
                    case 1: {
                        c.info = this.in.readUTF();
                        continue block11;
                    }
                    default: {
                        this.Err(null);
                    }
                }
            }
        }

        void ReadFields(XClass xclass) throws IOException {
            int n = this.in.readUnsignedShort();
            for (int i = 0; i < n; ++i) {
                XClassField xfield = new XClassField();
                xfield.modifier = this.GetModifier(this.in.readUnsignedShort(), 223);
                xfield.name = this.GetName(this.in.readUnsignedShort());
                xfield.type = ReadStatic.this.prog.DefineVMType(new StringBuffer(this.GetName(this.in.readUnsignedShort())));
                FieldAttrs attrs = new FieldAttrs();
                attrs.Read();
                if ((xfield.modifier & 8) != 0) {
                    xfield.value = attrs.value;
                }
                if (xfield.value != null) {
                    String t = xfield.type.toString();
                    if (t.equals("boolean")) {
                        xfield.value = new Boolean((Integer)xfield.value != 0);
                    } else if (t.equals("byte")) {
                        xfield.value = new Byte(((Integer)xfield.value).byteValue());
                    } else if (t.equals("char")) {
                        xfield.value = new Character((char)((Integer)xfield.value).shortValue());
                    }
                }
                xfield.Link(xclass);
            }
        }

        void ReadMethods(XClass xclass) throws IOException {
            int n = this.in.readUnsignedShort();
            for (int i = 0; i < n; ++i) {
                int modifier = this.GetModifier(this.in.readUnsignedShort(), 3391);
                String name = this.GetName(this.in.readUnsignedShort());
                StringBuffer descr = new StringBuffer(this.GetName(this.in.readUnsignedShort()));
                XTypes args = this.GetArgs(descr);
                XType type = ReadStatic.this.prog.DefineVMType(descr);
                XTypes xthrows = new XTypes();
                MethodAttrs attrs = new MethodAttrs();
                attrs.Read();
                if (name.equals("<init>")) {
                    XClassConstructor xconstructor = new XClassConstructor();
                    xconstructor.modifier = modifier;
                    xconstructor.name = xclass.name;
                    xconstructor.args = args;
                    xconstructor.xthrows = attrs.xthrows;
                    xconstructor.Link(xclass);
                    continue;
                }
                if (name.equals("<clinit>")) continue;
                XClassMethod xmethod = new XClassMethod();
                xmethod.modifier = modifier;
                xmethod.name = name;
                xmethod.args = args;
                xmethod.type = type;
                xmethod.xthrows = attrs.xthrows;
                xmethod.Link(xclass);
            }
        }

        XTypes GetArgs(StringBuffer s) {
            XTypes tt = new XTypes();
            if (s.length() == 0 || s.charAt(0) != '(') {
                this.Err(null);
            }
            s.deleteCharAt(0);
            while (s.length() != 0 && s.charAt(0) != ')') {
                tt.Add(ReadStatic.this.prog.DefineVMType(s));
            }
            if (s.length() == 0 || s.charAt(0) != ')') {
                this.Err(null);
            }
            s.deleteCharAt(0);
            if (s.length() == 0) {
                this.Err(null);
            }
            return tt;
        }

        String GetClassName(int i) throws IOException {
            if (i == 0) {
                return null;
            }
            Constant c = this.GetConstant(i);
            if (c.tag != 7) {
                this.Err(null);
            }
            c = this.GetConstant((Short)c.info);
            if (c.tag != 1) {
                this.Err(null);
            }
            return ((String)c.info).replace('/', '.');
        }

        String GetName(int i) throws IOException {
            Constant c = this.GetConstant(i);
            if (c.tag != 1) {
                this.Err(null);
            }
            return (String)c.info;
        }

        Constant GetConstant(short i) {
            return this.GetConstant(i & 0xFFFF);
        }

        Constant GetConstant(int i) {
            if (i <= 0 || i >= this.constants.length) {
                this.Err(null);
            }
            return this.constants[i];
        }

        int GetModifier(int flags, int allowed) {
            int x = 0;
            if ((flags & 1) != 0) {
                x |= 1;
            }
            if ((flags & 2) != 0) {
                x |= 2;
            }
            if ((flags & 4) != 0) {
                x |= 4;
            }
            if ((flags & 8) != 0) {
                x |= 8;
            }
            if ((flags & 0x10) != 0) {
                x |= 0x10;
            }
            if ((flags & 0x20) != 0) {
                x |= 0x20;
            }
            if ((flags & 0x40) != 0) {
                x |= 0x40;
            }
            if ((flags & 0x80) != 0) {
                x |= 0x80;
            }
            if ((flags & 0x100) != 0) {
                x |= 0x100;
            }
            if ((flags & 0x200) != 0) {
                x |= 0x200;
            }
            if ((flags & 0x400) != 0) {
                x |= 0x400;
            }
            if ((flags & 0x800) != 0) {
                x |= 0x800;
            }
            return x & allowed;
        }

        void Err(String s) {
            if (s != null) {
                System.err.println(s);
            }
            System.err.println("Invalid class file " + this.filename);
            throw new Error();
        }

        class AttrsIter {
            ByteArrayInputStream bs;
            DataInputStream is;
            boolean synthetic = false;
            boolean deprecated = false;

            AttrsIter() {
            }

            void Read() throws IOException {
                int n = Processor.this.in.readUnsignedShort();
                for (int i = 0; i < n; ++i) {
                    String name = Processor.this.GetName(Processor.this.in.readUnsignedShort());
                    int count = Processor.this.in.readInt();
                    if (count != 0) {
                        byte[] info = new byte[count];
                        Processor.this.in.readFully(info);
                        this.bs = new ByteArrayInputStream(info);
                        this.is = new DataInputStream(this.bs);
                    }
                    if (name.equals("Synthetic")) {
                        this.synthetic = true;
                    } else if (name.equals("Deprecated")) {
                        this.deprecated = true;
                    } else {
                        this.Check(name);
                    }
                    if (count == 0) continue;
                    try {
                        this.is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.is = null;
                    this.bs = null;
                }
            }

            void Check(String s) throws IOException {
            }
        }

        class MethodAttrs
        extends AttrsIter {
            XTypes xthrows = new XTypes();

            MethodAttrs() {
            }

            @Override
            void Check(String s) throws IOException {
                if (s.equals("Exceptions")) {
                    int n = this.is.readUnsignedShort();
                    for (int i = 0; i < n; ++i) {
                        String x = Processor.this.GetClassName(this.is.readUnsignedShort());
                        this.xthrows.Add(ReadStatic.this.prog.DefineType(x));
                    }
                }
            }
        }

        class FieldAttrs
        extends AttrsIter {
            Object value = null;

            FieldAttrs() {
            }

            @Override
            void Check(String s) throws IOException {
                if (s.equals("ConstantValue")) {
                    if (this.value != null) {
                        Processor.this.Err(null);
                    }
                    if (ReadStatic.this.valuemode) {
                        Constant c = Processor.this.GetConstant(this.is.readUnsignedShort());
                        switch (c.tag) {
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                this.value = c.info;
                                break;
                            }
                            case 8: {
                                this.value = Processor.this.GetName(((Short)c.info).intValue() & 0xFFFF);
                                break;
                            }
                            default: {
                                Processor.this.Err(null);
                            }
                        }
                    }
                }
            }
        }

        class ClassAttrs
        extends AttrsIter {
            int access = -1;

            ClassAttrs() {
            }

            @Override
            void Check(String s) throws IOException {
                if (s.equals("InnerClasses")) {
                    int n = this.is.readUnsignedShort();
                    for (int i = 0; i < n; ++i) {
                        String inner = Processor.this.GetClassName(this.is.readUnsignedShort());
                        String outer = Processor.this.GetClassName(this.is.readUnsignedShort());
                        int k = this.is.readUnsignedShort();
                        String simple = k == 0 ? null : Processor.this.GetName(k);
                        int x = this.is.readUnsignedShort();
                        if (inner == null || !inner.equals(Processor.this.ownname)) continue;
                        if (this.access != -1) {
                            Processor.this.Err(null);
                        }
                        this.access = x;
                    }
                }
            }
        }
    }
}

