/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.ServletContext;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.JarScannerFactory;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.xml.sax.InputSource;

public class TldLocationsCache {
    private Log log = LogFactory.getLog(TldLocationsCache.class);
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private static final String WEB_INF = "/WEB-INF/";
    private static final String WEB_INF_LIB = "/WEB-INF/lib/";
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String FILE_PROTOCOL = "file:";
    private static final String JAR_EXT = ".jar";
    private static final String TLD_EXT = ".tld";
    private static HashSet<String> noTldJars = new HashSet();
    private Hashtable mappings;
    private boolean initialized;
    private ServletContext ctxt;

    public TldLocationsCache(ServletContext ctxt) {
        this.ctxt = ctxt;
        this.mappings = new Hashtable();
        this.initialized = false;
    }

    public static void setNoTldJars(String jarNames) {
        if (jarNames != null) {
            noTldJars.clear();
            StringTokenizer tokenizer = new StringTokenizer(jarNames, ",");
            while (tokenizer.hasMoreElements()) {
                noTldJars.add(tokenizer.nextToken());
            }
        }
    }

    public String[] getLocation(String uri) throws JasperException {
        if (!this.initialized) {
            this.init();
        }
        return (String[])this.mappings.get(uri);
    }

    public static int uriType(String uri) {
        if (uri.indexOf(58) != -1) {
            return 0;
        }
        if (uri.startsWith("/")) {
            return 1;
        }
        return 2;
    }

    private void init() throws JasperException {
        if (this.initialized) {
            return;
        }
        try {
            this.tldScanWebXml();
            this.tldScanResourcePaths(WEB_INF);
            JarScanner jarScanner = JarScannerFactory.getJarScanner(this.ctxt);
            if (jarScanner != null) {
                jarScanner.scan(this.ctxt, Thread.currentThread().getContextClassLoader(), new TldJarScannerCallback(), noTldJars);
            }
            this.initialized = true;
        }
        catch (Exception ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.internal.tldinit", ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void tldScanWebXml() throws Exception {
        is = null;
        try {
            altDDName = (String)this.ctxt.getAttribute(Constants.ALT_DD_ATTR);
            uri = null;
            if (altDDName != null) {
                try {
                    uri = new URL("file:" + altDDName.replace('\\', '/'));
                }
                catch (MalformedURLException e) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)Localizer.getMessage("jsp.error.internal.filenotfound", altDDName));
                    }
                }
            } else {
                uri = this.ctxt.getResource("/WEB-INF/web.xml");
                if (uri == null && this.log.isWarnEnabled()) {
                    this.log.warn((Object)Localizer.getMessage("jsp.error.internal.filenotfound", "/WEB-INF/web.xml"));
                }
            }
            if (uri != null) break block21;
            var14_6 = null;
            ** if (is == null) goto lbl-1000
        }
        catch (Throwable var13_20) {
            var14_8 = null;
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            throw var13_20;
        }
lbl-1000:
        // 1 sources

        {
            try {
                is.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
lbl-1000:
        // 3 sources

        {
            block21: {
                return;
            }
            is = uri.openStream();
            ip = new InputSource(is);
            ip.setSystemId(uri.toExternalForm());
            webtld = null;
            webtld = altDDName != null ? new ParserUtils().parseXMLDocument(altDDName, ip) : new ParserUtils().parseXMLDocument("/WEB-INF/web.xml", ip);
            jspConfig = webtld.findChild("jsp-config");
            if (jspConfig != null) {
                webtld = jspConfig;
            }
            taglibs = webtld.findChildren("taglib");
            while (taglibs.hasNext()) {
                taglib = (TreeNode)taglibs.next();
                tagUri = null;
                tagLoc = null;
                child = taglib.findChild("taglib-uri");
                if (child != null) {
                    tagUri = child.getBody();
                }
                if ((child = taglib.findChild("taglib-location")) != null) {
                    tagLoc = child.getBody();
                }
                if (tagLoc == null) continue;
                if (TldLocationsCache.uriType(tagLoc) == 2) {
                    tagLoc = "/WEB-INF/" + tagLoc;
                }
                tagLoc2 = null;
                if (tagLoc.endsWith(".jar")) {
                    tagLoc = this.ctxt.getResource(tagLoc).toString();
                    tagLoc2 = "META-INF/taglib.tld";
                }
                this.mappings.put(tagUri, new String[]{tagLoc, tagLoc2});
            }
        }
        var14_7 = null;
        if (is != null) {
            try {
                is.close();
            }
            catch (Throwable t) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanResourcePaths(String startPath) throws Exception {
        Set dirList = this.ctxt.getResourcePaths(startPath);
        if (dirList != null) {
            for (String path : dirList) {
                if (!path.endsWith(TLD_EXT) && (path.startsWith(WEB_INF_LIB) || path.startsWith("/WEB-INF/classes/"))) continue;
                if (path.endsWith(TLD_EXT)) {
                    Throwable t2;
                    Object var7_6;
                    if (path.startsWith("/WEB-INF/tags/") && !path.endsWith("implicit.tld")) continue;
                    InputStream stream = this.ctxt.getResourceAsStream(path);
                    try {
                        this.tldScanStream(path, null, stream);
                        var7_6 = null;
                        if (stream == null) continue;
                    }
                    catch (Throwable throwable) {
                        var7_6 = null;
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable t2) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        stream.close();
                    }
                    catch (Throwable t2) {}
                    continue;
                }
                this.tldScanResourcePaths(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanDir(File start) throws IOException {
        File[] fileList = start.listFiles();
        if (fileList != null) {
            for (int i = 0; i < fileList.length; ++i) {
                Throwable t2;
                Object var6_5;
                if (fileList[i].isDirectory()) {
                    this.tldScanDir(fileList[i]);
                    continue;
                }
                if (!fileList[i].getAbsolutePath().endsWith(TLD_EXT)) continue;
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(fileList[i]);
                    this.tldScanStream(fileList[i].toURI().toString(), null, stream);
                    var6_5 = null;
                    if (stream == null) continue;
                }
                catch (Throwable throwable) {
                    var6_5 = null;
                    if (stream != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (Throwable t2) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable t2) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tldScanJar(JarURLConnection conn) throws IOException {
        JarFile jarFile = null;
        String resourcePath = conn.getJarFileURL().toString();
        try {
            conn.setUseCaches(false);
            jarFile = conn.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("META-INF/") || !name.endsWith(TLD_EXT)) continue;
                InputStream stream = jarFile.getInputStream(entry);
                this.tldScanStream(resourcePath, name, stream);
            }
            Object var9_8 = null;
            if (jarFile == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (jarFile == null) throw throwable;
            try {
                jarFile.close();
                throw throwable;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            jarFile.close();
            return;
        }
        catch (Throwable t) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void tldScanStream(String resourcePath, String entryName, InputStream stream) throws IOException {
        try {
            try {
                String body;
                String uri = null;
                TreeNode tld = new ParserUtils().parseXMLDocument(resourcePath, stream);
                TreeNode uriNode = tld.findChild("uri");
                if (uriNode != null && (body = uriNode.getBody()) != null) {
                    uri = body;
                }
                if (uri != null && this.mappings.get(uri) == null) {
                    this.mappings.put(uri, new String[]{resourcePath, entryName});
                }
            }
            catch (JasperException e) {
                IOException ioe = new IOException();
                ioe.initCause((Throwable)((Object)e));
                throw ioe;
            }
            Object var9_10 = null;
            if (stream == null) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable t) {}
        stream.close();
        return;
    }

    static {
        noTldJars.add("bootstrap.jar");
        noTldJars.add("commons-daemon.jar");
        noTldJars.add("tomcat-juli.jar");
        noTldJars.add("annotations-api.jar");
        noTldJars.add("catalina.jar");
        noTldJars.add("catalina-ant.jar");
        noTldJars.add("catalina-ha.jar");
        noTldJars.add("catalina-tribes.jar");
        noTldJars.add("el-api.jar");
        noTldJars.add("jasper.jar");
        noTldJars.add("jasper-el.jar");
        noTldJars.add("ecj-3.3.1.jar");
        noTldJars.add("jsp-api.jar");
        noTldJars.add("servlet-api.jar");
        noTldJars.add("tomcat-coyote.jar");
        noTldJars.add("tomcat-dbcp.jar");
        noTldJars.add("tomcat-i18n-en.jar");
        noTldJars.add("tomcat-i18n-es.jar");
        noTldJars.add("tomcat-i18n-fr.jar");
        noTldJars.add("tomcat-i18n-ja.jar");
        noTldJars.add("ant.jar");
        noTldJars.add("commons-dbcp.jar");
        noTldJars.add("commons-beanutils.jar");
        noTldJars.add("commons-fileupload-1.0.jar");
        noTldJars.add("commons-pool.jar");
        noTldJars.add("commons-digester.jar");
        noTldJars.add("commons-logging.jar");
        noTldJars.add("commons-collections.jar");
        noTldJars.add("jmx.jar");
        noTldJars.add("jmx-tools.jar");
        noTldJars.add("xercesImpl.jar");
        noTldJars.add("xmlParserAPIs.jar");
        noTldJars.add("xml-apis.jar");
        noTldJars.add("sunjce_provider.jar");
        noTldJars.add("ldapsec.jar");
        noTldJars.add("localedata.jar");
        noTldJars.add("dnsns.jar");
        noTldJars.add("tools.jar");
        noTldJars.add("sunpkcs11.jar");
    }

    private class TldJarScannerCallback
    implements JarScannerCallback {
        private TldJarScannerCallback() {
        }

        public void scan(JarURLConnection urlConn) throws IOException {
            TldLocationsCache.this.tldScanJar(urlConn);
        }

        public void scan(File file) throws IOException {
            File metaInf = new File(file, "META-INF");
            if (metaInf.isDirectory()) {
                TldLocationsCache.this.tldScanDir(metaInf);
            }
        }
    }
}

