/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec.template;

import com.sun.interview.Interview;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TemplateUtilities;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.BasicSession;
import com.sun.javatest.exec.BasicSessionControl;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.FeatureManager;
import com.sun.javatest.exec.Session;
import com.sun.javatest.exec.SessionExt;
import com.sun.javatest.exec.WorkDirChooseTool;
import com.sun.javatest.exec.template.TU_ViewManager;
import com.sun.javatest.exec.template.TU_dialog;
import com.sun.javatest.exec.template.TemplateEditor;
import com.sun.javatest.exec.template.TemplateSession;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class TemplateSessionControl
extends BasicSessionControl {
    final InterviewParameters template;
    protected Action newTemplateAction;
    protected Action showTemplateAction;
    protected Action loadTemplateAction;
    protected Action checkUpdatesAction;
    protected TemplateEditor templateEditor;
    protected TemplateSession templateSession;
    private FileHistory.Listener configTemplateHistoryListener;
    private JMenu menuHistory;
    private static boolean debug = Debug.getBoolean(TemplateSessionControl.class);
    protected UIFactory uifOrig;
    protected TU_dialog tu_dialog;
    private static KeyStroke tEditorAccelerator = KeyStroke.getKeyStroke(84, 2);

    public TemplateSessionControl(JComponent parent, UIFactory uif, TestSuite ts, ContextManager cm, UIFactory uifOrig) throws Session.Fault {
        super(parent, uif, ts, cm);
        this.uifOrig = uifOrig;
        this.templateSession = (TemplateSession)this.session;
        this.template = this.templateSession.templ;
        this.tu_dialog = this.createTU_Dialog();
        TU_ViewManager.register(this.templateSession.getInterviewParameters(), this.tu_dialog);
        this.initExtraActions();
    }

    @Override
    protected SessionExt createEmptySession() throws Session.Fault {
        return new TemplateSession(this.testSuite);
    }

    @Override
    public void updated(Session.Event ev) {
        super.updated(ev);
        if (this.needCheckForUpdates(ev)) {
            this.templateSession.getInterviewParameters().checkForUpdates();
        }
    }

    protected boolean needCheckForUpdates(Session.Event ev) {
        if (ev instanceof BasicSessionControl.E_EditorVisibility) {
            BasicSessionControl.E_EditorVisibility event = (BasicSessionControl.E_EditorVisibility)ev;
            return event.source != null && event.source instanceof TemplateEditor && !event.isVisible && this.templateSession.getValue("Configuration") != null && this.templateSession.getValue("Template") != null;
        }
        return ev instanceof BasicSession.E_NewConfig;
    }

    @Override
    public void startTests(Parameters p) {
        super.startTests(p);
        ((InterviewParameters)p).checkForUpdates();
    }

    @Override
    public void updateGUI() {
        super.updateGUI();
        WorkDirectory wd = this.template.getWorkDirectory();
        boolean isWorkDirSet = wd != null;
        boolean configCreated = this.templateSession.getValue("Configuration") != null;
        boolean templateCreated = this.templateSession.getValue("Template") != null;
        boolean editorNotVisible = !this.isEditorVisible();
        this.newTemplateAction.setEnabled(isWorkDirSet && editorNotVisible);
        this.loadTemplateAction.setEnabled(isWorkDirSet && editorNotVisible);
        this.showTemplateAction.setEnabled(isWorkDirSet && templateCreated && editorNotVisible);
        this.checkUpdatesAction.setEnabled(configCreated && templateCreated && editorNotVisible);
        this.menuHistory.setEnabled(editorNotVisible);
        if (isWorkDirSet && this.configTemplateHistoryListener.getFileHistory() == null) {
            FileHistory h = FileHistory.getFileHistory(wd, "templateHistory.jtl");
            this.configTemplateHistoryListener.setFileHistory(h);
        }
    }

    @Override
    protected boolean isEditorVisible() {
        return super.isEditorVisible() || this.templateEditor != null && this.templateEditor.isVisible();
    }

    @Override
    public JMenu getMenu() {
        JMenu menu = super.getMenu();
        FeatureManager fm = null;
        if (this.cm != null) {
            fm = this.cm.getFeatureManager();
        }
        if (this.cm == null || fm.isEnabled(2)) {
            menu.addSeparator();
            menu.add(this.uif.createMenuItem(this.newTemplateAction));
            JMenuItem editTemplateItem = this.uif.createMenuItem(this.showTemplateAction);
            editTemplateItem.setAccelerator(tEditorAccelerator);
            menu.add(editTemplateItem);
            menu.add(this.uif.createMenuItem(this.loadTemplateAction));
            menu.add(this.menuHistory);
        }
        if (this.cm == null || fm.isEnabled(3)) {
            menu.addSeparator();
            menu.add(this.uif.createMenuItem(this.checkUpdatesAction));
        }
        return menu;
    }

    @Override
    protected JPanel createSessionView() {
        return new TemplateConfigView((Session)this.session);
    }

    @Override
    public void dispose() {
        this.template.dispose();
        TU_ViewManager.unregister(this.templateSession.getInterviewParameters());
        if (this.tu_dialog != null) {
            this.tu_dialog.dispose();
            this.tu_dialog = null;
        }
        if (this.templateEditor != null) {
            this.templateEditor.dispose();
            this.templateEditor = null;
        }
        super.dispose();
    }

    protected void initExtraActions() {
        I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TemplateSessionControl.class);
        this.newTemplateAction = new ToolAction(i18n, "tcc.file.new"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplateSessionControl.this.newTemplate();
            }
        };
        this.showTemplateAction = new ToolAction(i18n, "tcc.file.edit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplateSessionControl.this.editTemplate();
            }
        };
        this.loadTemplateAction = new ToolAction(i18n, "tcc.file.load"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplateSessionControl.this.loadTemplate();
            }
        };
        this.checkUpdatesAction = new ToolAction(i18n, "tcc.file.chUpdate"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplateSessionControl.this.checkUpdate();
            }
        };
    }

    @Override
    protected void initHistoryListeners() {
        super.initHistoryListeners();
        this.configTemplateHistoryListener = new FileHistory.Listener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem mi = (JMenuItem)e.getSource();
                File f = (File)mi.getClientProperty("file");
                if (f != null && TemplateSessionControl.this.initTemplateEditor()) {
                    TemplateSessionControl.this.templateEditor.loadAndEdit(f);
                }
            }
        });
        this.menuHistory = this.uif.createMenu("tcc.templatehistory");
        this.menuHistory.addMenuListener(this.configTemplateHistoryListener);
    }

    void newTemplate() {
        if (!this.initTemplateEditor()) {
            return;
        }
        this.templateEditor.newConfig();
    }

    void loadTemplate() {
        if (!this.initTemplateEditor()) {
            return;
        }
        this.templateEditor.loadConfig();
    }

    void editTemplate() {
        if (!this.initTemplateEditor()) {
            return;
        }
        this.templateEditor.edit(1);
    }

    protected void checkUpdate() {
        block13: {
            try {
                boolean wasUpdate = false;
                String whichUpdate = null;
                InterviewParameters cfg = this.templateSession.getInterviewParameters();
                WorkDirectory wd = cfg.getWorkDirectory();
                long start = System.currentTimeMillis();
                if (cfg.isFileNewer()) {
                    wasUpdate = cfg.load();
                    whichUpdate = "exec.log.iload";
                } else {
                    wasUpdate = cfg.checkForUpdates();
                    whichUpdate = "exec.log.iupdate";
                }
                long time = System.currentTimeMillis();
                if (!wasUpdate) {
                    this.uif.showInformation("exec.noUpdate");
                    break block13;
                }
                if (wd == null) {
                    return;
                }
                Logger log = null;
                try {
                    log = wd.getTestSuite().createLog(wd, null, this.uif.getI18NString("exec.log.name"));
                }
                catch (TestSuite.DuplicateLogNameFault f) {
                    try {
                        log = wd.getTestSuite().getLog(wd, this.uif.getI18NString("exec.log.name"));
                    }
                    catch (TestSuite.NoSuchLogFault f2) {
                        return;
                    }
                }
                if (log != null) {
                    Integer loadTime = new Integer((int)(time / 1000L));
                    Object[] params = new Object[]{loadTime, cfg.getFile().getAbsolutePath()};
                    String output = this.uif.getI18NString(whichUpdate, params);
                    log.info(output);
                    if (debug) {
                        Debug.println(output);
                    }
                }
            }
            catch (IOException ex) {
                this.uif.showError("tcc.loadTemplate", ex.toString());
            }
            catch (Interview.Fault ex) {
                this.uif.showError("tcc.loadTemplate", ex.getMessage());
            }
        }
    }

    boolean initTemplateEditor() {
        if (this.templateEditor != null) {
            return true;
        }
        InterviewParameters ip = this.session.getInterviewParameters();
        if (ip == null || ip.getWorkDirectory() == null) {
            return false;
        }
        this.templateEditor = this.createTemplateEditor();
        if (this.cm != null) {
            this.templateEditor.setCustomRenderers(this.cm.getCustomRenderersMap());
        }
        this.templateEditor.setCheckExcludeListListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                JComponent p = src instanceof JComponent ? (JComponent)src : TemplateSessionControl.this.parent;
                TemplateSessionControl.this.checkExcludeListUpdate(p, false, TemplateSessionControl.this.template);
            }
        });
        this.templateEditor.addObserver(this);
        return true;
    }

    TemplateEditor createTemplateEditor() {
        return new TemplateEditor(this.parent, this.uif, this.template, this.cm);
    }

    @Override
    protected UIFactory getUIFactory() {
        return this.uifOrig;
    }

    @Override
    protected boolean createWD() {
        return this.chooseWD(0);
    }

    @Override
    protected boolean setWD() {
        return this.chooseWD(2);
    }

    protected boolean chooseWD(int mode) {
        WorkDirChooseTool.ExecModelStub em = new WorkDirChooseTool.ExecModelStub(this.testSuite, this.cm);
        WorkDirChooseTool tool = WorkDirChooseTool.getTool(this.parent, this.uif, em, mode, this.testSuite, true);
        tool.doTool();
        if (em.getWorkDirectory() != null) {
            this.applyWorkDir(em.getWorkDirectory());
            File tempPath = TemplateUtilities.getTemplateFile(em.getWorkDirectory());
            if (tempPath != null && this.initTemplateEditor()) {
                this.templateEditor.loadConfigFromFile(tempPath);
            }
            this.fixTemplatePath(tempPath);
            if (em.isShowConfigEditor()) {
                return true;
            }
        }
        return false;
    }

    protected void fixTemplatePath(File tempPath) {
        InterviewParameters ip = this.templateSession.getInterviewParameters();
        if (tempPath != null && ip.getTemplatePath() != null && !ip.getTemplatePath().equals(tempPath.getPath())) {
            ip.setTemplatePath(tempPath.getPath());
            try {
                ip.save();
            }
            catch (IOException iOException) {
            }
            catch (Interview.Fault fault) {
                // empty catch block
            }
        }
    }

    @Override
    public void restoreConfigFromWD(WorkDirectory wd) throws Session.Fault {
        super.restoreConfigFromWD(wd);
        this.templateSession.loadTemplateFromWD(wd);
    }

    protected TU_dialog createTU_Dialog() {
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.parent);
        return new TU_dialog(frame, this.uif, this.templateSession, this.cm);
    }

    @Override
    public void changed(InterviewParameters p) {
        if (p == null) {
            return;
        }
        if (p.isTemplate()) {
            try {
                this.templateSession.update(new TemplateSession.U_NewTemplate(p));
            }
            catch (Session.Fault e) {
                e.printStackTrace();
                System.err.println(this.uif.getI18NString("tcc.internalError.err"));
            }
        } else {
            super.changed(p);
        }
    }

    protected class TemplateConfigView
    extends BasicSessionControl.SessionView {
        protected JLabel templ_n;
        protected JTextField templ_f;

        TemplateConfigView(Session config) {
            super(config);
        }

        @Override
        protected void init() {
            super.init();
            this.templ_n = TemplateSessionControl.this.uif.createLabel("tcc.templatename");
            this.templ_f = TemplateSessionControl.this.uif.createOutputField("tcc.templatename", this.templ_n, true);
            this.templ_f.setBorder(BorderFactory.createEmptyBorder());
            this.templ_n.setHorizontalAlignment(4);
        }

        @Override
        protected void layoutComponents() {
            super.layoutComponents();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 3, 0, 3);
            this.add((Component)this.templ_n, gridBagConstraints);
            this.updateTempl(this.templ_f);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 5;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 3, 0, 3);
            this.add((Component)this.templ_f, gridBagConstraints);
        }

        protected void updateTempl(JTextField fld) {
            String text = this.session.getValue("Template");
            this.updateField(fld, text);
        }

        @Override
        public void updated(Session.Event ev) {
            super.updated(ev);
            this.updateTempl(this.templ_f);
        }
    }
}

