/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.runtime;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.tooldef.runtime.ToolDefEqWrap;

public class ToolDefList<E>
implements List<E> {
    private final List<ToolDefEqWrap<E>> storage;

    public ToolDefList() {
        this.storage = Lists.list();
    }

    public ToolDefList(int initialCapacity) {
        this.storage = Lists.listc((int)initialCapacity);
    }

    public ToolDefList(Collection<? extends E> collection) {
        this.storage = Lists.listc((int)collection.size());
        for (E elem : collection) {
            this.storage.add(ToolDefEqWrap.wrap(elem));
        }
    }

    private ToolDefList(List<ToolDefEqWrap<E>> list) {
        this.storage = list;
    }

    public static <T> ToolDefList<T> wrap(List<ToolDefEqWrap<T>> list) {
        return new ToolDefList(list);
    }

    @Override
    public boolean add(E elem) {
        ToolDefEqWrap<E> wrappedElem = ToolDefEqWrap.wrap(elem);
        return this.storage.add(wrappedElem);
    }

    @Override
    public void add(int index, E element) {
        this.storage.add(index, ToolDefEqWrap.wrap(element));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E elem : c) {
            this.add(elem);
        }
        return !c.isEmpty();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        for (E elem : c) {
            this.add(index, elem);
            ++index;
        }
        return !c.isEmpty();
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    @Override
    public boolean contains(Object elem) {
        ToolDefEqWrap<Object> wrappedElem = ToolDefEqWrap.wrap(elem);
        return this.storage.contains(wrappedElem);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object elem : c) {
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolDefList)) {
            return false;
        }
        ToolDefList other = (ToolDefList)obj;
        if (this.size() != other.size()) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            ToolDefEqWrap<E> wrapOther;
            ToolDefEqWrap<E> wrapThis = this.storage.get(i);
            if (!wrapThis.equals(wrapOther = other.storage.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public E get(int index) {
        return (E)this.storage.get((int)index).value;
    }

    @Override
    public int hashCode() {
        int rslt = ToolDefList.class.hashCode();
        for (ToolDefEqWrap<E> wrap : this.storage) {
            rslt = 31 * rslt + wrap.hashCode();
        }
        return rslt;
    }

    @Override
    public int indexOf(Object o) {
        return this.storage.indexOf(ToolDefEqWrap.wrap(o));
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Iterator<ToolDefEqWrap<E>> iter;
            {
                this.iter = ToolDefList.this.storage.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public E next() {
                return this.iter.next().value;
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.storage.lastIndexOf(ToolDefEqWrap.wrap(o));
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        final ListIterator<ToolDefEqWrap<E>> iter = this.storage.listIterator(index);
        return new ListIterator<E>(){

            @Override
            public void add(E e) {
                iter.add(ToolDefEqWrap.wrap(e));
            }

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return iter.hasPrevious();
            }

            @Override
            public E next() {
                return ((ToolDefEqWrap)iter.next()).value;
            }

            @Override
            public int nextIndex() {
                return iter.nextIndex();
            }

            @Override
            public E previous() {
                return ((ToolDefEqWrap)iter.previous()).value;
            }

            @Override
            public int previousIndex() {
                return iter.previousIndex();
            }

            @Override
            public void remove() {
                iter.remove();
            }

            @Override
            public void set(E e) {
                iter.set(ToolDefEqWrap.wrap(e));
            }
        };
    }

    @Override
    public E remove(int index) {
        ToolDefEqWrap<E> rslt = this.storage.remove(index);
        return (E)rslt.value;
    }

    @Override
    public boolean remove(Object elem) {
        ToolDefEqWrap<Object> wrappedElem = ToolDefEqWrap.wrap(elem);
        return this.storage.remove(wrappedElem);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean rslt = false;
        for (Object elem : c) {
            while (this.contains(elem)) {
                rslt = true;
                this.remove(elem);
            }
        }
        return rslt;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ToolDefList wrappedC = new ToolDefList(c.size());
        for (Object elem : c) {
            wrappedC.add(ToolDefEqWrap.wrap(elem));
        }
        return this.storage.retainAll(wrappedC);
    }

    @Override
    public E set(int index, E element) {
        ToolDefEqWrap<E> rslt = this.storage.set(index, ToolDefEqWrap.wrap(element));
        return (E)rslt.value;
    }

    @Override
    public int size() {
        return this.storage.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return ToolDefList.wrap(this.storage.subList(fromIndex, toIndex));
    }

    @Override
    public Object[] toArray() {
        Object[] rslt = new Object[this.storage.size()];
        int i = 0;
        while (i < this.storage.size()) {
            rslt[i] = this.storage.get((int)i).value;
            ++i;
        }
        return rslt;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        if (array.length != this.storage.size()) {
            throw new UnsupportedOperationException();
        }
        Class<?> elemType = array.getClass().getComponentType();
        Object[] elems = (Object[])Array.newInstance(elemType, this.storage.size());
        int i = 0;
        while (i < this.storage.size()) {
            elems[i] = this.storage.get((int)i).value;
            ++i;
        }
        Object[] rslt = elems;
        return rslt;
    }

    public String toString() {
        StringBuilder txt = new StringBuilder();
        txt.append("[");
        for (ToolDefEqWrap<E> elem : this.storage) {
            if (txt.length() > 1) {
                txt.append(", ");
            }
            txt.append(elem.toString());
        }
        txt.append("]");
        return txt.toString();
    }
}

