/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.explorer.runtime;

import java.util.Arrays;
import java.util.List;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.explorer.runtime.Explorer;
import org.eclipse.escet.cif.explorer.runtime.ExplorerTransition;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class BaseState {
    protected final Explorer explorer;
    public final Location[] locations;
    public final Object[] values;
    public int stateNumber = -1;
    public List<ExplorerTransition> outgoingTransitions = null;
    public List<ExplorerTransition> incomingTransitions = Lists.list();

    public BaseState(Explorer explorer, Location[] locations, Object[] values) {
        this.explorer = explorer;
        this.locations = locations;
        this.values = values;
    }

    public Object eval(Expression expr, Object commVal) throws CifEvalException {
        return this.explorer.evaluator.eval(expr, this, commVal);
    }

    public List<ExplorerTransition> getOutgoingTransitions() {
        if (this.outgoingTransitions == null) {
            this.outgoingTransitions = Lists.list();
            this.explorer.computeOutgoing(this, false);
        }
        return this.outgoingTransitions;
    }

    public List<BaseState> getNewSuccessorStates() {
        Assert.check((this.outgoingTransitions == null ? 1 : 0) != 0);
        this.outgoingTransitions = Lists.list();
        return this.explorer.computeOutgoing(this, true);
    }

    public List<ExplorerTransition> getIncomingTransitions() {
        return this.incomingTransitions;
    }

    public void removeIncoming(ExplorerTransition transition) {
        int lastTransition = this.incomingTransitions.size() - 1;
        int i = 0;
        while (i <= lastTransition) {
            if (this.incomingTransitions.get(i) == transition) {
                if (i < lastTransition) {
                    this.incomingTransitions.set(i, this.incomingTransitions.get(lastTransition));
                }
                this.incomingTransitions.remove(lastTransition);
                return;
            }
            ++i;
        }
        throw new RuntimeException("Could not find transition.");
    }

    public void removeOutgoing(ExplorerTransition transition) {
        int lastTransition = this.outgoingTransitions.size() - 1;
        int i = 0;
        while (i <= lastTransition) {
            if (this.outgoingTransitions.get(i) == transition) {
                if (i < lastTransition) {
                    this.outgoingTransitions.set(i, this.outgoingTransitions.get(lastTransition));
                }
                this.outgoingTransitions.remove(lastTransition);
                return;
            }
            ++i;
        }
        throw new RuntimeException("Could not find transition.");
    }

    public abstract boolean isInitial();

    public abstract boolean isMarked();

    public abstract Object getVarValue(PositionObject var1);

    public abstract void setVarValue(PositionObject var1, Object var2);

    public abstract Location getCurrentLocation(int var1);

    public abstract Expression getAlgExpression(AlgVariable var1);

    public boolean equals(Object other) {
        if (!(other instanceof BaseState)) {
            return false;
        }
        BaseState otherVal = (BaseState)other;
        return Arrays.equals(this.locations, otherVal.locations) && Arrays.equals(this.values, otherVal.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.locations) + Arrays.hashCode(this.values) * 911;
    }

    public void printDebug(CodeBox box) {
        box.add(Strings.fmt((String)"State %d:", (Object[])new Object[]{this.stateNumber}));
        box.indent();
        box.add("Initial: " + (this.isInitial() ? "true" : "false"));
        box.add("Marked: " + (this.isMarked() ? "true" : "false"));
        if (this.locations.length > 0) {
            box.add();
            box.add("Locations:");
            box.indent();
            Location[] locationArray = this.locations;
            int n = this.locations.length;
            int n2 = 0;
            while (n2 < n) {
                Location loc = locationArray[n2];
                box.add(CifTextUtils.getLocationText1((Location)loc));
                ++n2;
            }
            box.dedent();
        }
        if (this.values.length > 0) {
            box.add();
            box.add("Valuation:");
            box.indent();
            String[] varNames = this.explorer.getVariableNames();
            int i = 0;
            while (i < this.values.length) {
                String valueText = CifEvalUtils.objToStr((Object)this.values[i]);
                box.add(Strings.fmt((String)"%s = %s", (Object[])new Object[]{varNames[i], valueText}));
                ++i;
            }
            box.dedent();
        }
        this.printOtherStateInformation(box);
        if (this.outgoingTransitions != null && !this.outgoingTransitions.isEmpty()) {
            box.add();
            box.add("Transitions:");
            box.indent();
            for (ExplorerTransition transition : this.outgoingTransitions) {
                String eventName = transition.event == null ? "tau" : CifTextUtils.getAbsName((PositionObject)transition.event);
                String sendValue = transition.commValue == null ? "" : " value " + CifEvalUtils.objToStr((Object)transition.commValue);
                String target = Strings.fmt((String)" goto state %d", (Object[])new Object[]{transition.next.stateNumber});
                box.add("transition " + eventName + sendValue + target);
            }
            box.dedent();
        }
        box.dedent();
    }

    protected void printOtherStateInformation(CodeBox box) {
    }

    public String toString() {
        StringBuilder txt = new StringBuilder();
        int i = 0;
        while (i < this.locations.length) {
            if (txt.length() > 0) {
                txt.append(", ");
            }
            txt.append(CifTextUtils.getAbsName((PositionObject)this.explorer.automata[i]));
            txt.append(": ");
            Location loc = this.locations[i];
            if (loc == null) {
                txt.append("?");
            } else {
                txt.append(CifLocationUtils.getName((Location)loc));
            }
            ++i;
        }
        i = 0;
        while (i < this.values.length) {
            if (txt.length() > 0) {
                txt.append(", ");
            }
            txt.append(CifTextUtils.getAbsName((PositionObject)this.explorer.variables[i]));
            txt.append(": ");
            Object value = this.values[i];
            if (value == null) {
                txt.append("?");
            } else {
                txt.append(CifEvalUtils.objToStr((Object)value));
            }
            ++i;
        }
        return txt.toString();
    }
}

