/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.CifSvgCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGeneratorResult;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.cif.simulator.compiler.TypeCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.UpdatesCodeGenerator;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeEventKind;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class EventCodeGenerator {
    private EventCodeGenerator() {
    }

    public static void gencodeEvents(Specification spec, CifCompilerContext ctxt) {
        List<Event> events = ctxt.getEvents();
        Event tau = ctxt.tauEvent;
        String tauName = ctxt.getEventClassName(tau);
        Assert.check((boolean)tauName.equals("Event_tau"));
        EventCodeGenerator.gencodeEnvironmentEvents(spec, ctxt);
        EventCodeGenerator.gencodeRegularAndTauEvents(spec, events, ctxt);
    }

    private static void gencodeEnvironmentEvents(Specification spec, CifCompilerContext ctxt) {
        List<EnvironmentEventInfo> infos = EventCodeGenerator.getEnvironmentEventInfos(spec, ctxt);
        ctxt.setEnvironmentEvents(infos);
        for (EnvironmentEventInfo info : infos) {
            if (info instanceof SvgInputEnvironmentEventInfo) {
                SvgInputEnvironmentEventInfo svgInfo = (SvgInputEnvironmentEventInfo)info;
                EventCodeGenerator.gencodeSvgInputEnvironmentEvent(svgInfo, ctxt);
                continue;
            }
            if (info instanceof TraceInputEnvironmentEventInfo) {
                TraceInputEnvironmentEventInfo traceInfo = (TraceInputEnvironmentEventInfo)info;
                EventCodeGenerator.gencodeTraceInputEnvironmentEvent(traceInfo, ctxt);
                continue;
            }
            throw new AssertionError((Object)("Unknown info: " + String.valueOf(info)));
        }
    }

    private static List<EnvironmentEventInfo> getEnvironmentEventInfos(Specification spec, CifCompilerContext ctxt) {
        List infos = Lists.list();
        int svgFileIdx = -1;
        for (Map.Entry<String, CifSvgCodeGenerator.CifSvgDecls> entry : ctxt.getSvgFileToDecls().entrySet()) {
            ++svgFileIdx;
            for (SvgIn svgIn : entry.getValue().svgIns) {
                if (svgIn.getUpdates().isEmpty()) continue;
                String svgInId = CifSvgCodeGenerator.evalSvgStringExpr(svgIn.getId());
                String svgFileRelPath = Paths.getRelativePath((String)entry.getKey(), (String)ctxt.getSpecFileDir());
                String eventName = Strings.fmt((String)"<svgin id \"%s\" file \"%s\">", (Object[])new Object[]{svgInId, svgFileRelPath});
                infos.add(new SvgInputEnvironmentEventInfo(eventName, svgFileIdx, svgFileRelPath, svgIn));
            }
        }
        List<Declaration> stateVars = ctxt.getStateVars();
        int stateVarIdx = 0;
        while (stateVarIdx < stateVars.size()) {
            Declaration stateVar = stateVars.get(stateVarIdx);
            if (stateVar instanceof InputVariable) {
                InputVariable inputVar = (InputVariable)stateVar;
                String eventName = Strings.fmt((String)"<trace variable \"%s\">", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)inputVar)});
                infos.add(new TraceInputEnvironmentEventInfo(eventName, inputVar));
            }
            ++stateVarIdx;
        }
        return infos;
    }

    private static void gencodeSvgInputEnvironmentEvent(SvgInputEnvironmentEventInfo info, CifCompilerContext ctxt) {
        String className = ctxt.getEventClassName(info);
        JavaCodeFile file = ctxt.addCodeFile(className);
        CodeBox h = file.header;
        h.add("/** Event \"%s\". */", new Object[]{info.eventName});
        h.add("public final class %s extends SvgInputRuntimeEnvironmentEvent<State> {", new Object[]{className});
        CodeBox c = file.body;
        c.add();
        c.add("public %s() {", new Object[]{className});
        c.indent();
        c.add("super(\"%s\", %d);", new Object[]{StringEscapeUtils.escapeJava((String)info.eventName), ctxt.getRuntimeEventIdx(info)});
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public void update(State source, State target) {");
        c.indent();
        c.add("boolean b; // temp var for pred eval rslts");
        c.add("target.%s = target.%s.copy();", new Object[]{"i", "i"});
        c.add("try {");
        c.indent();
        List<ExprCodeGeneratorResult> updateResults = UpdatesCodeGenerator.gencodeUpdates(c, null, ctxt, (List<Update>)info.svgIn.getUpdates(), "source");
        String svgInId = CifSvgCodeGenerator.evalSvgStringExpr(info.svgIn.getId());
        c.dedent();
        c.add("} catch (CifSimulatorException e) {");
        c.indent();
        c.add("throw new CifSimulatorException(\"Execution of the updates of the SVG input mapping (\\\"%s\\\") for the SVG element with id \\\"%s\\\" failed.\", e, source);", new Object[]{StringEscapeUtils.escapeJava((String)info.svgFileRelPath), StringEscapeUtils.escapeJava((String)svgInId)});
        c.dedent();
        c.add("}");
        c.dedent();
        c.add("}");
        for (ExprCodeGeneratorResult updateResult : updateResults) {
            updateResult.addExtraMethods(c);
        }
    }

    private static void gencodeTraceInputEnvironmentEvent(TraceInputEnvironmentEventInfo info, CifCompilerContext ctxt) {
        String className = ctxt.getEventClassName(info);
        JavaCodeFile file = ctxt.addCodeFile(className);
        file.imports.add("org.eclipse.escet.cif.simulator.input.trace.TraceInputRuntimeEnvironmentEvent");
        file.imports.add("org.eclipse.escet.cif.simulator.input.trace.InputVarUpdateTraceCommand");
        CodeBox h = file.header;
        h.add("/** Event \"%s\". */", new Object[]{info.eventName});
        h.add("public final class %s extends TraceInputRuntimeEnvironmentEvent<State> {", new Object[]{className});
        CodeBox c = file.body;
        c.add();
        c.add("public %s() {", new Object[]{className});
        c.indent();
        c.add("super(\"%s\", %d, \"%s\");", new Object[]{StringEscapeUtils.escapeJava((String)info.eventName), ctxt.getRuntimeEventIdx(info), CifTextUtils.getAbsName((PositionObject)info.inputVar, (boolean)false)});
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public void update(State source, State target, InputVarUpdateTraceCommand command) {");
        c.indent();
        c.add("try {");
        c.indent();
        String inputVarJavaType = TypeCodeGenerator.gencodeType(info.inputVar.getType(), ctxt, true);
        c.add("if (command.value instanceof %s) {", new Object[]{inputVarJavaType});
        c.indent();
        c.add("target.%s.%s = (%s)command.value;", new Object[]{"i", ctxt.getInputVarFieldName(info.inputVar), inputVarJavaType});
        c.dedent();
        c.add("} else {");
        c.indent();
        c.add("throw new CifSimulatorException(fmt(\"Assigned value \\\"%%s\\\" is invalid for the input variable's type \\\"%s\\\".\", RuntimeValueToString.runtimeToString(command.value)));", new Object[]{CifTextUtils.typeToStr((CifType)info.inputVar.getType())});
        c.dedent();
        c.add("}");
        c.dedent();
        c.add("} catch (CifSimulatorException e) {");
        c.indent();
        c.add("throw new CifSimulatorException(\"Failed to assign input variable \\\"%s\\\" through a trace input command.\", e, source);", new Object[]{CifTextUtils.getAbsName((PositionObject)info.inputVar)});
        c.dedent();
        c.add("}");
        c.dedent();
        c.add("}");
    }

    public static void gencodeRegularAndTauEvents(Specification spec, List<Event> events, CifCompilerContext ctxt) {
        for (Event event : events) {
            String absName;
            boolean isTau = event == ctxt.tauEvent;
            boolean isComm = event.getType() != null;
            String string = absName = isTau ? "tau" : CifTextUtils.getAbsName((PositionObject)event);
            String ctrlTxt = event.getControllable() == null ? "null" : (event.getControllable() != false ? "true" : "false");
            int runtimeEventIdx = ctxt.getRuntimeEventIdx(event);
            RuntimeEventKind kind = ctxt.getRuntimeEventKind(runtimeEventIdx);
            String className = ctxt.getEventClassName(event);
            JavaCodeFile file = ctxt.addCodeFile(className);
            CodeBox h = file.header;
            h.add("/** Event \"%s\". */", new Object[]{absName});
            h.add("public final class %s extends RuntimeCifEvent<State> {", new Object[]{className});
            CodeBox c = file.body;
            c.add("public %s() {", new Object[]{className});
            c.indent();
            c.add("super(\"%s\", %d, RuntimeEventKind.%s, %s);", new Object[]{absName, runtimeEventIdx, kind.name(), ctrlTxt});
            c.dedent();
            c.add("}");
            c.add();
            c.add("@Override");
            c.add("public boolean fillData(State state) {");
            c.indent();
            if (isComm) {
                c.add("// Send.");
                c.add("SPEC.sendData.get(%d).clear();", new Object[]{runtimeEventIdx});
                EventCodeGenerator.genFillCallsSend(event, c, ctxt);
                c.add("if (SPEC.sendData.get(%d).isEmpty()) return false;", new Object[]{runtimeEventIdx});
                c.add();
                c.add("// Receive.");
                c.add("SPEC.recvData.get(%d).clear();", new Object[]{runtimeEventIdx});
                EventCodeGenerator.genFillCallsRecv(event, c, ctxt);
                c.add("if (SPEC.recvData.get(%d).isEmpty()) return false;", new Object[]{runtimeEventIdx});
                c.add();
            }
            if (isTau) {
                c.add("SPEC.tauData.clear();");
                EventCodeGenerator.genFillCallsTau(c, ctxt);
                c.add("return !SPEC.tauData.isEmpty();");
            } else {
                c.add("// Sync.");
                c.add("boolean proceed;");
                EventCodeGenerator.genFillCallsSync(event, c, ctxt);
                c.add();
                c.add("// All done, possible so far.");
                if (!isComm && ctxt.getSyncAuts(event).isEmpty()) {
                    c.add("return false; // No aut has event in alphabet.");
                } else {
                    c.add("return true;");
                }
            }
            c.dedent();
            c.add("}");
            if (isComm) {
                int sendAutsCnt = ctxt.getSendAuts(event).size();
                int recvAutsCnt = ctxt.getRecvAuts(event).size();
                int syncAutsCnt = ctxt.getSyncAuts(event).size();
                int cnt = 0;
                cnt += sendAutsCnt;
                cnt += recvAutsCnt;
                if ((cnt += syncAutsCnt) > 0 && sendAutsCnt == 0) {
                    OutputProvider.warn((String)"No senders found for channel \"%s\".", (Object[])new Object[]{absName});
                }
                if (cnt > 0 && recvAutsCnt == 0) {
                    OutputProvider.warn((String)"No receivers found for channel \"%s\".", (Object[])new Object[]{absName});
                }
            }
            c.add();
            c.add("@Override");
            c.add("public boolean allowedByInvs(State state) {");
            c.indent();
            List exprResults = Lists.list();
            exprResults.addAll(EventCodeGenerator.genAllowedByInvsComp((ComplexComponent)spec, event, c, ctxt));
            for (Automaton aut : ctxt.getAutomata()) {
                exprResults.addAll(EventCodeGenerator.genAllowedByInvsAutLocs(aut, event, c, ctxt));
            }
            c.add("// Event allowed by invariants.");
            c.add("return true;");
            c.dedent();
            c.add("}");
            for (ExprCodeGeneratorResult exprResult : exprResults) {
                exprResult.addExtraMethods(c);
            }
        }
    }

    private static void genFillCallsTau(CodeBox c, CifCompilerContext ctxt) {
        List<Automaton> auts = ctxt.getAutomata();
        for (Automaton aut : auts) {
            c.add("%s.fillTauData(state);", new Object[]{ctxt.getAutClassName(aut)});
        }
    }

    private static void genFillCallsSend(Event event, CodeBox c, CifCompilerContext ctxt) {
        List<Automaton> auts = ctxt.getSendAuts(event);
        for (Automaton aut : auts) {
            c.add("%s.fillSendData_%d(state);", new Object[]{ctxt.getAutClassName(aut), ctxt.getRuntimeEventIdx(event)});
        }
    }

    private static void genFillCallsRecv(Event event, CodeBox c, CifCompilerContext ctxt) {
        List<Automaton> auts = ctxt.getRecvAuts(event);
        for (Automaton aut : auts) {
            c.add("%s.fillRecvData_%d(state);", new Object[]{ctxt.getAutClassName(aut), ctxt.getRuntimeEventIdx(event)});
        }
    }

    private static void genFillCallsSync(Event event, CodeBox c, CifCompilerContext ctxt) {
        List<Automaton> auts = ctxt.getSyncAuts(event);
        for (Automaton aut : auts) {
            c.add();
            c.add("// Check automaton \"%s\".", new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
            c.add("proceed = %s.fillSyncData_%d(state);", new Object[]{ctxt.getAutClassName(aut), ctxt.getRuntimeEventIdx(event)});
            c.add("if (!proceed) return false;");
        }
    }

    private static List<ExprCodeGeneratorResult> genAllowedByInvsComp(ComplexComponent comp, Event event, CodeBox c, CifCompilerContext ctxt) {
        List stateEvtExclInvs = Lists.list();
        for (Invariant inv : comp.getInvariants()) {
            Event invEvent;
            if (inv.getInvKind() == InvKind.STATE || (invEvent = ((EventExpression)inv.getEvent()).getEvent()) != event) continue;
            stateEvtExclInvs.add(inv);
        }
        String absName = CifTextUtils.getAbsName((PositionObject)comp);
        if (!stateEvtExclInvs.isEmpty()) {
            c.add("// Invariants for \"%s\".", new Object[]{absName});
        }
        String compTxt = CifTextUtils.getComponentText2((ComplexComponent)comp);
        List exprResults = Lists.list();
        for (Invariant inv : stateEvtExclInvs) {
            Expression pred = inv.getPredicate();
            c.add("try {");
            c.indent();
            ExprCodeGeneratorResult predResult = ExprCodeGenerator.gencodeExpr(pred, ctxt, "state");
            exprResults.add(predResult);
            InvKind invKind = inv.getInvKind();
            switch (invKind) {
                case EVENT_DISABLES: {
                    c.add("if (%s) return false;", new Object[]{predResult});
                    break;
                }
                case EVENT_NEEDS: {
                    c.add("if (!(%s)) return false;", new Object[]{predResult});
                    break;
                }
                default: {
                    String msg = "Unknown state/evt excl inv: " + String.valueOf(invKind);
                    throw new RuntimeException(msg);
                }
            }
            String invTxt = CifTextUtils.invToStr((Invariant)inv, (boolean)false);
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(\"Evaluation of invariant \\\"%s\\\" of %s failed.\", e, state);", new Object[]{StringEscapeUtils.escapeJava((String)Strings.truncate((String)invTxt, (int)1000)), StringEscapeUtils.escapeJava((String)compTxt)});
            c.dedent();
            c.add("}");
            c.add();
            if (inv.getSupKind() != SupKind.REQUIREMENT) continue;
            OutputProvider.warn((String)"Invariant \"%s\" of %s is a requirement, but will be simulated as a plant.", (Object[])new Object[]{invTxt, compTxt});
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                exprResults.addAll(EventCodeGenerator.genAllowedByInvsComp((ComplexComponent)child, event, c, ctxt));
            }
        }
        return exprResults;
    }

    private static List<ExprCodeGeneratorResult> genAllowedByInvsAutLocs(Automaton aut, Event event, CodeBox c, CifCompilerContext ctxt) {
        c.add("// Invariants for current location.");
        c.add("switch (state.%s.%s) {", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
        c.indent();
        EList locs = aut.getLocations();
        List exprResults = Lists.list();
        int locIdx = 0;
        while (locIdx < locs.size()) {
            Location loc = (Location)locs.get(locIdx);
            List locEvtExclInvs = Lists.list();
            for (Invariant inv : loc.getInvariants()) {
                Event invEvent;
                if (inv.getInvKind() == InvKind.STATE || (invEvent = ((EventExpression)inv.getEvent()).getEvent()) != event) continue;
                locEvtExclInvs.add(inv);
            }
            if (!locEvtExclInvs.isEmpty()) {
                c.add("case %s:", new Object[]{ctxt.getLocationValueText(loc, locIdx)});
                c.indent();
                String locTxt = CifTextUtils.getLocationText2((Location)loc);
                for (Invariant inv : locEvtExclInvs) {
                    Expression pred = inv.getPredicate();
                    c.add("try {");
                    c.indent();
                    ExprCodeGeneratorResult predResult = ExprCodeGenerator.gencodeExpr(pred, ctxt, "state");
                    exprResults.add(predResult);
                    InvKind invKind = inv.getInvKind();
                    switch (invKind) {
                        case EVENT_DISABLES: {
                            c.add("if (%s) return false;", new Object[]{predResult});
                            break;
                        }
                        case EVENT_NEEDS: {
                            c.add("if (!(%s)) return false;", new Object[]{predResult});
                            break;
                        }
                        default: {
                            String msg = "Unknown state/evt excl inv: " + String.valueOf(invKind);
                            throw new RuntimeException(msg);
                        }
                    }
                    String invTxt = CifTextUtils.invToStr((Invariant)inv, (boolean)false);
                    c.dedent();
                    c.add("} catch (CifSimulatorException e) {");
                    c.indent();
                    c.add("throw new CifSimulatorException(\"Evaluation of invariant \\\"%s\\\" of %s failed.\", e, state);", new Object[]{StringEscapeUtils.escapeJava((String)Strings.truncate((String)invTxt, (int)1000)), StringEscapeUtils.escapeJava((String)locTxt)});
                    c.dedent();
                    c.add("}");
                    if (inv.getSupKind() != SupKind.REQUIREMENT) continue;
                    OutputProvider.warn((String)"Invariant \"%s\" of %s is a requirement, but will be simulated as a plant.", (Object[])new Object[]{invTxt, locTxt});
                }
                c.add("break;");
                c.dedent();
            }
            ++locIdx;
        }
        c.dedent();
        c.add("}");
        c.add();
        return exprResults;
    }

    static abstract class EnvironmentEventInfo {
        int environmentEventIdx = -1;
        final String eventName;

        EnvironmentEventInfo(String eventName) {
            this.eventName = eventName;
        }
    }

    static class SvgInputEnvironmentEventInfo
    extends EnvironmentEventInfo {
        final int svgFileIdx;
        final String svgFileRelPath;
        final SvgIn svgIn;

        SvgInputEnvironmentEventInfo(String eventName, int svgFileIdx, String svgFileRelPath, SvgIn svgIn) {
            super(eventName);
            this.svgFileIdx = svgFileIdx;
            this.svgFileRelPath = svgFileRelPath;
            this.svgIn = svgIn;
        }
    }

    static class TraceInputEnvironmentEventInfo
    extends EnvironmentEventInfo {
        final InputVariable inputVar;

        TraceInputEnvironmentEventInfo(String eventName, InputVariable inputVar) {
            super(eventName);
            this.inputVar = inputVar;
        }
    }
}

