/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.options;

import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

public abstract class IntegerOption
extends Option<Integer> {
    protected final boolean hasSpecialValue;
    protected final Integer defaultValue;
    protected final Integer defaultNormalValue;
    protected final int minimumValue;
    protected final int maximumValue;
    protected final String specialValueSyntax;
    protected final int pageIncrementValue;
    protected final String optDialogDescr;
    protected final String optDialogSpecialText;
    protected final String optDialogNormalText;
    protected final String optDialogLabelText;

    public IntegerOption(String name, String description, Character cmdShort, String cmdLong, String cmdValue, int defaultValue, int minimumValue, int maximumValue, int pageIncrementValue, boolean showInDialog, String optDialogDescr, String optDialogLabelText) {
        this(name, description, cmdShort, cmdLong, cmdValue, defaultValue, minimumValue, maximumValue, pageIncrementValue, showInDialog, optDialogDescr, optDialogLabelText, false, null, null, null, null);
    }

    public IntegerOption(String name, String description, Character cmdShort, String cmdLong, String cmdValue, Integer defaultValue, int minimumValue, int maximumValue, int pageIncrementValue, boolean showInDialog, String optDialogDescr, String optDialogLabelText, boolean hasSpecialValue, Integer defaultNormalValue, String specialValueSyntax, String optDialogSpecialText, String optDialogNormalText) {
        super(name, description, cmdShort, cmdLong, cmdValue, showInDialog);
        Assert.notNull((Object)cmdLong);
        Assert.check((!cmdLong.equals("*") ? 1 : 0) != 0);
        Assert.notNull((Object)cmdValue);
        Assert.implies((defaultValue == null ? 1 : 0) != 0, (boolean)hasSpecialValue);
        if (defaultValue != null) {
            Assert.check((minimumValue <= defaultValue ? 1 : 0) != 0);
            Assert.check((defaultValue <= maximumValue ? 1 : 0) != 0);
        }
        Assert.ifAndOnlyIf((!showInDialog || !hasSpecialValue ? 1 : 0) != 0, (defaultNormalValue == null ? 1 : 0) != 0);
        if (defaultNormalValue != null) {
            Assert.check((minimumValue <= defaultNormalValue ? 1 : 0) != 0);
            Assert.check((defaultNormalValue <= maximumValue ? 1 : 0) != 0);
        }
        Assert.ifAndOnlyIf((boolean)showInDialog, (optDialogDescr != null ? 1 : 0) != 0);
        Assert.implies((!showInDialog ? 1 : 0) != 0, (optDialogLabelText == null ? 1 : 0) != 0);
        if (optDialogLabelText != null) {
            Assert.check((boolean)optDialogLabelText.endsWith(":"));
        }
        Assert.ifAndOnlyIf((boolean)hasSpecialValue, (specialValueSyntax != null ? 1 : 0) != 0);
        Assert.ifAndOnlyIf((hasSpecialValue && showInDialog ? 1 : 0) != 0, (optDialogSpecialText != null ? 1 : 0) != 0);
        Assert.ifAndOnlyIf((hasSpecialValue && showInDialog ? 1 : 0) != 0, (optDialogNormalText != null ? 1 : 0) != 0);
        this.defaultValue = defaultValue;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.pageIncrementValue = pageIncrementValue;
        this.optDialogDescr = optDialogDescr;
        this.optDialogLabelText = optDialogLabelText;
        this.hasSpecialValue = hasSpecialValue;
        this.defaultNormalValue = defaultNormalValue;
        this.specialValueSyntax = specialValueSyntax;
        this.optDialogSpecialText = optDialogSpecialText;
        this.optDialogNormalText = optDialogNormalText;
    }

    @Override
    public Integer getDefault() {
        return this.defaultValue;
    }

    @Override
    public Integer parseValue(String optName, String value) {
        int v;
        if (this.hasSpecialValue && value.equals(this.specialValueSyntax)) {
            return null;
        }
        try {
            v = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            String msg = Strings.fmt((String)"Invalid integer number \"%s\".", (Object[])new Object[]{value});
            throw new InvalidOptionException(msg);
        }
        IntegerOption.checkValue(v >= this.minimumValue, v + " < " + this.minimumValue);
        IntegerOption.checkValue(v <= this.maximumValue, v + " > " + this.maximumValue);
        return v;
    }

    @Override
    public String[] getCmdLine(Object value) {
        if (value == null) {
            Assert.check((boolean)this.hasSpecialValue);
            return new String[]{"--" + this.cmdLong + "=" + this.specialValueSyntax};
        }
        return new String[]{"--" + this.cmdLong + "=" + String.valueOf(value)};
    }

    @Override
    public OptionGroup<Integer> createOptionGroup(Composite page) {
        Assert.check((boolean)this.showInDialog);
        return new IntegerOptionGroup(page);
    }

    private class IntegerOptionGroup
    extends OptionGroup<Integer>
    implements SelectionListener {
        private Button specialButton;
        private Button normalButton;
        Label valueLabel;
        Spinner valueSpinner;

        public IntegerOptionGroup(Composite page) {
            super(page, IntegerOption.this);
        }

        @Override
        protected void addComponents(Group group) {
            Object[] valueLayout;
            if (IntegerOption.this.hasSpecialValue) {
                this.specialButton = new Button((Composite)group, 16);
                this.specialButton.setText(IntegerOption.this.optDialogSpecialText);
                this.normalButton = new Button((Composite)group, 16);
                this.normalButton.setText(IntegerOption.this.optDialogNormalText);
                this.specialButton.addSelectionListener((SelectionListener)this);
                this.normalButton.addSelectionListener((SelectionListener)this);
            }
            this.valueSpinner = new Spinner((Composite)group, 2048);
            this.valueSpinner.setValues((IntegerOption.this.defaultValue == null ? IntegerOption.this.defaultNormalValue : IntegerOption.this.defaultValue).intValue(), IntegerOption.this.minimumValue, IntegerOption.this.maximumValue, 0, 1, IntegerOption.this.pageIncrementValue);
            if (IntegerOption.this.optDialogLabelText == null) {
                valueLayout = new Control[]{this.valueSpinner};
            } else {
                this.valueLabel = new Label((Composite)group, 0);
                this.valueLabel.setText(IntegerOption.this.optDialogLabelText);
                valueLayout = new Control[]{this.valueLabel, this.valueSpinner};
            }
            Object[] layout = IntegerOption.this.hasSpecialValue ? new Object[]{this.specialButton, this.normalButton, valueLayout} : (IntegerOption.this.optDialogLabelText == null ? valueLayout : new Object[]{valueLayout});
            this.layoutGeneric(layout, IntegerOption.this.hasSpecialValue ? 32 : 0);
        }

        @Override
        public String getDescription() {
            return IntegerOption.this.optDialogDescr;
        }

        @Override
        public void setToValue(Integer value) {
            if (value == null) {
                Assert.check((boolean)IntegerOption.this.hasSpecialValue);
                this.specialButton.setSelection(true);
                Event event = new Event();
                event.widget = this.specialButton;
                this.widgetSelected(new SelectionEvent(event));
                value = IntegerOption.this.defaultNormalValue;
            } else if (IntegerOption.this.hasSpecialValue) {
                this.normalButton.setSelection(true);
                Event event = new Event();
                event.widget = this.normalButton;
                this.widgetSelected(new SelectionEvent(event));
            }
            this.valueSpinner.setSelection(value.intValue());
        }

        @Override
        public String[] getCmdLine() {
            if (IntegerOption.this.hasSpecialValue && this.specialButton.getSelection()) {
                return new String[]{"--" + IntegerOption.this.cmdLong + "=" + IntegerOption.this.specialValueSyntax};
            }
            int value = this.valueSpinner.getSelection();
            return new String[]{"--" + IntegerOption.this.cmdLong + "=" + value};
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.specialButton) {
                this.valueSpinner.setEnabled(false);
            } else if (e.widget == this.normalButton) {
                this.valueSpinner.setEnabled(true);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

