/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.updates;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.common.java.Strings;

public class VariableWrapper {
    public final Declaration decl;
    public final boolean isDerivative;

    public VariableWrapper(Declaration decl, boolean isDerivative) {
        this.decl = decl;
        this.isDerivative = decl instanceof ContVariable && isDerivative;
    }

    public boolean isAlgebraic() {
        return this.decl instanceof AlgVariable;
    }

    public boolean isDerivative() {
        return this.isDerivative && this.decl instanceof ContVariable;
    }

    public int hashCode() {
        if (this.decl == null) {
            return 381;
        }
        return this.decl.hashCode() + (this.isDerivative ? 1 : 0);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VariableWrapper)) {
            return false;
        }
        VariableWrapper otherVw = (VariableWrapper)other;
        if (this.decl == null || otherVw.decl == null) {
            return this.decl == null && otherVw.decl == null;
        }
        return this.decl == otherVw.decl && this.isDerivative == otherVw.isDerivative;
    }

    public static VariableWrapper makeVariableWrapper(Expression expr) {
        Expression expression = expr;
        Objects.requireNonNull(expression);
        Expression expression2 = expression;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AlgVariableExpression.class, ContVariableExpression.class, DiscVariableExpression.class, InputVariableExpression.class, TimeExpression.class}, (Object)expression2, n)) {
            case 0 -> {
                AlgVariableExpression aExpr = (AlgVariableExpression)expression2;
                yield new VariableWrapper((Declaration)aExpr.getVariable(), false);
            }
            case 1 -> {
                ContVariableExpression cExpr = (ContVariableExpression)expression2;
                yield new VariableWrapper((Declaration)cExpr.getVariable(), cExpr.isDerivative());
            }
            case 2 -> {
                DiscVariableExpression dExpr = (DiscVariableExpression)expression2;
                yield new VariableWrapper((Declaration)dExpr.getVariable(), false);
            }
            case 3 -> {
                InputVariableExpression iExpr = (InputVariableExpression)expression2;
                yield new VariableWrapper((Declaration)iExpr.getVariable(), false);
            }
            case 4 -> {
                TimeExpression tExpr = (TimeExpression)expression2;
                yield new VariableWrapper(null, false);
            }
            default -> throw new RuntimeException("Unexpected variable expression node " + Strings.str((Object)expr));
        };
    }

    public String toString() {
        if (this.decl instanceof ContVariable) {
            return Strings.fmt((String)"Wrapped(\"%s\", %s)", (Object[])new Object[]{this.decl.getName(), this.isDerivative});
        }
        return Strings.fmt((String)"Wrapped(\"%s\")", (Object[])new Object[]{this.decl.getName()});
    }
}

