/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.common.java.DependencyOrderer;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class StateInitOrderer
extends DependencyOrderer<PositionObject> {
    protected Set<PositionObject> findDirectDependencies(PositionObject obj) {
        if (obj instanceof Declaration) {
            Object values;
            if (obj instanceof DiscVariable) {
                DiscVariable dvar = (DiscVariable)obj;
                if (dvar.getValue() == null) {
                    return Sets.set();
                }
                values = dvar.getValue().getValues();
                if (values == null) {
                    return Sets.set();
                }
            } else {
                if (obj instanceof InputVariable) {
                    return Sets.set();
                }
                ContVariable cvar = (ContVariable)obj;
                if (cvar.getValue() == null) {
                    return Sets.set();
                }
                values = Lists.list((Object)cvar.getValue());
            }
            Set rslt = Sets.set();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                Expression value = (Expression)iterator.next();
                StateInitOrderer.collectDependencies(value, rslt);
            }
            return rslt;
        }
        if (obj instanceof Automaton) {
            Automaton aut = (Automaton)obj;
            Set rslt = Sets.set();
            for (Location loc : aut.getLocations()) {
                if (loc.getInitials().isEmpty()) continue;
                rslt.add(loc);
            }
            return rslt;
        }
        if (obj instanceof Location) {
            Location loc = (Location)obj;
            Set rslt = Sets.set();
            for (Expression init : loc.getInitials()) {
                StateInitOrderer.collectDependencies(init, rslt);
            }
            return rslt;
        }
        throw new RuntimeException("Unexpected obj: " + String.valueOf(obj));
    }

    private static void collectDependencies(Expression expr, Set<PositionObject> deps) {
        if (expr instanceof BoolExpression) {
            return;
        }
        if (expr instanceof IntExpression) {
            return;
        }
        if (expr instanceof RealExpression) {
            return;
        }
        if (expr instanceof StringExpression) {
            return;
        }
        if (expr instanceof TimeExpression) {
            return;
        }
        if (expr instanceof CastExpression) {
            CastExpression castExpr = (CastExpression)expr;
            StateInitOrderer.collectDependencies(castExpr.getChild(), deps);
            return;
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression unaryExpr = (UnaryExpression)expr;
            StateInitOrderer.collectDependencies(unaryExpr.getChild(), deps);
            return;
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression binaryExpr = (BinaryExpression)expr;
            StateInitOrderer.collectDependencies(binaryExpr.getLeft(), deps);
            StateInitOrderer.collectDependencies(binaryExpr.getRight(), deps);
            return;
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            for (Expression guard : ifExpr.getGuards()) {
                StateInitOrderer.collectDependencies(guard, deps);
            }
            StateInitOrderer.collectDependencies(ifExpr.getThen(), deps);
            for (ElifExpression elif : ifExpr.getElifs()) {
                for (Expression guard : elif.getGuards()) {
                    StateInitOrderer.collectDependencies(guard, deps);
                }
                StateInitOrderer.collectDependencies(elif.getThen(), deps);
            }
            StateInitOrderer.collectDependencies(ifExpr.getElse(), deps);
            return;
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression switchExpr = (SwitchExpression)expr;
            StateInitOrderer.collectDependencies(switchExpr.getValue(), deps);
            for (SwitchCase cse : switchExpr.getCases()) {
                if (cse.getKey() != null) {
                    StateInitOrderer.collectDependencies(cse.getKey(), deps);
                }
                StateInitOrderer.collectDependencies(cse.getValue(), deps);
            }
            return;
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression projExpr = (ProjectionExpression)expr;
            StateInitOrderer.collectDependencies(projExpr.getChild(), deps);
            StateInitOrderer.collectDependencies(projExpr.getIndex(), deps);
            return;
        }
        if (expr instanceof SliceExpression) {
            SliceExpression sliceExpr = (SliceExpression)expr;
            StateInitOrderer.collectDependencies(sliceExpr.getChild(), deps);
            if (sliceExpr.getBegin() != null) {
                StateInitOrderer.collectDependencies(sliceExpr.getBegin(), deps);
            }
            if (sliceExpr.getEnd() != null) {
                StateInitOrderer.collectDependencies(sliceExpr.getEnd(), deps);
            }
            return;
        }
        if (expr instanceof FunctionCallExpression) {
            FunctionCallExpression funcExpr = (FunctionCallExpression)expr;
            for (Expression arg : funcExpr.getArguments()) {
                StateInitOrderer.collectDependencies(arg, deps);
            }
            StateInitOrderer.collectDependencies(funcExpr.getFunction(), deps);
            return;
        }
        if (expr instanceof ListExpression) {
            ListExpression listExpr = (ListExpression)expr;
            for (Expression elem : listExpr.getElements()) {
                StateInitOrderer.collectDependencies(elem, deps);
            }
            return;
        }
        if (expr instanceof SetExpression) {
            SetExpression setExpr = (SetExpression)expr;
            for (Expression elem : setExpr.getElements()) {
                StateInitOrderer.collectDependencies(elem, deps);
            }
            return;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression tupleExpr = (TupleExpression)expr;
            for (Expression field : tupleExpr.getFields()) {
                StateInitOrderer.collectDependencies(field, deps);
            }
            return;
        }
        if (expr instanceof DictExpression) {
            DictExpression dictExpr = (DictExpression)expr;
            for (DictPair pair : dictExpr.getPairs()) {
                StateInitOrderer.collectDependencies(pair.getKey(), deps);
                StateInitOrderer.collectDependencies(pair.getValue(), deps);
            }
            return;
        }
        if (expr instanceof ConstantExpression) {
            return;
        }
        if (expr instanceof EnumLiteralExpression) {
            return;
        }
        if (expr instanceof FieldExpression) {
            return;
        }
        if (expr instanceof StdLibFunctionExpression) {
            return;
        }
        if (expr instanceof FunctionExpression) {
            return;
        }
        if (expr instanceof DiscVariableExpression) {
            DiscVariableExpression discExpr = (DiscVariableExpression)expr;
            DiscVariable var = discExpr.getVariable();
            deps.add((PositionObject)var);
            return;
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariableExpression algExpr = (AlgVariableExpression)expr;
            AlgVariable var = algExpr.getVariable();
            List<Expression> values = CifEquationUtils.getValuesForAlgVar(var, false);
            for (Expression value : values) {
                StateInitOrderer.collectDependencies(value, deps);
            }
            if (CifEquationUtils.hasLocationEquations((PositionObject)var)) {
                deps.add((PositionObject)((Automaton)var.eContainer()));
            }
            return;
        }
        if (expr instanceof ContVariableExpression) {
            ContVariableExpression contExpr = (ContVariableExpression)expr;
            ContVariable var = contExpr.getVariable();
            if (contExpr.isDerivative()) {
                List<Expression> derivs = CifEquationUtils.getDerivativesForContVar(var, false);
                for (Expression deriv : derivs) {
                    StateInitOrderer.collectDependencies(deriv, deps);
                }
                if (CifEquationUtils.hasLocationEquations((PositionObject)var)) {
                    deps.add((PositionObject)((Automaton)var.eContainer()));
                }
                return;
            }
            deps.add((PositionObject)var);
            return;
        }
        if (expr instanceof InputVariableExpression) {
            return;
        }
        if (expr instanceof LocationExpression) {
            LocationExpression locExpr = (LocationExpression)expr;
            Location loc = locExpr.getLocation();
            deps.add((PositionObject)loc);
            return;
        }
        if (expr instanceof ComponentExpression) {
            ComponentExpression compExpr = (ComponentExpression)expr;
            Component comp = compExpr.getComponent();
            if (!(comp instanceof Automaton)) {
                throw new RuntimeException("comp ref as value: " + String.valueOf(comp));
            }
            deps.add((PositionObject)comp);
            return;
        }
        if (expr instanceof SelfExpression) {
            CifType ctype = CifTypeUtils.normalizeType(expr.getType());
            deps.add((PositionObject)((ComponentType)ctype).getComponent());
            return;
        }
        throw new RuntimeException("Unexpected expr: " + String.valueOf(expr));
    }
}

