/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.metamodel.cif.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum UnaryOperator implements Enumerator
{
    INVERSE(0, "Inverse", "Inverse"),
    NEGATE(1, "Negate", "Negate"),
    PLUS(2, "Plus", "Plus"),
    SAMPLE(3, "Sample", "Sample");

    public static final int INVERSE_VALUE = 0;
    public static final int NEGATE_VALUE = 1;
    public static final int PLUS_VALUE = 2;
    public static final int SAMPLE_VALUE = 3;
    private static final UnaryOperator[] VALUES_ARRAY;
    public static final List<UnaryOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UnaryOperator[]{INVERSE, NEGATE, PLUS, SAMPLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UnaryOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnaryOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnaryOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnaryOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnaryOperator get(int value) {
        switch (value) {
            case 0: {
                return INVERSE;
            }
            case 1: {
                return NEGATE;
            }
            case 2: {
                return PLUS;
            }
            case 3: {
                return SAMPLE;
            }
        }
        return null;
    }

    private UnaryOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

