/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.declwrap;

import java.util.List;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.EventParameter;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.parser.ast.AEventParameter;
import org.eclipse.escet.cif.parser.ast.AEventParameterPart;
import org.eclipse.escet.cif.parser.ast.tokens.AEventParamFlag;
import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypesTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.declwrap.DeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.EventDeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class EventParamDeclWrap
extends DeclWrap<EventParameter> {
    private final AEventParameter astDecl;
    private final AEventParameterPart astPartDecl;

    public EventParamDeclWrap(CifTypeChecker tchecker, ParentScope<?> scope, AEventParameter astDecl, AEventParameterPart astPartDecl, EventParameter mmDecl) {
        super(tchecker, scope, mmDecl);
        this.astDecl = astDecl;
        this.astPartDecl = astPartDecl;
    }

    @Override
    public String getName() {
        return ((EventParameter)this.mmDecl).getEvent().getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)((EventParameter)this.mmDecl).getEvent());
    }

    @Override
    public void tcheckForUseImpl() {
        this.checkName();
        if (this.astDecl.type != null) {
            CifType type;
            this.tchecker.addToCycle(this);
            try {
                type = CifTypesTypeChecker.transCifType(this.astDecl.type, this.scope.getParent(), this.tchecker);
            }
            finally {
                this.tchecker.removeFromCycle(this);
            }
            if (CifTypeUtils.hasComponentLikeType((CifType)type)) {
                this.tchecker.addProblem(ErrMsg.DECL_INVALID_TYPE, type.getPosition(), "Event parameter", this.getAbsName(), CifTextUtils.typeToStr((CifType)type));
                throw new SemanticException();
            }
            ((EventParameter)this.mmDecl).getEvent().setType(type);
        }
        boolean[] flags = new boolean[3];
        Position[] flagsPos = new Position[3];
        for (AEventParamFlag flag : this.astPartDecl.flags) {
            int flagIdx = switch (flag.flag) {
                case "!" -> 0;
                case "?" -> 1;
                case "~" -> 2;
                default -> throw new RuntimeException("Unknown flag: " + flag.flag);
            };
            if (flags[flagIdx]) {
                this.tchecker.addProblem(ErrMsg.EVENT_PARAM_DUPL_FLAG, flag.position, flag.flag, this.getAbsName());
                throw new SemanticException();
            }
            if (flagIdx == 0 && flags[1]) {
                this.tchecker.addProblem(ErrMsg.EVENT_PARAM_FLAG_ORDER, flag.position, flag.flag, "?", this.getAbsName());
            }
            if (flagIdx == 0 && flags[2]) {
                this.tchecker.addProblem(ErrMsg.EVENT_PARAM_FLAG_ORDER, flag.position, flag.flag, "~", this.getAbsName());
            }
            if (flagIdx == 1 && flags[2]) {
                this.tchecker.addProblem(ErrMsg.EVENT_PARAM_FLAG_ORDER, flag.position, flag.flag, "~", this.getAbsName());
            }
            flags[flagIdx] = true;
            flagsPos[flagIdx] = flag.createPosition();
        }
        ((EventParameter)this.mmDecl).setSendFlag(flags[0]);
        ((EventParameter)this.mmDecl).setRecvFlag(flags[1]);
        ((EventParameter)this.mmDecl).setSyncFlag(flags[2]);
        if (this.astDecl.type == null && !this.astPartDecl.flags.isEmpty()) {
            this.tchecker.addProblem(ErrMsg.EVENT_PARAM_FLAG_NON_CHAN, ((AEventParamFlag)Lists.first((List)this.astPartDecl.flags)).position, this.getAbsName());
            throw new SemanticException();
        }
        this.status = CheckStatus.USE;
    }

    @Override
    public void tcheckFull() {
        this.tcheckForUse();
        if (this.isCheckedFull()) {
            return;
        }
        CifType type = ((EventParameter)this.mmDecl).getEvent().getType();
        if (type != null && !(type instanceof VoidType) && CifValueUtils.getPossibleValueCount((CifType)type) == 1.0) {
            this.tchecker.addProblem(ErrMsg.TYPE_ONE_VALUE, type.getPosition(), "", CifTextUtils.typeToStr((CifType)type), "channel parameter", CifTextUtils.getAbsName((PositionObject)this.mmDecl, (boolean)false), "value communicated via the channel");
        }
        this.status = CheckStatus.FULL;
    }

    @Override
    protected void checkName() {
        EventDeclWrap.checkEventName(this.getName(), ((EventParameter)this.mmDecl).getEvent(), this.getPosition(), this.tchecker);
    }
}

