/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.input;

import java.util.List;
import java.util.Random;
import org.eclipse.escet.cif.simulator.input.ChosenTargetTime;
import org.eclipse.escet.cif.simulator.input.InputComponent;
import org.eclipse.escet.cif.simulator.options.AutoAlgoOption;
import org.eclipse.escet.cif.simulator.options.AutoTimeDuration;
import org.eclipse.escet.cif.simulator.options.AutoTimeDurationOption;
import org.eclipse.escet.cif.simulator.output.NormalOutputOption;
import org.eclipse.escet.cif.simulator.output.NormalOutputType;
import org.eclipse.escet.cif.simulator.runtime.SimulationResult;
import org.eclipse.escet.cif.simulator.runtime.SimulatorExitException;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeSpec;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.transitions.Transition;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public final class AutomaticInputComponent<S extends RuntimeState>
extends InputComponent<S> {
    private final int transChoice;
    private final AutoTimeDuration timeChoice;
    private final Random transRandom;
    private final Random timeRandom;
    private double nextInterruptTime = -1.0;

    public AutomaticInputComponent(RuntimeSpec<S> spec) {
        super(spec);
        Integer transSeed = null;
        this.transChoice = AutoAlgoOption.getAutoAlgo();
        if (this.transChoice == -2 || this.transChoice == -3) {
            this.transRandom = null;
        } else if (this.transChoice >= 0) {
            this.transRandom = new Random(this.transChoice);
        } else {
            Assert.check((this.transChoice == -1 ? 1 : 0) != 0);
            transSeed = new Random().nextInt(0x40000001);
            this.transRandom = new Random(transSeed.intValue());
            if (NormalOutputOption.doPrint(NormalOutputType.SEEDS)) {
                OutputProvider.out((String)"Using seed %d for random automatic mode choice algorithm.", (Object[])new Object[]{transSeed});
            }
        }
        Integer timeSeed = null;
        this.timeChoice = AutoTimeDurationOption.getAutoTimeDuration();
        if (!this.timeChoice.random()) {
            this.timeRandom = null;
        } else if (this.timeChoice.seed() != null) {
            this.timeRandom = new Random(this.timeChoice.seed().intValue());
        } else {
            timeSeed = new Random().nextInt(0x40000001);
            this.timeRandom = new Random(timeSeed.intValue());
            if (NormalOutputOption.doPrint(NormalOutputType.SEEDS)) {
                OutputProvider.out((String)"Using seed %d for random automatic mode time duration.", (Object[])new Object[]{timeSeed});
            }
        }
        AppEnv.setProperty((String)"org.eclipse.escet.cif.simulator.input.auto.transSeed", (String)(transSeed == null ? "n/a" : transSeed.toString()));
        AppEnv.setProperty((String)"org.eclipse.escet.cif.simulator.input.auto.timeSeed", (String)(timeSeed == null ? "n/a" : timeSeed.toString()));
    }

    @Override
    public Transition<S> chooseTransition(S state, List<Transition<S>> transitions, SimulationResult result) {
        if (transitions.isEmpty()) {
            throw new SimulatorExitException(result);
        }
        switch (this.transChoice) {
            case -2: {
                return (Transition)Lists.first(transitions);
            }
            case -3: {
                return (Transition)Lists.last(transitions);
            }
        }
        int idx = this.transRandom.nextInt(transitions.size());
        return transitions.get(idx);
    }

    @Override
    public Double getNextMaxEndTime(S state) {
        if (!this.timeChoice.random()) {
            return null;
        }
        double curTime = ((RuntimeState)state).getTime();
        while (this.nextInterruptTime <= curTime) {
            double sample = this.timeRandom.nextDouble() * this.timeChoice.upper();
            this.nextInterruptTime += sample;
            if (this.nextInterruptTime > curTime) break;
        }
        return this.nextInterruptTime;
    }

    @Override
    public ChosenTargetTime chooseTargetTime(S state, double maxTargetTime) {
        if (!this.timeChoice.random()) {
            return new ChosenTargetTime(((RuntimeState)state).getTime(), maxTargetTime, true);
        }
        double sourceTime = ((RuntimeState)state).getTime();
        if (this.nextInterruptTime >= maxTargetTime) {
            return new ChosenTargetTime(((RuntimeState)state).getTime(), maxTargetTime, true);
        }
        return new ChosenTargetTime(sourceTime, this.nextInterruptTime, true);
    }
}

