/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifAddressableUtils;
import org.eclipse.escet.cif.metamodel.cif.InputParameter;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;

public class CifUpdateUtils {
    private CifUpdateUtils() {
    }

    public static boolean hasProjectedAddressable(List<Update> updates) {
        return updates.stream().anyMatch(u -> CifUpdateUtils.hasProjectedAddressable(u));
    }

    public static boolean hasProjectedAddressable(Update update) {
        Update update2 = update;
        Objects.requireNonNull(update2);
        Update update3 = update2;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IfUpdate.class, Assignment.class}, (Object)update3, 0)) {
            case 0 -> {
                IfUpdate ifUpd = (IfUpdate)update3;
                if (!(CifUpdateUtils.hasProjectedAddressable((List<Update>)ifUpd.getThens()) || ifUpd.getElifs().stream().anyMatch(elif -> CifUpdateUtils.hasProjectedAddressable((List<Update>)elif.getThens())) || CifUpdateUtils.hasProjectedAddressable((List<Update>)ifUpd.getElses()))) {
                    yield false;
                }
                yield true;
            }
            case 1 -> {
                Assignment asgn = (Assignment)update3;
                yield CifAddressableUtils.hasProjs(asgn.getAddressable());
            }
            default -> throw new AssertionError((Object)("Unknown update: " + String.valueOf(update)));
        };
    }

    public static boolean hasTupleAddressable(List<Update> updates) {
        return updates.stream().anyMatch(u -> CifUpdateUtils.hasTupleAddressable(u));
    }

    public static boolean hasTupleAddressable(Update update) {
        Update update2 = update;
        Objects.requireNonNull(update2);
        Update update3 = update2;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IfUpdate.class, Assignment.class}, (Object)update3, 0)) {
            case 0 -> {
                IfUpdate ifUpd = (IfUpdate)update3;
                if (!(CifUpdateUtils.hasTupleAddressable((List<Update>)ifUpd.getThens()) || ifUpd.getElifs().stream().anyMatch(elif -> CifUpdateUtils.hasTupleAddressable((List<Update>)elif.getThens())) || CifUpdateUtils.hasTupleAddressable((List<Update>)ifUpd.getElses()))) {
                    yield false;
                }
                yield true;
            }
            case 1 -> {
                Assignment asgn = (Assignment)update3;
                yield asgn.getAddressable() instanceof TupleExpression;
            }
            default -> throw new AssertionError((Object)("Unknown update: " + String.valueOf(update)));
        };
    }

    public static List<Assignment> updatesToAssignmentsPerVar(List<Update> updates) throws UnsupportedUpdateException {
        Set vars = Sets.set();
        for (Update update : updates) {
            vars.addAll(CifUpdateUtils.getVariables(update));
        }
        List assignments = Lists.listc((int)vars.size());
        for (Declaration var : vars) {
            Assignment assignment = CifConstructors.newAssignment();
            assignments.add(assignment);
            assignment.setAddressable(CifUpdateUtils.varToAddr(var));
            Expression value = CifUpdateUtils.updatesToValue(updates, var);
            assignment.setValue(value);
        }
        return assignments;
    }

    public static Map<Declaration, Expression> updatesToNewValueExprPerVar(List<Update> updates) throws UnsupportedUpdateException {
        Set vars = Sets.set();
        for (Update update : updates) {
            vars.addAll(CifUpdateUtils.getVariables(update));
        }
        Map newValues = Maps.mapc((int)vars.size());
        for (Declaration var : vars) {
            Expression newValue = CifUpdateUtils.updatesToValue(updates, var);
            newValues.put(var, newValue);
        }
        return newValues;
    }

    public static Map<Declaration, Expression> updateToNewValueExprPerVar(Update update) throws UnsupportedUpdateException {
        Set<Declaration> vars = CifUpdateUtils.getVariables(update);
        Map newValues = Maps.mapc((int)vars.size());
        for (Declaration var : vars) {
            Expression newValue = CifUpdateUtils.updateToValue(update, var);
            newValues.put(var, newValue);
        }
        return newValues;
    }

    private static Set<Declaration> getVariables(Update update) throws UnsupportedUpdateException {
        if (update instanceof IfUpdate) {
            IfUpdate iupdate = (IfUpdate)update;
            Set rslt = Sets.set();
            for (Update upd : iupdate.getThens()) {
                rslt.addAll(CifUpdateUtils.getVariables(upd));
            }
            for (ElifUpdate elif : iupdate.getElifs()) {
                for (Update upd : elif.getThens()) {
                    rslt.addAll(CifUpdateUtils.getVariables(upd));
                }
            }
            for (Update upd : iupdate.getElses()) {
                rslt.addAll(CifUpdateUtils.getVariables(upd));
            }
            return rslt;
        }
        Expression addr = ((Assignment)update).getAddressable();
        CifUpdateUtils.checkAddressable(addr);
        try {
            return CifAddressableUtils.getRefs(addr);
        }
        catch (CifAddressableUtils.DuplVarAsgnException e) {
            throw new RuntimeException("Precondition violated.");
        }
    }

    private static Expression varToAddr(Declaration var) {
        if (var instanceof DiscVariable) {
            DiscVariable dvar = (DiscVariable)var;
            DiscVariableExpression daddr = CifConstructors.newDiscVariableExpression();
            daddr.setVariable(dvar);
            daddr.setType((CifType)EMFHelper.deepclone((EObject)dvar.getType()));
            return daddr;
        }
        if (var instanceof ContVariable) {
            ContVariable cvar = (ContVariable)var;
            ContVariableExpression caddr = CifConstructors.newContVariableExpression();
            caddr.setVariable(cvar);
            caddr.setType((CifType)CifConstructors.newRealType());
            return caddr;
        }
        if (var instanceof InputVariable) {
            InputVariable ivar = (InputVariable)var;
            InputVariableExpression iaddr = CifConstructors.newInputVariableExpression();
            iaddr.setVariable(ivar);
            iaddr.setType((CifType)EMFHelper.deepclone((EObject)ivar.getType()));
            return iaddr;
        }
        throw new RuntimeException("Unknown variable: " + String.valueOf(var));
    }

    private static Expression updatesToValue(List<Update> updates, Declaration var) throws UnsupportedUpdateException {
        for (Update update : updates) {
            if (!CifUpdateUtils.getVariables(update).contains(var)) continue;
            return CifUpdateUtils.updateToValue(update, var);
        }
        return CifUpdateUtils.varToAddr(var);
    }

    private static Expression updateToValue(Update update, Declaration var) throws UnsupportedUpdateException {
        if (update instanceof Assignment) {
            Set<Declaration> addrVars;
            Assignment asgn = (Assignment)update;
            Expression addr = asgn.getAddressable();
            try {
                addrVars = CifAddressableUtils.getRefs(addr);
            }
            catch (CifAddressableUtils.DuplVarAsgnException e) {
                throw new RuntimeException("Precondition violated.");
            }
            Assert.check((addrVars.size() == 1 ? 1 : 0) != 0);
            Declaration addrVar = addrVars.iterator().next();
            if (addrVar == var) {
                return (Expression)EMFHelper.deepclone((EObject)asgn.getValue());
            }
            return CifUpdateUtils.varToAddr(var);
        }
        IfUpdate iupdate = (IfUpdate)update;
        IfExpression ifExpr = CifConstructors.newIfExpression();
        ifExpr.setType((CifType)EMFHelper.deepclone((EObject)CifUpdateUtils.varToAddr(var).getType()));
        ifExpr.getGuards().addAll((Collection)EMFHelper.deepclone((List)iupdate.getGuards()));
        ifExpr.setThen(CifUpdateUtils.updatesToValue((List<Update>)iupdate.getThens(), var));
        for (ElifUpdate elif : iupdate.getElifs()) {
            ElifExpression elifExpr = CifConstructors.newElifExpression();
            elifExpr.getGuards().addAll((Collection)EMFHelper.deepclone((List)elif.getGuards()));
            elifExpr.setThen(CifUpdateUtils.updatesToValue((List<Update>)elif.getThens(), var));
            ifExpr.getElifs().add((Object)elifExpr);
        }
        ifExpr.setElse(CifUpdateUtils.updatesToValue((List<Update>)iupdate.getElses(), var));
        return ifExpr;
    }

    private static void checkAddressable(Expression addr) throws UnsupportedUpdateException {
        InputVariableExpression iVarExpr;
        if (addr instanceof TupleExpression || addr instanceof ProjectionExpression || addr instanceof CompInstWrapExpression || addr instanceof CompParamWrapExpression) {
            throw new UnsupportedUpdateException();
        }
        if (addr instanceof InputVariableExpression && (iVarExpr = (InputVariableExpression)addr).getVariable().eContainer() instanceof InputParameter) {
            throw new UnsupportedUpdateException();
        }
    }

    public static class UnsupportedUpdateException
    extends Exception {
    }
}

