/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.random;

import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.data.random.IntegerDistribution;
import org.eclipse.escet.chi.runtime.data.random.RandomGenerator;
import org.eclipse.escet.common.java.Strings;

public class PoissonDistribution
extends IntegerDistribution {
    private RandomGenerator randGen;
    private double lambda;

    public PoissonDistribution(ChiCoordinator chiCoordinator, double lambda) {
        super(chiCoordinator);
        if (lambda <= 0.0) {
            String msg = Strings.fmt((String)"The Poisson distribution expects the lambda parameter to be bigger than 0, found %s instead.", (Object[])new Object[]{lambda});
            throw new ChiSimulatorException(msg);
        }
        this.lambda = lambda;
        this.randGen = chiCoordinator.getFreshGenerator();
    }

    @Override
    public int sample() {
        return PoissonDistribution.drawPoisson(this.randGen, this.lambda);
    }

    public static int drawPoisson(RandomGenerator randGen, double lambda) {
        double e = Math.exp(-lambda);
        double p = 1.0;
        int r = -1;
        while (p > e) {
            p *= randGen.drawNonzero();
            ++r;
        }
        return r;
    }
}

