/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.TypeEqHashWrap;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGeneratorResult;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.cif.simulator.compiler.TypeCodeGenerator;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class DefaultValueCodeGenerator {
    private DefaultValueCodeGenerator() {
    }

    public static void gencodeDefaultValues(CifCompilerContext ctxt) {
        Map<TypeEqHashWrap, String> mapping = ctxt.getDefaultMethodNames();
        if (mapping.isEmpty()) {
            return;
        }
        JavaCodeFile file = ctxt.addCodeFile("DefaultValues");
        CodeBox h = file.header;
        h.add("/** Creation of default values of container types. */");
        h.add("public final class DefaultValues {");
        CodeBox c = file.body;
        List exprResults = Lists.list();
        for (Map.Entry<TypeEqHashWrap, String> entry : mapping.entrySet()) {
            if (!c.isEmpty()) {
                c.add();
            }
            CifType type = entry.getKey().type;
            c.add("// %s", new Object[]{CifTextUtils.typeToStr((CifType)type)});
            c.add("public static %s %s() {", new Object[]{TypeCodeGenerator.gencodeType(type, ctxt), entry.getValue()});
            c.indent();
            if (type instanceof DictType) {
                c.add("return new LinkedHashMap<>(0);");
            } else if (type instanceof ListType) {
                ListType ltype = (ListType)type;
                CifType etype = ltype.getElementType();
                int cnt = CifTypeUtils.getLowerBound((ListType)ltype);
                c.add("%s rslt = listc(%d);", new Object[]{TypeCodeGenerator.gencodeType(type, ctxt), cnt});
                if (cnt > 0) {
                    ExprCodeGeneratorResult result = DefaultValueCodeGenerator.getDefaultValueCode(etype, ctxt);
                    c.add("%s elem = %s;", new Object[]{TypeCodeGenerator.gencodeType(etype, ctxt), result});
                    exprResults.add(result);
                    c.add("for (int i = 0; i < %d; i++) {", new Object[]{cnt});
                    c.indent();
                    c.add("rslt.add(elem);");
                    c.dedent();
                    c.add("}");
                }
                c.add("return rslt;");
            } else if (type instanceof SetType) {
                c.add("return new LinkedHashSet<>(0);");
            } else if (type instanceof TupleType) {
                TupleType ttype = (TupleType)type;
                List argTxts = Lists.listc((int)ttype.getFields().size());
                for (Field field : ttype.getFields()) {
                    ExprCodeGeneratorResult result = DefaultValueCodeGenerator.getDefaultValueCode(field.getType(), ctxt);
                    argTxts.add(result.toString());
                    exprResults.add(result);
                }
                c.add("return new %s(%s);", new Object[]{ctxt.getTupleTypeClassName(ttype), String.join((CharSequence)", ", argTxts)});
            } else {
                throw new RuntimeException("Unknown container type: " + String.valueOf(type));
            }
            c.dedent();
            c.add("}");
        }
        for (ExprCodeGeneratorResult exprResult : exprResults) {
            exprResult.addExtraMethods(c);
        }
    }

    public static ExprCodeGeneratorResult getDefaultValueCode(CifType type, CifCompilerContext ctxt) {
        if (!CifTypeUtils.isContainerType((CifType)(type = CifTypeUtils.normalizeType((CifType)type)))) {
            Expression defaultValue = ctxt.getDefaultValue(type);
            return ExprCodeGenerator.gencodeExpr(defaultValue, ctxt, null);
        }
        String name = ctxt.getDefaultValueMethodName(type);
        Assert.notNull((Object)name);
        return new ExprCodeGeneratorResult(Strings.fmt((String)"DefaultValues.%s()", (Object[])new Object[]{name}), type);
    }
}

