/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.Collection;
import java.util.List;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifSortUtils;
import org.eclipse.escet.cif.common.ConstantOrderer;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGeneratorResult;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.cif.simulator.compiler.TypeCodeGenerator;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class ConstCodeGenerator {
    private ConstCodeGenerator() {
    }

    public static void gencodeConsts(Specification spec, CifCompilerContext ctxt) {
        List constants = (List)CifCollectUtils.collectConstants((ComplexComponent)spec, (Collection)Lists.list());
        CifSortUtils.sortCifObjects((List)constants);
        JavaCodeFile file = ctxt.addCodeFile("Constants");
        CodeBox h = file.header;
        h.add("/** Constants. */");
        h.add("public final class Constants {");
        CodeBox c = file.body;
        constants = new ConstantOrderer().computeOrder((Collection)constants);
        Assert.notNull((Object)constants);
        for (Constant constant : constants) {
            ExprCodeGeneratorResult result = ExprCodeGenerator.gencodeExpr(constant.getValue(), ctxt, null);
            c.add("public static final %s %s = %s;", new Object[]{TypeCodeGenerator.gencodeType(constant.getType(), ctxt), ctxt.getConstFieldName(constant), result});
            result.addExtraMethods(c);
        }
    }
}

