/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.osgi.util.NLS;

public class Util {
    public static IStatus createError(String message) {
        return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", message);
    }

    public static IStatus createError(String message, Throwable exception) {
        return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", message, exception);
    }

    public static void logError(String message, Throwable exception) {
        LogHelper.log((IStatus)Util.createError(message, exception));
    }

    public static void logError(String message) {
        LogHelper.log((IStatus)Util.createError(message));
    }

    public static IStatus createWarning(String message) {
        return new Status(2, "org.eclipse.equinox.p2.touchpoint.natives", message);
    }

    public static IStatus createWarning(String message, Throwable exception) {
        return new Status(2, "org.eclipse.equinox.p2.touchpoint.natives", message, exception);
    }

    public static void logWarning(String message, Throwable exception) {
        LogHelper.log((IStatus)Util.createWarning(message, exception));
    }

    public static void logWarning(String message) {
        LogHelper.log((IStatus)Util.createWarning(message));
    }

    public static String getInstallFolder(IProfile profile) {
        return profile.getProperty("org.eclipse.equinox.p2.installFolder");
    }

    private static IAgentLocation getAgentLocation(IProvisioningAgent agent) {
        return (IAgentLocation)agent.getService(IAgentLocation.class);
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager(IProvisioningAgent agent) {
        return (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.class);
    }

    public static IFileArtifactRepository getDownloadCacheRepo(IProvisioningAgent agent) throws ProvisionException {
        IArtifactRepository repository;
        URI location = Util.getDownloadCacheLocation(agent);
        if (location == null) {
            throw new IllegalStateException(Messages.could_not_obtain_download_cache);
        }
        IArtifactRepositoryManager manager = Util.getArtifactRepositoryManager(agent);
        if (manager == null) {
            throw new IllegalStateException(Messages.artifact_repo_not_found);
        }
        try {
            repository = manager.loadRepository(location, null);
        }
        catch (ProvisionException e) {
            String repositoryName = String.valueOf(location) + " - Agent download cache";
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("p2.system", Boolean.TRUE.toString());
            repository = manager.createRepository(location, repositoryName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
        }
        IFileArtifactRepository downloadCache = (IFileArtifactRepository)repository.getAdapter(IFileArtifactRepository.class);
        if (downloadCache == null) {
            throw new ProvisionException(NLS.bind((String)Messages.download_cache_not_writeable, (Object)location));
        }
        return downloadCache;
    }

    private static URI getDownloadCacheLocation(IProvisioningAgent agent) {
        IAgentLocation location = Util.getAgentLocation(agent);
        if (location == null) {
            return null;
        }
        return URIUtil.append((URI)location.getDataArea("org.eclipse.equinox.p2.core"), (String)"cache/");
    }

    public static File[] unzipFile(File zipFile, File outputDir, IBackupStore store, String taskName, IProgressMonitor monitor) throws IOException {
        return Util.unzipFile(zipFile, outputDir, null, null, null, store, taskName, monitor);
    }

    public static File[] unzipFile(File zipFile, File outputDir, String path, String[] includePatterns, String[] excludePatterns, IBackupStore store, String taskName, IProgressMonitor monitor) throws IOException {
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (FileInputStream in = new FileInputStream(zipFile);){
                return Util.unzipStream(in, zipFile.length(), outputDir, path, includePatterns, excludePatterns, store, taskName, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            IOException ioExc = new IOException(NLS.bind((String)Messages.Util_Error_Unzipping, (Object)zipFile, (Object)e.getMessage()), e);
            throw ioExc;
        }
    }

    public static File[] unzipStream(InputStream stream, long size, File outputDir, IBackupStore store, String taskName, IProgressMonitor monitor) throws IOException {
        return Util.unzipStream(stream, size, outputDir, null, null, null, store, taskName, monitor);
    }

    public static File[] unzipStream(InputStream stream, long size, File outputDir, String path, String[] includePatterns, String[] excludePatterns, IBackupStore store, String taskName, IProgressMonitor monitor) throws IOException {
        InputStream is = monitor == null ? stream : stream;
        Throwable throwable = null;
        Object var12_12 = null;
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(is));){
            String pattern;
            int n;
            int n2;
            String[] stringArray;
            ZipEntry ze = in.getNextEntry();
            if (ze == null) {
                in.close();
                throw new IOException(Messages.Util_Invalid_Zip_File_Format);
            }
            if (path != null && path.trim().length() == 0) {
                path = null;
            }
            Pattern pathRegex = path == null ? null : Util.createAntStylePattern("(" + path + ")(*)");
            ArrayList<Pattern> includeRegexp = new ArrayList<Pattern>();
            ArrayList<Pattern> excludeRegexp = new ArrayList<Pattern>();
            if (includePatterns != null) {
                stringArray = includePatterns;
                n2 = includePatterns.length;
                n = 0;
                while (n < n2) {
                    pattern = stringArray[n];
                    if (pattern != null) {
                        includeRegexp.add(Util.createAntStylePattern(pattern));
                    }
                    ++n;
                }
            }
            if (excludePatterns != null) {
                stringArray = excludePatterns;
                n2 = excludePatterns.length;
                n = 0;
                while (n < n2) {
                    pattern = stringArray[n];
                    if (pattern != null) {
                        excludeRegexp.add(Util.createAntStylePattern(pattern));
                    }
                    ++n;
                }
            }
            ArrayList<File> unzippedFiles = new ArrayList<File>();
            do {
                String name = ze.getName();
                if (pathRegex == null || pathRegex.matcher(name).matches()) {
                    boolean unzip = includeRegexp.isEmpty();
                    for (Pattern pattern2 : includeRegexp) {
                        unzip = pattern2.matcher(name).matches();
                        if (unzip) break;
                    }
                    if (unzip && !excludeRegexp.isEmpty()) {
                        for (Pattern pattern2 : excludeRegexp) {
                            if (!pattern2.matcher(name).matches()) continue;
                            unzip = false;
                            break;
                        }
                    }
                    if (unzip) {
                        Matcher matcher;
                        if (pathRegex != null && (matcher = pathRegex.matcher(name)).matches() && (name = matcher.group(2)).startsWith("/")) {
                            name = name.substring(1);
                        }
                        File outFile = Util.createSubPathFile(outputDir, name);
                        unzippedFiles.add(outFile);
                        if (ze.isDirectory()) {
                            outFile.mkdirs();
                        } else {
                            if (outFile.exists()) {
                                if (store != null) {
                                    store.backup(outFile);
                                } else {
                                    outFile.delete();
                                }
                            } else {
                                outFile.getParentFile().mkdirs();
                            }
                            try {
                                Util.copyStream(in, false, new FileOutputStream(outFile), true);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                // empty catch block
                            }
                            outFile.setLastModified(ze.getTime());
                        }
                    }
                }
                in.closeEntry();
            } while ((ze = in.getNextEntry()) != null);
            return unzippedFiles.toArray(new File[unzippedFiles.size()]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static File createSubPathFile(File root, String subPath) throws IOException {
        String rootCanonical;
        File result = new File(root, subPath).getCanonicalFile();
        String resultCanonical = result.getPath();
        if (!resultCanonical.startsWith((rootCanonical = root.getCanonicalPath()) + File.separator) && !resultCanonical.equals(rootCanonical)) {
            throw new IOException("Invalid path: " + subPath);
        }
        return result;
    }

    public static int copyStream(InputStream in, boolean closeIn, OutputStream out, boolean closeOut) throws IOException {
        try {
            int len;
            int written = 0;
            byte[] buffer = new byte[16384];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                written += len;
            }
            int n = written;
            return n;
        }
        finally {
            try {
                if (closeIn) {
                    in.close();
                }
            }
            finally {
                if (closeOut) {
                    out.close();
                }
            }
        }
    }

    private static Pattern createAntStylePattern(String pattern) {
        StringBuffer sb = new StringBuffer();
        int c = 0;
        while (c < pattern.length()) {
            switch (pattern.charAt(c)) {
                case '.': {
                    sb.append("\\.");
                    break;
                }
                case '*': {
                    sb.append(".*");
                    break;
                }
                case '?': {
                    sb.append(".?");
                    break;
                }
                default: {
                    sb.append(pattern.charAt(c));
                }
            }
            ++c;
        }
        String string = sb.toString();
        if (string.endsWith("\\..*")) {
            sb.append("|");
            sb.append(string.substring(0, string.length() - 4));
        }
        return Pattern.compile(sb.toString());
    }
}

