/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository.simple;

import java.util.LinkedList;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;

public class DownloadJob
extends Job {
    private static final int SUB_TICKS = 1000;
    static final Object FAMILY = new Object();
    private final LinkedList<IArtifactRequest> requestsPending;
    private final SimpleArtifactRepository repository;
    private final Consumer<IStatus> resultConsumer;
    private final Consumer<String> messageConsumer;

    DownloadJob(String name, SimpleArtifactRepository repository, LinkedList<IArtifactRequest> requestsPending, Consumer<IStatus> resultConsumer, Consumer<String> messageConsumer) {
        super(name);
        this.resultConsumer = resultConsumer;
        this.messageConsumer = messageConsumer;
        this.setSystem(true);
        this.repository = repository;
        this.requestsPending = requestsPending;
    }

    public boolean belongsTo(Object family) {
        return family == FAMILY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor jobMonitor) {
        final SubMonitor monitor = SubMonitor.convert((IProgressMonitor)jobMonitor, (String)Messages.DownloadJob_initial, (int)1000000);
        do {
            IArtifactRequest request;
            LinkedList<IArtifactRequest> linkedList = this.requestsPending;
            synchronized (linkedList) {
                int totalDownloadWork = this.requestsPending.size();
                if (totalDownloadWork == 0) {
                    return Status.OK_STATUS;
                }
                monitor.setWorkRemaining(totalDownloadWork * 1000);
                request = this.requestsPending.removeFirst();
            }
            IArtifactKey key = request.getArtifactKey();
            String currentArtifact = String.format("%s %s", key.getId(), key.getVersion());
            monitor.setTaskName(currentArtifact);
            final SubMonitor split = monitor.split(1000, 0);
            IStatus status = this.repository.getArtifact(request, new IProgressMonitor(){
                private volatile boolean canceled;
                private String taskName;
                private String subTaskName;
                private String lastMessage;

                public void worked(int work) {
                    split.worked(work);
                }

                public void subTask(String name) {
                    this.subTaskName = name;
                    if (DownloadJob.this.messageConsumer != null) {
                        DownloadJob.this.messageConsumer.accept(name);
                    }
                    this.updateTaskName();
                }

                public void setTaskName(String name) {
                    this.taskName = name;
                    this.updateTaskName();
                }

                public void setCanceled(boolean canceled) {
                    this.canceled = canceled;
                }

                public boolean isCanceled() {
                    return this.canceled;
                }

                public void internalWorked(double work) {
                    split.internalWorked(work);
                }

                public void done() {
                    split.done();
                }

                public void beginTask(String name, int totalWork) {
                    monitor.beginTask(name, totalWork);
                    this.taskName = name;
                    this.updateTaskName();
                }

                private void updateTaskName() {
                    String message;
                    StringBuilder sb = new StringBuilder();
                    if (this.taskName != null && !this.taskName.isBlank()) {
                        sb.append(this.taskName);
                    }
                    if (this.subTaskName != null && !this.subTaskName.isBlank()) {
                        if (sb.length() > 0) {
                            sb.append(" - ");
                        }
                        sb.append(this.subTaskName);
                    }
                    if ((message = sb.toString()).length() > 0 && !message.equals(this.lastMessage)) {
                        this.lastMessage = message;
                        monitor.subTask(message);
                    }
                }
            });
            this.resultConsumer.accept(status);
        } while (!monitor.isCanceled());
        return Status.CANCEL_STATUS;
    }
}

