/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.osgi.internal.framework.BundleContextImpl;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistrationImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.internal.serviceregistry.ServiceUse;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;

public class ServiceFactoryUse<S>
extends ServiceUse<S> {
    final ServiceFactory<S> factory;
    private S cachedService = null;
    private boolean factoryInUse = false;

    ServiceFactoryUse(BundleContextImpl context, ServiceRegistrationImpl<S> registration) {
        super(context, registration);
        ServiceFactory f;
        this.factory = f = (ServiceFactory)registration.getServiceObject();
    }

    @Override
    S getService() {
        S service;
        assert (this.isLocked());
        if (this.inUse()) {
            this.incrementUse();
            return this.cachedService;
        }
        if (this.debug.DEBUG_SERVICES) {
            this.debug.trace("org.eclipse.osgi/debug/services", "[" + Thread.currentThread().getName() + "] getService[Sfactory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
        }
        if (this.factoryInUse) {
            if (this.debug.DEBUG_SERVICES) {
                this.debug.trace("org.eclipse.osgi/debug/services", this.factory + ".getService() recursively called.");
            }
            ServiceException se = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_RECURSION, this.factory.getClass().getName(), "getService"), 6);
            this.context.getContainer().getEventPublisher().publishFrameworkEvent(16, this.registration.getBundle(), se);
            return null;
        }
        this.factoryInUse = true;
        try {
            service = this.factoryGetService();
            if (service == null) {
                return null;
            }
        }
        finally {
            this.factoryInUse = false;
        }
        this.cachedService = service;
        this.incrementUse();
        return service;
    }

    @Override
    boolean ungetService() {
        assert (this.isLocked());
        if (!this.inUse()) {
            return false;
        }
        this.decrementUse();
        if (this.inUse()) {
            return true;
        }
        S service = this.cachedService;
        this.cachedService = null;
        if (this.debug.DEBUG_SERVICES) {
            this.debug.trace("org.eclipse.osgi/debug/services", "[" + Thread.currentThread().getName() + "] ungetService[Sfactory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
        }
        this.factoryUngetService(service);
        return true;
    }

    @Override
    void release() {
        super.release();
        S service = this.cachedService;
        if (service == null) {
            return;
        }
        this.cachedService = null;
        if (this.debug.DEBUG_SERVICES) {
            this.debug.trace("org.eclipse.osgi/debug/services", "[" + Thread.currentThread().getName() + "] releaseService[Sfactory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
        }
        this.factoryUngetService(service);
    }

    @Override
    S getCachedService() {
        return this.cachedService;
    }

    S factoryGetService() {
        Object service;
        try {
            service = AccessController.doPrivileged(new PrivilegedAction<S>(){

                @Override
                public S run() {
                    return ServiceFactoryUse.this.factory.getService(ServiceFactoryUse.this.context.getBundleImpl(), ServiceFactoryUse.this.registration);
                }
            });
        }
        catch (Throwable t) {
            if (this.debug.DEBUG_SERVICES) {
                this.debug.trace("org.eclipse.osgi/debug/services", this.factory + ".getService() exception: " + t.getMessage());
                this.debug.traceThrowable("org.eclipse.osgi/debug/services", t);
            }
            ServiceException se = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, this.factory.getClass().getName(), "getService"), 3, t);
            this.context.getContainer().getEventPublisher().publishFrameworkEvent(2, this.registration.getBundle(), se);
            return null;
        }
        if (service == null) {
            if (this.debug.DEBUG_SERVICES) {
                this.debug.trace("org.eclipse.osgi/debug/services", this.factory + ".getService() returned null.");
            }
            ServiceException se = new ServiceException(NLS.bind(Msg.SERVICE_OBJECT_NULL_EXCEPTION, this.factory.getClass().getName()), 2);
            this.context.getContainer().getEventPublisher().publishFrameworkEvent(16, this.registration.getBundle(), se);
            return null;
        }
        String[] clazzes = this.registration.getClasses();
        String invalidService = ServiceRegistry.checkServiceClass(clazzes, service);
        if (invalidService != null) {
            if (this.debug.DEBUG_SERVICES) {
                this.debug.trace("org.eclipse.osgi/debug/services", "Service object is not an instanceof " + invalidService);
            }
            ServiceException se = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_NOT_INSTANCEOF_CLASS_EXCEPTION, this.factory.getClass().getName(), service.getClass().getName(), invalidService), 2);
            this.context.getContainer().getEventPublisher().publishFrameworkEvent(2, this.registration.getBundle(), se);
            return null;
        }
        return (S)service;
    }

    void factoryUngetService(final S service) {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ServiceFactoryUse.this.factory.ungetService(ServiceFactoryUse.this.context.getBundleImpl(), ServiceFactoryUse.this.registration, service);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            if (this.debug.DEBUG_SERVICES) {
                this.debug.trace("org.eclipse.osgi/debug/services", this.factory + ".ungetService() exception");
                this.debug.traceThrowable("org.eclipse.osgi/debug/services", t);
            }
            ServiceException se = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, this.factory.getClass().getName(), "ungetService"), 3, t);
            this.context.getContainer().getEventPublisher().publishFrameworkEvent(2, this.registration.getBundle(), se);
        }
    }
}

