/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIContainer;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.DirectoryClassLoader;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.Parser;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.remote.reader.ProprietaryReaderFactory;
import com.sun.enterprise.admin.remote.writer.ProprietaryWriterFactory;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.JDK;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.InvalidCommandException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.common.util.admin.AsadminInput;

public class AdminMain {
    private String classPath;
    private String className;
    private String command;
    private ProgramOptions po;
    private CLIContainer cliContainer;
    private Environment env = new Environment();
    protected Logger logger;
    private static final int ERROR = 1;
    private static final int CONNECTION_ERROR = 2;
    private static final int INVALID_COMMAND_ERROR = 3;
    private static final int SUCCESS = 0;
    private static final int WARNING = 4;
    private static final String ADMIN_CLI_LOGGER = "com.sun.enterprise.admin.cli";
    private static final String[] copyProps = new String[]{"com.sun.aas.installRoot", "com.sun.aas.configRoot", "com.sun.aas.productRoot"};
    private static final LocalStringsImpl strings = new LocalStringsImpl(AdminMain.class);

    private ClassLoader getExtensionClassLoader(final Set<File> extensions) {
        final ClassLoader ecl = AdminMain.class.getClassLoader();
        if (extensions != null && !extensions.isEmpty()) {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return new DirectoryClassLoader(extensions, ecl);
                    }
                    catch (IOException ex) {
                        AdminMain.this.logger.info(strings.get("ExtDirFailed", new Object[]{ex}));
                        return ecl;
                    }
                }
            });
        }
        return ecl;
    }

    protected Set<File> getExtensions() {
        HashSet<File> result = new HashSet<File>();
        File inst = new File(System.getProperty("com.sun.aas.installRoot"));
        File ext = new File(new File(inst, "lib"), "asadmin");
        if (ext.exists() && ext.isDirectory()) {
            result.add(ext);
        } else if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer(strings.get("ExtDirMissing", new Object[]{ext}));
        }
        result.add(new File(new File(inst, "modules"), "admin-cli.jar"));
        return result;
    }

    protected String getCommandName() {
        return "nadmin";
    }

    public static void main(String[] args) {
        AdminMain adminMain = new AdminMain();
        int code = adminMain.doMain(args);
        System.exit(code);
    }

    protected int doMain(String[] args) {
        int minor = JDK.getMinor();
        int major = JDK.getMajor();
        if (major < 9 && minor < 6) {
            System.err.println(strings.get("OldJdk", new Object[]{"" + minor}));
            return 1;
        }
        boolean trace = this.env.trace();
        boolean debug = this.env.debug();
        this.logger = Logger.getLogger(ADMIN_CLI_LOGGER);
        if (trace) {
            this.logger.setLevel(Level.FINEST);
        } else if (debug) {
            this.logger.setLevel(Level.FINER);
        } else {
            this.logger.setLevel(Level.FINE);
        }
        this.logger.setUseParentHandlers(false);
        CLILoggerHandler h = new CLILoggerHandler();
        h.setLevel(this.logger.getLevel());
        this.logger.addHandler(h);
        Logger rlogger = Logger.getLogger("");
        rlogger.setUseParentHandlers(false);
        for (Handler lh : rlogger.getHandlers()) {
            rlogger.removeHandler(lh);
        }
        rlogger.addHandler(h);
        if (debug) {
            System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "CLASSPATH= {0}\nCommands: {1}", new Object[]{System.getProperty("java.class.path"), Arrays.toString(args)});
            }
        }
        Set<File> extensions = this.getExtensions();
        ClassLoader ecl = this.getExtensionClassLoader(extensions);
        Thread.currentThread().setContextClassLoader(ecl);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ProprietaryReaderFactory.getReader(Class.class, (String)"not/defined");
                ProprietaryWriterFactory.getWriter(Class.class);
            }
        });
        thread.setDaemon(true);
        thread.start();
        this.cliContainer = new CLIContainer(ecl, extensions, this.logger);
        this.classPath = SmartFile.sanitizePaths((String)System.getProperty("java.class.path"));
        this.className = AdminMain.class.getName();
        if (args.length == 0) {
            args = new String[]{"multimode"};
        }
        if (args[0].equals("-V")) {
            args = new String[]{"version"};
        }
        this.command = args[0];
        int exitCode = this.executeCommand(args);
        switch (exitCode) {
            case 0: {
                if (this.po.isTerse()) break;
                this.logger.fine(strings.get(this.po.isDetachedCommand() ? "CommandSuccessfulStarted" : "CommandSuccessful", new Object[]{this.command}));
                break;
            }
            case 4: {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(strings.get("CommandSuccessfulWithWarnings", new Object[]{this.command}));
                }
                exitCode = 0;
                break;
            }
            default: {
                this.logger.fine(strings.get("CommandUnSuccessful", new Object[]{this.command}));
            }
        }
        CLIUtil.writeCommandToDebugLog(this.getCommandName(), this.env, args, exitCode);
        return exitCode;
    }

    public int executeCommand(String[] argv) {
        CLICommand cmd = null;
        try {
            if (argv.length > 0 && argv[0].startsWith("-")) {
                Parser rcp = new Parser(argv, 0, ProgramOptions.getValidOptions(), false);
                ParameterMap params = rcp.getOptions();
                this.po = new ProgramOptions(params, this.env);
                AdminMain.readAndMergeOptionsFromAuxInput(this.po);
                List<String> operands = rcp.getOperands();
                argv = operands.toArray(new String[operands.size()]);
            } else {
                this.po = new ProgramOptions(this.env);
            }
            this.po.toEnvironment(this.env);
            this.po.setClassPath(this.classPath);
            this.po.setClassName(this.className);
            this.po.setCommandName(this.getCommandName());
            if (argv.length == 0) {
                argv = this.po.isHelp() ? new String[]{"help"} : new String[]{"multimode"};
            }
            this.command = argv[0];
            this.cliContainer.setEnvironment(this.env);
            this.cliContainer.setProgramOptions(this.po);
            cmd = CLICommand.getCommand(this.cliContainer, this.command);
            int result = cmd.execute(argv);
            return result;
        }
        catch (CommandValidationException cve) {
            this.logger.severe(cve.getMessage());
            if (cmd == null) {
                this.printUsage();
            } else {
                this.logger.severe(cmd.getUsage());
            }
            return 1;
        }
        catch (InvalidCommandException ice) {
            this.logger.severe(ice.getMessage());
            try {
                this.po.setEcho(false);
                CLIUtil.displayClosestMatch(this.command, CLIUtil.getAllCommands(this.cliContainer, this.po, this.env), strings.get("ClosestMatchedLocalAndRemoteCommands"), this.logger);
            }
            catch (InvalidCommandException params) {
                // empty catch block
            }
            return 1;
        }
        catch (CommandException ce) {
            if (ce.getCause() instanceof ConnectException) {
                this.logger.severe(ce.getMessage());
                try {
                    CLIUtil.displayClosestMatch(this.command, CLIUtil.getLocalCommands(this.cliContainer), strings.get("ClosestMatchedLocalCommands"), this.logger);
                }
                catch (InvalidCommandException e) {
                    this.logger.info(strings.get("InvalidRemoteCommand", new Object[]{this.command}));
                }
            } else {
                this.logger.severe(ce.getMessage());
            }
            return 1;
        }
    }

    private static void readAndMergeOptionsFromAuxInput(ProgramOptions progOpts) throws CommandException {
        String auxInput = progOpts.getAuxInput();
        if (auxInput == null || auxInput.length() == 0) {
            return;
        }
        ParameterMap newParamMap = new ParameterMap();
        progOpts.setAuxInput(null);
        try {
            AsadminInput.InputReader reader = AsadminInput.reader((String)auxInput);
            Properties newOptions = (Properties)reader.settings().get("option");
            for (String propName : newOptions.stringPropertyNames()) {
                newParamMap.add((Object)propName, (Object)newOptions.getProperty(propName));
            }
            progOpts.updateOptions(newParamMap);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void printUsage() {
        this.logger.severe(strings.get("Usage.full", new Object[]{this.getCommandName()}));
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    public static File getJarForClass(Class cls) {
        URL resource = cls.getResource("/" + cls.getName().replace('.', '/') + ".class");
        String filename = resource.getFile();
        filename = filename.substring(5, filename.indexOf(33));
        return new File(filename);
    }

    static {
        Map systemProps = new ASenvPropertyReader().getProps();
        for (String prop : copyProps) {
            String val = (String)systemProps.get(prop);
            if (!AdminMain.ok(val)) continue;
            System.setProperty(prop, val);
        }
    }

    private static class CLILoggerFormatter
    extends SimpleFormatter {
        private CLILoggerFormatter() {
        }

        @Override
        public synchronized String format(LogRecord record) {
            return this.formatMessage(record);
        }
    }

    private static class CLILoggerHandler
    extends ConsoleHandler {
        private CLILoggerHandler() {
            this.setFormatter(new CLILoggerFormatter());
        }

        @Override
        public void publish(LogRecord logRecord) {
            if (!this.isLoggable(logRecord)) {
                return;
            }
            PrintStream ps = logRecord.getLevel() == Level.SEVERE ? System.err : System.out;
            ps.println(this.getFormatter().format(logRecord));
        }
    }
}

