/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.SecurityConfigListener;
import com.sun.enterprise.security.cli.CLIUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-auth-realm")
@PerLookup
@I18n(value="delete.auth.realm")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteAuthRealm
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteAuthRealm.class);
    @Param(name="authrealmname", primary=true)
    private String authRealmName;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    private Domain domain;
    @AccessRequired.To(value={"delete"})
    AuthRealm authRealm = null;
    private SecurityService securityService;

    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.chooseConfig(this.domain, this.target, context.getActionReport());
        if (this.config == null) {
            return false;
        }
        this.securityService = this.config.getSecurityService();
        this.authRealm = this.findRealm();
        if (this.authRealm == null) {
            ActionReport report = context.getActionReport();
            report.setMessage(localStrings.getLocalString("delete.auth.realm.notfound", "Authrealm named {0} not found", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        return this.authRealm != null;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SecurityService>(){

                public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                    param.getAuthRealm().remove(DeleteAuthRealm.this.authRealm);
                    SecurityConfigListener.authRealmDeleted(DeleteAuthRealm.this.authRealm);
                    return null;
                }
            }, (ConfigBeanProxy)this.securityService);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.auth.realm.fail", "Deletion of Authrealm {0} failed", new Object[]{this.authRealmName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private AuthRealm findRealm() {
        for (AuthRealm realm : this.securityService.getAuthRealm()) {
            if (!realm.getName().equals(this.authRealmName)) continue;
            return realm;
        }
        return null;
    }
}

