/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.servlet.api.javax_servlet.scattributeevent;

import com.sun.ts.tests.servlet.common.util.StaticLog;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public final class SCAttributeListener
implements ServletContextAttributeListener,
ServletContextListener {
    static ServletContext savedSC = null;

    public void contextInitialized(ServletContextEvent event) {
        savedSC = event.getServletContext();
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    public void attributeAdded(ServletContextAttributeEvent event) {
        StaticLog.add("AttributeAdded:" + event.getName() + "," + event.getValue());
        ServletContext sc = event.getServletContext();
        if (savedSC != sc) {
            StaticLog.add(this.getErrorMessageForInvalidContext(savedSC, sc));
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        StaticLog.add("AttributeRemoved:" + event.getName() + "," + event.getValue());
        ServletContext sc = event.getServletContext();
        if (savedSC != sc) {
            StaticLog.add(this.getErrorMessageForInvalidContext(savedSC, sc));
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        StaticLog.add("AttributeReplaced:" + event.getName() + "," + event.getValue());
        ServletContext sc = event.getServletContext();
        if (savedSC != sc) {
            StaticLog.add(this.getErrorMessageForInvalidContext(savedSC, sc));
        }
    }

    private String getErrorMessageForInvalidContext(ServletContext initCtx, ServletContext eventCtx) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("The ServletContext of the event is not the same ServletContext provided to the listener at initialization.\n");
        sb.append("Initialized context: " + initCtx + "\n");
        sb.append("Event.getServletContext returned context: " + eventCtx + "\n");
        return sb.toString();
    }
}

