/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.plugin.common;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.util.LocalStringManagerImpl;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.web.config.serverbeans.WebModuleConfig;

public abstract class WebModuleConfigCommand
implements AdminCommand {
    private static final String WEB_SNIFFER_TYPE = "web";
    private static final String LINE_SEP = System.getProperty("line.separator");
    @Param(primary=true)
    private String appNameAndOptionalModuleName;
    @Inject
    private Applications apps;
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebModuleConfigCommand.class);

    protected WebModuleConfig webModuleConfig(ActionReport report) {
        Module m = this.module(report);
        if (m == null) {
            return null;
        }
        WebModuleConfig config = (WebModuleConfig)this.engine(report).getApplicationConfig();
        return config;
    }

    private Application application() {
        Application result = (Application)this.apps.getModule(Application.class, this.appName());
        return result;
    }

    private Module module(ActionReport report) {
        Application app = this.application();
        if (app == null) {
            this.fail(report, "appNotReg", "Application {0} not registered", this.appName());
            return null;
        }
        if (app.isStandaloneModule() && this.appNameAndOptionalModuleName.contains("/")) {
            this.fail(report, "standaloneAppNoSubMods", "Application {0} is a stand-alone application and contains no submodules but submodule {1} was specified", this.appName(), this.moduleName());
            return null;
        }
        if (!app.isStandaloneModule() && !this.appNameAndOptionalModuleName.contains("/")) {
            this.fail(report, "earNoModuleSelection", "Application {0} is an enterprise application; please also specify one of the web module names ({1}) as part of the command argument (for example, {0}/{2})", this.appName(), this.webModuleList(app), ((Module)app.getModule().get(0)).getName());
            return null;
        }
        Module module = app.getModule(this.moduleName());
        if (module == null) {
            if (app.getModule().isEmpty()) {
                this.fail(report, "noWebModules", "Application {0} contains no web modules", this.appName());
            } else {
                this.fail(report, "noSuchModule", "Application {0} contains web modules {1} but {2} is not one of them", this.appName(), this.webModuleList(app), this.moduleName());
            }
        }
        return module;
    }

    private String webModuleList(Application app) {
        StringBuilder moduleNames = new StringBuilder();
        for (Module m : app.getModule()) {
            if (m.getEngine(WEB_SNIFFER_TYPE) == null) continue;
            moduleNames.append(moduleNames.length() > 0 ? ", " : "").append(m.getName());
        }
        return moduleNames.toString();
    }

    protected Engine engine(ActionReport report) {
        Module module = this.module(report);
        if (module == null) {
            return null;
        }
        Engine e = module.getEngine(WEB_SNIFFER_TYPE);
        if (e == null) {
            this.fail(report, "noSuchEngine", "Application {0}/module {1} does not contain engine {2}", this.appName(), this.moduleName(), WEB_SNIFFER_TYPE);
        }
        return e;
    }

    protected String moduleName() {
        int endOfAppName = this.endOfAppName();
        return endOfAppName == this.appNameAndOptionalModuleName.length() ? this.appNameAndOptionalModuleName : this.appNameAndOptionalModuleName.substring(endOfAppName + 1);
    }

    protected String appName() {
        return this.appNameAndOptionalModuleName.substring(0, this.endOfAppName());
    }

    private int endOfAppName() {
        int slash = this.appNameAndOptionalModuleName.indexOf(47);
        return slash == -1 ? this.appNameAndOptionalModuleName.length() : slash;
    }

    protected String appNameAndOptionalModuleName() {
        return this.appNameAndOptionalModuleName;
    }

    protected ActionReport fail(ActionReport report, Exception e, String msgKey, String defaultFormat, Object ... args) {
        report.setFailureCause((Throwable)e);
        StringBuilder causeMessages = new StringBuilder();
        for (Throwable t = e; t != null; t = t.getCause()) {
            causeMessages.append(causeMessages.length() > 1 ? LINE_SEP : "").append(t.getLocalizedMessage());
        }
        return this.fail(report, msgKey, defaultFormat + causeMessages.toString(), args);
    }

    protected ActionReport fail(ActionReport report, String msgKey, String defaultFormat, Object ... args) {
        return this.finish(report, ActionReport.ExitCode.FAILURE, msgKey, defaultFormat, args);
    }

    protected ActionReport succeed(ActionReport report, String msgKey, String defaultFormat, Object ... args) {
        return this.finish(report, ActionReport.ExitCode.SUCCESS, msgKey, defaultFormat, args);
    }

    protected String descriptionValueOrNotSpecified(String value) {
        if (value != null) {
            return value;
        }
        return localStrings.getLocalString("notSpecified", "(description not specified)");
    }

    private ActionReport finish(ActionReport report, ActionReport.ExitCode exitCode, String msgKey, String defaultFormat, Object ... args) {
        String msg = localStrings.getLocalString(msgKey, defaultFormat, args);
        report.setMessage(msg);
        report.setActionExitCode(exitCode);
        return report;
    }
}

