/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.renderkit.html_basic.OutputMessageRenderer;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessage;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class MessageRenderer
extends HtmlBasicRenderer {
    private OutputMessageRenderer omRenderer = new OutputMessageRenderer();

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (component instanceof UIOutput) {
            this.omRenderer.encodeBegin(context, component);
        }
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (component instanceof UIOutput) {
            this.omRenderer.encodeChildren(context, component);
        }
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Object val;
        this.rendererParamsNotNull(context, component);
        if (component instanceof UIOutput) {
            this.omRenderer.encodeEnd(context, component);
            return;
        }
        if (!this.shouldEncode(component)) {
            return;
        }
        boolean mustRender = this.shouldWriteIdAttribute(component);
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        UIMessage message = (UIMessage)component;
        String clientId = message.getFor();
        if (clientId == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("'for' attribute cannot be null");
            }
            return;
        }
        clientId = this.augmentIdReference(clientId, component);
        Iterator messageIter = this.getMessageIter(context, clientId, component);
        assert (messageIter != null);
        if (!messageIter.hasNext()) {
            if (mustRender) {
                writer.startElement("span", component);
                this.writeIdAttributeIfNecessary(context, writer, component);
                writer.endElement("span");
            }
            return;
        }
        FacesMessage curMessage = (FacesMessage)messageIter.next();
        if (curMessage.isRendered() && !message.isRedisplay()) {
            return;
        }
        curMessage.rendered();
        String severityStyle = null;
        String severityStyleClass = null;
        boolean showSummary = message.isShowSummary();
        boolean showDetail = message.isShowDetail();
        String summary = curMessage.getSummary();
        summary = null != summary ? summary : "";
        String detail = curMessage.getDetail();
        String string = detail = null != detail ? detail : summary;
        if (curMessage.getSeverity() == FacesMessage.SEVERITY_INFO) {
            severityStyle = (String)component.getAttributes().get("infoStyle");
            severityStyleClass = (String)component.getAttributes().get("infoClass");
        } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_WARN) {
            severityStyle = (String)component.getAttributes().get("warnStyle");
            severityStyleClass = (String)component.getAttributes().get("warnClass");
        } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_ERROR) {
            severityStyle = (String)component.getAttributes().get("errorStyle");
            severityStyleClass = (String)component.getAttributes().get("errorClass");
        } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_FATAL) {
            severityStyle = (String)component.getAttributes().get("fatalStyle");
            severityStyleClass = (String)component.getAttributes().get("fatalClass");
        }
        String style = (String)component.getAttributes().get("style");
        String styleClass = (String)component.getAttributes().get("styleClass");
        String dir = (String)component.getAttributes().get("dir");
        String lang = (String)component.getAttributes().get("lang");
        String title = (String)component.getAttributes().get("title");
        if (style != null && severityStyle != null) {
            style = severityStyle;
        } else if (style == null && severityStyle != null) {
            style = severityStyle;
        }
        if (styleClass != null && severityStyleClass != null) {
            styleClass = severityStyleClass;
        } else if (styleClass == null && severityStyleClass != null) {
            styleClass = severityStyleClass;
        }
        boolean wroteSpan = false;
        if (styleClass != null || style != null || dir != null || lang != null || title != null || mustRender) {
            writer.startElement("span", component);
            this.writeIdAttributeIfNecessary(context, writer, component);
            wroteSpan = true;
            if (style != null) {
                writer.writeAttribute("style", style, "style");
            }
            if (styleClass != null) {
                writer.writeAttribute("class", styleClass, "styleClass");
            }
            if (dir != null) {
                writer.writeAttribute("dir", dir, "dir");
            }
            if (lang != null) {
                writer.writeAttribute(RenderKitUtils.prefixAttribute("lang", writer), lang, "lang");
            }
            if (title != null) {
                writer.writeAttribute("title", title, "title");
            }
        }
        boolean isTooltip = (val = component.getAttributes().get("tooltip")) != null && Boolean.valueOf(val.toString()) != false;
        boolean wroteTooltip = false;
        if ((showSummary || showDetail) && isTooltip) {
            if (!wroteSpan) {
                writer.startElement("span", component);
            }
            if (title == null || title.length() == 0) {
                writer.writeAttribute("title", detail, "title");
            }
            writer.flush();
            writer.writeText("\t", component, null);
            wroteTooltip = true;
        } else if (wroteSpan) {
            writer.flush();
        }
        if (showSummary) {
            writer.writeText("\t", component, null);
            writer.writeText(summary, component, null);
            writer.writeText(" ", component, null);
        }
        if (showDetail) {
            writer.writeText(detail, component, null);
        }
        if (wroteSpan || wroteTooltip) {
            writer.endElement("span");
        }
    }
}

