/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.partitioning;

import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.PinnedPartitioningPolicy;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.AbstractPartitioningMetadata;

public class PinnedPartitioningMetadata
extends AbstractPartitioningMetadata {
    protected String connectionPool;

    public PinnedPartitioningMetadata() {
        super("<pinned-partitioning>");
    }

    public PinnedPartitioningMetadata(MetadataAnnotation annotation, MetadataAccessor accessor) {
        super(annotation, accessor);
        this.connectionPool = annotation.getAttributeString("connectionPool");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof PinnedPartitioningMetadata) {
            PinnedPartitioningMetadata policy = (PinnedPartitioningMetadata)objectToCompare;
            return this.valuesMatch(this.connectionPool, policy.getConnectionPool());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.connectionPool != null ? this.connectionPool.hashCode() : 0);
        return result;
    }

    public String getConnectionPool() {
        return this.connectionPool;
    }

    @Override
    public PartitioningPolicy buildPolicy() {
        PinnedPartitioningPolicy policy = new PinnedPartitioningPolicy();
        super.buildPolicy((PartitioningPolicy)policy);
        policy.setConnectionPool(this.getConnectionPool());
        return policy;
    }

    public void setConnectionPool(String connectionPool) {
        this.connectionPool = connectionPool;
    }
}

