/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.gms.mgmt;

import java.io.IOException;
import java.io.Serializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.shoal.gms.api.core.GMSConstants;
import org.glassfish.shoal.gms.api.core.GMSException;
import org.glassfish.shoal.gms.api.core.GroupManagementService;
import org.glassfish.shoal.gms.api.core.MemberNotInViewException;
import org.glassfish.shoal.gms.base.CustomTagNames;
import org.glassfish.shoal.gms.base.PeerID;
import org.glassfish.shoal.gms.base.SystemAdvertisement;
import org.glassfish.shoal.gms.base.SystemAdvertisementImpl;
import org.glassfish.shoal.gms.base.Utility;
import org.glassfish.shoal.gms.logging.GMSLogDomain;
import org.glassfish.shoal.gms.mgmt.ClusterMessageListener;
import org.glassfish.shoal.gms.mgmt.ClusterViewEventListener;
import org.glassfish.shoal.gms.mgmt.ClusterViewManager;
import org.glassfish.shoal.gms.mgmt.ConfigConstants;
import org.glassfish.shoal.gms.mgmt.HealthMonitor;
import org.glassfish.shoal.gms.mgmt.MasterNode;
import org.glassfish.shoal.gms.mgmt.transport.AbstractNetworkManager;
import org.glassfish.shoal.gms.mgmt.transport.Message;
import org.glassfish.shoal.gms.mgmt.transport.MessageEvent;
import org.glassfish.shoal.gms.mgmt.transport.MessageIOException;
import org.glassfish.shoal.gms.mgmt.transport.MessageImpl;
import org.glassfish.shoal.gms.mgmt.transport.MessageListener;
import org.glassfish.shoal.gms.mgmt.transport.NetworkManager;
import org.glassfish.shoal.gms.mgmt.transport.NetworkUtility;

public class ClusterManager
implements MessageListener {
    private static final Logger LOG = GMSLogDomain.getLogger("ShoalLogger");
    private MasterNode masterNode = null;
    private ClusterViewManager clusterViewManager = null;
    private HealthMonitor healthMonitor = null;
    private NetworkManager netManager = null;
    private String groupName = null;
    private String instanceName = null;
    private String bindInterfaceAddress = null;
    private volatile boolean started = false;
    private volatile boolean stopped = true;
    private boolean loopbackMessages = false;
    private final Object closeLock = new Object();
    private SystemAdvertisement systemAdv = null;
    private static final String NODEADV = "NAD";
    private Map<String, String> identityMap;
    private static final String APPMESSAGE = "APPMESSAGE";
    private List<ClusterMessageListener> cmListeners;
    private volatile boolean stopping = false;
    final Object MASTERBYFORCELOCK = new Object();
    private final String memberType;
    final String gmsContextProviderTransport;

    public ClusterManager(String groupName, String instanceName, Map<String, String> identityMap, Map props, List<ClusterViewEventListener> viewListeners, List<ClusterMessageListener> messageListeners) throws GMSException {
        this.memberType = identityMap.get(CustomTagNames.MEMBER_TYPE.toString());
        this.groupName = groupName;
        this.instanceName = instanceName;
        this.loopbackMessages = this.isLoopBackEnabled(props);
        this.gmsContextProviderTransport = Utility.getStringProperty("SHOAL_GROUP_COMMUNICATION_PROVIDER", GMSConstants.GROUP_COMMUNICATION_PROVIDER, props);
        this.netManager = this.getNetworkManager(this.gmsContextProviderTransport);
        LOG.config("instantiated following NetworkManager implementation:" + this.netManager.getClass().getName());
        this.identityMap = identityMap;
        try {
            this.netManager.initialize(groupName, instanceName, props);
            this.netManager.start();
        }
        catch (IOException ioe) {
            throw new GMSException("initialization failure", (Throwable)ioe);
        }
        catch (IllegalStateException ise) {
            throw new GMSException("initialization failure", (Throwable)ise);
        }
        if (props != null && !props.isEmpty()) {
            this.bindInterfaceAddress = (String)props.get(ConfigConstants.BIND_INTERFACE_ADDRESS.toString());
        }
        this.systemAdv = ClusterManager.createSystemAdv(this.netManager.getLocalPeerID(), instanceName, identityMap, this.bindInterfaceAddress);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Instance ID :" + String.valueOf(this.getSystemAdvertisement().getID()));
        }
        if (this.isWatchdog()) {
            this.clusterViewManager = null;
            this.masterNode = null;
        } else {
            this.clusterViewManager = new ClusterViewManager(this.getSystemAdvertisement(), this, viewListeners);
            this.masterNode = new MasterNode(this, this.getDiscoveryTimeout(props), 1, props);
        }
        this.healthMonitor = new HealthMonitor(this, this.getFailureDetectionTimeout(props), this.getFailureDetectionRetries(props), this.getVerifyFailureTimeout(props), this.getFailureDetectionTcpRetransmitTimeout(props), this.getFailureDetectionTcpRetransmitPort(props));
        this.cmListeners = messageListeners;
    }

    public boolean isWatchdog() {
        return GroupManagementService.MemberType.WATCHDOG.toString().equals(this.memberType);
    }

    private boolean isLoopBackEnabled(Map props) {
        boolean LOOPBACK_DEFAULT = false;
        return Utility.getBooleanProperty(ConfigConstants.LOOPBACK.toString(), LOOPBACK_DEFAULT, props);
    }

    private long getDiscoveryTimeout(Map props) {
        long DISCOVERY_TIMEOUT_DEFAULT = 5000L;
        return Utility.getLongProperty(ConfigConstants.DISCOVERY_TIMEOUT.toString(), DISCOVERY_TIMEOUT_DEFAULT, props);
    }

    private long getFailureDetectionTimeout(Map props) {
        long DEFAULT_FAILURE_DETECTION_TIMEOUT = 3000L;
        return Utility.getLongProperty(ConfigConstants.FAILURE_DETECTION_TIMEOUT.toString(), DEFAULT_FAILURE_DETECTION_TIMEOUT, props);
    }

    private int getFailureDetectionRetries(Map props) {
        int DEFAULT_FAILURE_RETRY = 3;
        return Utility.getIntProperty(ConfigConstants.FAILURE_DETECTION_RETRIES.toString(), DEFAULT_FAILURE_RETRY, props);
    }

    private long getFailureDetectionTcpRetransmitTimeout(Map props) {
        long DEFAULT_FAIL_TCP_TIMEOUT = 10000L;
        return Utility.getLongProperty(ConfigConstants.FAILURE_DETECTION_TCP_RETRANSMIT_TIMEOUT.toString(), DEFAULT_FAIL_TCP_TIMEOUT, props);
    }

    private int getFailureDetectionTcpRetransmitPort(Map props) {
        int DEFAULT_FAIL_TCP_PORT = 9000;
        return Utility.getIntProperty(ConfigConstants.FAILURE_DETECTION_TCP_RETRANSMIT_PORT.toString(), DEFAULT_FAIL_TCP_PORT, props);
    }

    private long getVerifyFailureTimeout(Map props) {
        long DEFAULT_VERIFY_TIMEOUT = 2000L;
        return Utility.getLongProperty(ConfigConstants.FAILURE_VERIFICATION_TIMEOUT.toString(), DEFAULT_VERIFY_TIMEOUT, props);
    }

    public void addClusteMessageListener(ClusterMessageListener listener) {
        this.cmListeners.add(listener);
    }

    public void removeClusterViewEventListener(ClusterMessageListener listener) {
        this.cmListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(boolean isClusterShutdown) {
        if (!this.stopped) {
            this.stopping = true;
            this.healthMonitor.stop(isClusterShutdown);
            if (!this.isWatchdog()) {
                this.masterNode.stop();
            }
            this.netManager.removeMessageListener(this);
            try {
                this.netManager.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.stopped = true;
            Object object = this.closeLock;
            synchronized (object) {
                this.closeLock.notifyAll();
            }
        }
    }

    public synchronized void start() {
        if (!this.started) {
            this.netManager.addMessageListener(this);
            if (!this.isWatchdog()) {
                this.masterNode.start();
            }
            this.healthMonitor.start();
            this.started = true;
            this.stopped = false;
        }
    }

    public NetworkManager getNetworkManager(String transport) {
        if (this.netManager == null) {
            this.netManager = AbstractNetworkManager.getInstance(transport);
        }
        return this.netManager;
    }

    public NetworkManager getNetworkManager() {
        return this.getNetworkManager(this.gmsContextProviderTransport);
    }

    public MasterNode getMasterNode() {
        return this.masterNode;
    }

    public HealthMonitor getHealthMonitor() {
        return this.healthMonitor;
    }

    public ClusterViewManager getClusterViewManager() {
        return this.clusterViewManager;
    }

    public PeerID getPeerID() {
        return this.netManager.getLocalPeerID();
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public boolean isMaster() {
        return this.clusterViewManager.isMaster() && this.masterNode.isMasterAssigned();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean send(PeerID peerid, Serializable msg, boolean validatePeeridInView) throws IOException, MemberNotInViewException {
        boolean sent = false;
        if (this.stopping) return sent;
        MessageImpl message = new MessageImpl(1);
        message.addMessageElement(NODEADV, this.systemAdv);
        message.addMessageElement(APPMESSAGE, msg);
        if (peerid == null) {
            LOG.log(Level.FINER, "Broadcasting Message");
            sent = this.netManager.broadcast(message);
            if (sent) return sent;
            LOG.log(Level.WARNING, "mgmt.clustermanager.broadcast.failed", new Object[]{message});
            return sent;
        }
        if (validatePeeridInView && !this.getClusterViewManager().containsKey(peerid, true)) {
            LOG.log(Level.INFO, "mgmt.clustermanager.send.membernotinview", new Object[]{peerid.toString()});
            throw new MemberNotInViewException("Member " + String.valueOf(peerid) + " is not in the View anymore. Hence not performing sendMessage operation");
        }
        if (LOG.isLoggable(Level.FINE) && validatePeeridInView) {
            LOG.fine("ClusterManager.send : Cluster View contains " + peerid.toString());
        }
        if (sent = this.netManager.send(peerid, message)) return sent;
        LOG.log(Level.WARNING, "mgmt.clustermanager.send.failed", new Object[]{message, peerid});
        return sent;
    }

    public boolean send(PeerID peerid, Serializable msg) throws IOException, MemberNotInViewException {
        return this.send(peerid, msg, true);
    }

    @Override
    public void receiveMessageEvent(MessageEvent event) throws MessageIOException {
        if (this.started && !this.stopping) {
            try {
                Message msg = event.getMessage();
                if (msg == null) {
                    LOG.log(Level.WARNING, "mgmt.clustermanager.nullmessage");
                    return;
                }
                LOG.log(Level.FINEST, "ClusterManager:Received a AppMessage ");
                Object msgElement = msg.getMessageElement(NODEADV);
                if (msgElement == null) {
                    LOG.log(Level.WARNING, "mgmt.unknownMessage");
                    return;
                }
                if (!(msgElement instanceof SystemAdvertisement)) {
                    LOG.log(Level.WARNING, "mgmt.unknownMessage");
                    return;
                }
                SystemAdvertisement adv = (SystemAdvertisement)msgElement;
                PeerID srcPeerID = adv.getID();
                if (!this.loopbackMessages && srcPeerID.equals(this.getPeerID())) {
                    LOG.log(Level.FINEST, "CLUSTERMANAGER:Discarding loopback message");
                    return;
                }
                msgElement = msg.getMessageElement(APPMESSAGE);
                if (msgElement != null) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.log(Level.FINEST, "ClusterManager: Notifying APPMessage Listeners of " + msgElement.toString() + "and adv = " + adv.getName());
                    }
                    this.notifyMessageListeners(adv, msgElement);
                }
            }
            catch (Throwable e) {
                LOG.log(Level.WARNING, e.getLocalizedMessage());
            }
        }
    }

    @Override
    public int getType() {
        return 1;
    }

    private void notifyMessageListeners(SystemAdvertisement senderSystemAdvertisement, Object appMessage) {
        for (ClusterMessageListener listener : this.cmListeners) {
            listener.handleClusterMessage(senderSystemAdvertisement, appMessage);
        }
    }

    public SystemAdvertisement getSystemAdvertisementForMember(PeerID id) {
        return this.clusterViewManager.get(id);
    }

    public SystemAdvertisement getSystemAdvertisement() {
        if (this.systemAdv == null) {
            this.systemAdv = ClusterManager.createSystemAdv(this.netManager.getLocalPeerID(), this.instanceName, this.identityMap, this.bindInterfaceAddress);
        }
        return this.systemAdv;
    }

    private static synchronized SystemAdvertisement createSystemAdv(PeerID peerID, String name, Map<String, String> customTags, String bindInterfaceAddress) {
        if (peerID == null) {
            throw new IllegalArgumentException("peer id can not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("instance name can not be null");
        }
        SystemAdvertisementImpl sysAdv = new SystemAdvertisementImpl();
        sysAdv.setID(peerID);
        sysAdv.setName(name);
        sysAdv.setOSName(System.getProperty("os.name"));
        sysAdv.setOSVersion(System.getProperty("os.version"));
        sysAdv.setOSArch(System.getProperty("os.arch"));
        sysAdv.setHWArch(System.getProperty("HOSTTYPE", System.getProperty("os.arch")));
        sysAdv.setHWVendor(System.getProperty("java.vm.vendor"));
        sysAdv.setCustomTags(customTags);
        ClusterManager.setBindInterfaceAddress(sysAdv, bindInterfaceAddress);
        return sysAdv;
    }

    private static void setBindInterfaceAddress(SystemAdvertisement sysAdv, String bindInterfaceAddress) {
        String bindInterfaceEndpointAddress = null;
        String TCP_SCHEME = "tcp://";
        String PORT = ":4000";
        if (bindInterfaceAddress != null && !bindInterfaceAddress.equals("")) {
            InetAddress inetAddress = null;
            try {
                inetAddress = NetworkUtility.resolveBindInterfaceName(bindInterfaceAddress);
                bindInterfaceEndpointAddress = inetAddress instanceof Inet6Address ? "tcp://[" + bindInterfaceAddress + "]:4000" : "tcp://" + bindInterfaceAddress + ":4000";
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "mgmt.clustermanager.invalidbindinterfaceaddress", new Object[]{ConfigConstants.BIND_INTERFACE_ADDRESS.toString(), bindInterfaceAddress});
            }
        }
        if (bindInterfaceEndpointAddress != null) {
            if (LOG.isLoggable(Level.CONFIG)) {
                LOG.config("Configured bindInterfaceEndpointAddress URI " + bindInterfaceEndpointAddress + " using property " + ConfigConstants.BIND_INTERFACE_ADDRESS.toString() + " value=" + bindInterfaceAddress);
            }
            sysAdv.addEndpointAddress(bindInterfaceEndpointAddress);
        } else {
            List<InetAddress> localAddressList = NetworkUtility.getAllLocalAddresses();
            for (InetAddress inetAddress : localAddressList) {
                bindInterfaceEndpointAddress = inetAddress instanceof Inet6Address ? "tcp://[" + inetAddress.getHostAddress() + "]:4000" : "tcp://" + inetAddress.getHostAddress() + ":4000";
                sysAdv.addEndpointAddress(bindInterfaceEndpointAddress);
            }
        }
    }

    public String getNodeState(PeerID peerID, long threshold, long timeout) {
        return this.getHealthMonitor().getMemberState(peerID, threshold, timeout);
    }

    public PeerID getID(String name) {
        return this.netManager.getPeerID(name);
    }

    boolean isStopping() {
        return this.stopping;
    }

    public void takeOverMasterRole() {
        this.masterNode.takeOverMasterRole();
        this.waitFor(2000L);
    }

    public void setClusterStopping() {
        this.masterNode.setClusterStopping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(long msec) {
        try {
            Object object = this.MASTERBYFORCELOCK;
            synchronized (object) {
                this.MASTERBYFORCELOCK.wait(msec);
            }
        }
        catch (InterruptedException intr) {
            Thread.interrupted();
            LOG.log(Level.FINER, "Thread interrupted", intr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNewMaster() {
        Object object = this.MASTERBYFORCELOCK;
        synchronized (object) {
            this.MASTERBYFORCELOCK.notifyAll();
        }
    }

    public void reportJoinedAndReadyState() {
        this.healthMonitor.reportJoinedAndReadyState();
    }

    public void groupStartup(GMSConstants.groupStartupState startupState, List<String> memberTokens) {
        this.getMasterNode().groupStartup(startupState, memberTokens);
    }

    public boolean isGroupStartup() {
        return this.getMasterNode().isGroupStartup();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean isDiscoveryInProgress() {
        return this.masterNode.isDiscoveryInProgress();
    }
}

