/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.internal;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Response;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.internal.util.Producer;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.model.RuntimeResource;
import org.glassfish.jersey.server.model.internal.ModelHelper;
import org.glassfish.jersey.server.model.internal.ModelProcessorUtil;
import org.glassfish.jersey.server.mvc.Template;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.internal.ImplicitViewable;
import org.glassfish.jersey.server.mvc.internal.TemplateInflector;
import org.glassfish.jersey.server.mvc.internal.l10n.LocalizationMessages;

class TemplateModelProcessor
implements ModelProcessor {
    private static final String IMPLICIT_VIEW_PATH_PARAMETER = "implicit-view-path-parameter";
    private static final String IMPLICIT_VIEW_PATH_PARAMETER_TEMPLATE = "{implicit-view-path-parameter}";
    private final Provider<ResourceContext> resourceContextProvider;
    private final Provider<ExtendedUriInfo> extendedUriInfoProvider;
    private final Provider<ConfiguredValidator> validatorProvider;

    @Inject
    TemplateModelProcessor(Provider<ResourceContext> resourceContextProvider, Provider<ConfiguredValidator> validatorProvider, Provider<ExtendedUriInfo> extendedUriInfoProvider) {
        this.resourceContextProvider = resourceContextProvider;
        this.validatorProvider = validatorProvider;
        this.extendedUriInfoProvider = extendedUriInfoProvider;
    }

    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        return this.processModel(resourceModel, false);
    }

    public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
        return this.processModel(subResourceModel, true);
    }

    private ResourceModel processModel(ResourceModel resourceModel, boolean subResourceModel) {
        ResourceModel.Builder newModelBuilder = this.processTemplateAnnotatedInvocables(resourceModel, subResourceModel);
        for (RuntimeResource resource : resourceModel.getRuntimeResourceModel().getRuntimeResources()) {
            ModelProcessorUtil.enhanceResource((RuntimeResource)resource, (ResourceModel.Builder)newModelBuilder, this.getEnhancingMethods(resource), (boolean)false);
        }
        return newModelBuilder.build();
    }

    private ResourceModel.Builder processTemplateAnnotatedInvocables(ResourceModel resourceModel, boolean subResourceModel) {
        ResourceModel.Builder modelBuilder = new ResourceModel.Builder(subResourceModel);
        for (Resource resource : resourceModel.getResources()) {
            Resource newResource = this.processResource(resource);
            modelBuilder.addResource(newResource);
        }
        return modelBuilder;
    }

    private Resource processResource(Resource resource) {
        Resource.Builder resourceBuilder = Resource.builder((String)resource.getPath());
        for (ResourceMethod resourceMethod : resource.getResourceMethods()) {
            ResourceMethod.Builder builder = resourceBuilder.addMethod(resourceMethod);
            if (!resourceMethod.getInvocable().getHandlingMethod().isAnnotationPresent(Template.class)) continue;
            builder.routingResponseType(Viewable.class);
        }
        if (resource.getResourceLocator() != null) {
            resourceBuilder.addMethod(resource.getResourceLocator());
        }
        for (Resource child : resource.getChildResources()) {
            resourceBuilder.addChildResource(this.processResource(child));
        }
        return resourceBuilder.build();
    }

    private List<ModelProcessorUtil.Method> getEnhancingMethods(RuntimeResource runtimeResource) {
        final ArrayList<ModelProcessorUtil.Method> newMethods = new ArrayList<ModelProcessorUtil.Method>();
        for (final Resource resource : runtimeResource.getResources()) {
            for (Class handlerClass : resource.getHandlerClasses()) {
                this.createEnhancingMethods(handlerClass, null, newMethods);
            }
            if (resource.getHandlerClasses().isEmpty() && resource.getHandlerInstances().isEmpty()) {
                for (String resourceName : resource.getNames()) {
                    Class resourceClass = (Class)AccessController.doPrivileged(ReflectionHelper.classForNamePA((String)resourceName));
                    if (resourceClass == null) continue;
                    this.createEnhancingMethods(resourceClass, null, newMethods);
                }
            }
            Errors.process((Producer)new Producer<Void>(){

                public Void call() {
                    for (Object handlerInstance : resource.getHandlerInstances()) {
                        Class<?> handlerInstanceClass = handlerInstance.getClass();
                        if (!resource.getHandlerClasses().contains(handlerInstanceClass)) {
                            TemplateModelProcessor.this.createEnhancingMethods(handlerInstanceClass, handlerInstance, newMethods);
                            continue;
                        }
                        Errors.warning((Object)resource, (String)LocalizationMessages.TEMPLATE_HANDLER_ALREADY_ENHANCED(handlerInstanceClass));
                    }
                    return null;
                }
            });
        }
        return newMethods;
    }

    private void createEnhancingMethods(Class<?> resourceClass, Object resourceInstance, List<ModelProcessorUtil.Method> newMethods) {
        Template template = resourceClass.getAnnotation(Template.class);
        if (template != null) {
            Class annotatedResourceClass = ModelHelper.getAnnotatedResourceClass(resourceClass);
            List produces = MediaTypes.createQualitySourceMediaTypes((Produces)annotatedResourceClass.getAnnotation(Produces.class));
            List consumes = MediaTypes.createFrom((Consumes)annotatedResourceClass.getAnnotation(Consumes.class));
            TemplateInflectorImpl inflector = new TemplateInflectorImpl(template.name(), resourceClass, resourceInstance);
            newMethods.add(new ModelProcessorUtil.Method("GET", consumes, produces, (Inflector)inflector));
            newMethods.add(new ModelProcessorUtil.Method(IMPLICIT_VIEW_PATH_PARAMETER_TEMPLATE, "GET", consumes, produces, (Inflector)inflector));
        }
    }

    private class TemplateInflectorImpl
    implements TemplateInflector,
    Inflector<ContainerRequestContext, Response> {
        private final String templateName;
        private final Class<?> resourceClass;
        private final Object resourceInstance;
        private Class<?> modelClass;

        private TemplateInflectorImpl(String templateName, Class<?> resourceClass, Object resourceInstance) {
            this.templateName = templateName;
            this.resourceClass = resourceClass;
            this.resourceInstance = resourceInstance;
        }

        public Response apply(ContainerRequestContext requestContext) {
            List<String> templateNames = this.getTemplateNames(requestContext);
            Object model = this.getModel((ExtendedUriInfo)TemplateModelProcessor.this.extendedUriInfoProvider.get());
            ConfiguredValidator validator = (ConfiguredValidator)TemplateModelProcessor.this.validatorProvider.get();
            if (validator != null) {
                validator.validateResourceAndInputParams(model, null, null);
            }
            return Response.ok().entity((Object)new ImplicitViewable(templateNames, model, this.resourceClass)).build();
        }

        @Override
        public Class<?> getModelClass() {
            return this.modelClass;
        }

        private Object setModelClass(Object model) {
            if (this.modelClass == null) {
                this.modelClass = model.getClass();
            }
            return model;
        }

        private Object getModel(ExtendedUriInfo extendedUriInfo) {
            List matchedResources = extendedUriInfo.getMatchedResources();
            if (this.resourceInstance != null) {
                return this.setModelClass(this.resourceInstance);
            }
            if (matchedResources.size() > 1) {
                return this.setModelClass(matchedResources.get(1));
            }
            return this.setModelClass(((ResourceContext)TemplateModelProcessor.this.resourceContextProvider.get()).getResource(this.resourceClass));
        }

        private List<String> getTemplateNames(ContainerRequestContext requestContext) {
            RuntimeResource lastMatchedRuntimeResource;
            Resource lastMatchedResource;
            String path;
            ExtendedUriInfo uriInfo;
            List matchedRuntimeResources;
            ArrayList<String> templateNames = new ArrayList<String>();
            String pathTemplate = (String)requestContext.getUriInfo().getPathParameters().getFirst((Object)TemplateModelProcessor.IMPLICIT_VIEW_PATH_PARAMETER);
            if (pathTemplate != null) {
                templateNames.add(pathTemplate);
            }
            if (this.templateName != null && !"".equals(this.templateName)) {
                templateNames.add(this.templateName);
            }
            if ((matchedRuntimeResources = (uriInfo = (ExtendedUriInfo)TemplateModelProcessor.this.extendedUriInfoProvider.get()).getMatchedRuntimeResources()).size() > 1 && (path = (lastMatchedResource = (Resource)(lastMatchedRuntimeResource = (RuntimeResource)matchedRuntimeResources.get(0)).getResources().get(0)).getPath()) != null && !TemplateModelProcessor.IMPLICIT_VIEW_PATH_PARAMETER_TEMPLATE.equals(path)) {
                path = path.charAt(0) == '/' ? path.substring(1, path.length()) : path;
                templateNames.add(path);
            }
            if (templateNames.isEmpty()) {
                templateNames.add("index");
            }
            return templateNames;
        }
    }
}

