/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util.fileStreamer;

import com.sun.jsftemplating.util.FileUtil;
import com.sun.jsftemplating.util.LogUtil;
import com.sun.jsftemplating.util.Tuple;
import com.sun.jsftemplating.util.Util;
import com.sun.jsftemplating.util.fileStreamer.ContentSource;
import com.sun.jsftemplating.util.fileStreamer.Context;
import com.sun.jsftemplating.util.fileStreamer.ResourceContentSource;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletContext;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileStreamer {
    public static final String CONTENT_SOURCES = "contentSources";
    private static final String STREAMER_INST = "__jsft_FileStreamer";
    private static final String FS_CONTENT_SOURCES = "__jsft_FS_Sources";
    private static Map<String, String> mimeTypes = new HashMap<String, String>(120);
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";

    private FileStreamer(FacesContext ctx) {
        try {
            List<Tuple> entries = FileUtil.getJarResources(ctx, "/META-INF/jsftemplating/fileStreamer.properties", new String[0]);
            for (Tuple tuple : entries) {
                Properties props = new Properties();
                JarFile jarFile = (JarFile)tuple.getElement(0);
                InputStream is = jarFile.getInputStream((JarEntry)tuple.getElement(1));
                props.load(is);
                is.close();
                jarFile.close();
                this.processFileStreamerProperties(props);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(FileStreamer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private FileStreamer() {
    }

    public static FileStreamer getFileStreamer(FacesContext ctx) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        FileStreamer streamer = null;
        if (ctx != null) {
            streamer = (FileStreamer)ctx.getExternalContext().getApplicationMap().get(STREAMER_INST);
            if (streamer == null) {
                streamer = new FileStreamer(ctx);
                ctx.getExternalContext().getApplicationMap().put(STREAMER_INST, streamer);
            }
        } else {
            streamer = new FileStreamer();
        }
        return streamer;
    }

    public static FileStreamer getFileStreamer(ServletContext ctx) {
        FileStreamer streamer = null;
        if (ctx != null) {
            streamer = (FileStreamer)ctx.getAttribute("__jsft_FileStreamersrvlt");
            if (streamer == null) {
                streamer = new FileStreamer();
                ctx.setAttribute("__jsft_FileStreamersrvlt", (Object)streamer);
            }
        } else {
            streamer = new FileStreamer();
        }
        return streamer;
    }

    public void registerContentSource(String className) {
        if (className == null || className.trim().equals("")) {
            return;
        }
        Class cls = null;
        try {
            cls = Util.loadClass(className, className);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
        this.registerContentSource(cls);
    }

    public void registerContentSource(Class cls) {
        ContentSource source = null;
        try {
            source = (ContentSource)cls.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
        this.registerContentSource(source);
    }

    public void registerContentSource(ContentSource source) {
        this.getContentSources(null).put(source.getId(), source);
    }

    private Map<String, ContentSource> getContentSources(FacesContext ctx) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        Map<String, ResourceContentSource> sources = null;
        if (ctx != null) {
            sources = (Map)ctx.getExternalContext().getApplicationMap().get(FS_CONTENT_SOURCES);
        }
        if (sources == null) {
            sources = new HashMap();
            sources.put("resourceCS", new ResourceContentSource());
            if (ctx != null) {
                ctx.getExternalContext().getApplicationMap().put(FS_CONTENT_SOURCES, sources);
            }
        }
        return sources;
    }

    public ContentSource getContentSource(String id) {
        return this.getContentSources(null).get(id);
    }

    public void streamContent(Context ctx) throws IOException {
        ContentSource source = ctx.getContentSource();
        if (ctx.hasPermission(source)) {
            this.writeContent(source, ctx);
        } else {
            ctx.sendError(404, "File Not Found");
        }
        source.cleanUp(ctx);
    }

    protected void processFileStreamerProperties(Properties props) {
        String contentSourcesProp = (String)props.get(CONTENT_SOURCES);
        if (contentSourcesProp != null && contentSourcesProp.length() > 0) {
            String[] contentSources;
            for (String cs : contentSources = contentSourcesProp.split(",")) {
                cs = cs.trim();
                LogUtil.config("Registering ContentSource " + cs);
                this.registerContentSource(cs);
            }
        }
    }

    protected void writeContent(ContentSource source, Context context) throws IOException {
        InputStream in = source.getInputStream(context);
        if (in == null) {
            throw new FileNotFoundException();
        }
        OutputStream out = context.getOutputStream();
        BufferedInputStream stream = new BufferedInputStream(in);
        context.writeHeader(source);
        byte[] buf = new byte[512];
        int read = ((InputStream)stream).read(buf, 0, 512);
        while (read != -1) {
            out.write(buf, 0, read);
            read = ((InputStream)stream).read(buf, 0, 512);
        }
        ((InputStream)stream).close();
    }

    public static String getMimeType(String extension) {
        String mimeType = null;
        extension = extension.toLowerCase();
        Object context = FacesContext.getCurrentInstance().getExternalContext().getContext();
        if (context instanceof ServletContext) {
            mimeType = ((ServletContext)context).getMimeType(extension);
        }
        if (mimeType == null) {
            mimeType = mimeTypes.get(extension);
        }
        return mimeType;
    }

    public static String getDefaultMimeType() {
        return DEFAULT_CONTENT_TYPE;
    }

    static {
        mimeTypes.put("aif", "audio/x-aiff");
        mimeTypes.put("aifc", "audio/x-aiff");
        mimeTypes.put("aiff", "audio/x-aiff");
        mimeTypes.put("asc", "text/plain");
        mimeTypes.put("asf", "application/x-ms-asf");
        mimeTypes.put("asx", "application/x-ms-asf");
        mimeTypes.put("au", "audio/basic");
        mimeTypes.put("avi", "video/x-msvideo");
        mimeTypes.put("bin", DEFAULT_CONTENT_TYPE);
        mimeTypes.put("bmp", "image/bmp");
        mimeTypes.put("bwf", "audio/wav");
        mimeTypes.put("bz2", "application/x-bzip2");
        mimeTypes.put("c", "text/plain");
        mimeTypes.put("cc", "text/plain");
        mimeTypes.put("cdda", "audio/x-aiff");
        mimeTypes.put("class", DEFAULT_CONTENT_TYPE);
        mimeTypes.put("com", DEFAULT_CONTENT_TYPE);
        mimeTypes.put("cpp", "text/plain");
        mimeTypes.put("cpr", "image/cpr");
        mimeTypes.put("css", "text/css");
        mimeTypes.put("doc", "application/msword");
        mimeTypes.put("dot", "application/msword");
        mimeTypes.put("dtd", "text/xml");
        mimeTypes.put("ear", "application/zip");
        mimeTypes.put("exe", DEFAULT_CONTENT_TYPE);
        mimeTypes.put("flc", "video/flc");
        mimeTypes.put("fm", "application/x-maker");
        mimeTypes.put("frame", "application/x-maker");
        mimeTypes.put("frm", "application/x-maker");
        mimeTypes.put("h", "text/plain");
        mimeTypes.put("hh", "text/plain");
        mimeTypes.put("hpp", "text/plain");
        mimeTypes.put("hqx", "application/mac-binhex40");
        mimeTypes.put("htm", "text/html");
        mimeTypes.put("html", "text/html");
        mimeTypes.put("gif", "image/gif");
        mimeTypes.put("gz", "application/x-gunzip");
        mimeTypes.put("ico", "image/x-icon");
        mimeTypes.put("iso", DEFAULT_CONTENT_TYPE);
        mimeTypes.put("jar", "application/zip");
        mimeTypes.put("java", "text/plain");
        mimeTypes.put("jnlp", "application/x-java-jnlp-file");
        mimeTypes.put("jpeg", "image/jpeg");
        mimeTypes.put("jpe", "image/jpeg");
        mimeTypes.put("jpg", "image/jpeg");
        mimeTypes.put("js", "application/javascript");
        mimeTypes.put("jsf", "text/plain");
        mimeTypes.put("m3u", "audio/x-mpegurl");
        mimeTypes.put("maker", "application/x-maker");
        mimeTypes.put("mid", "audio/midi");
        mimeTypes.put("midi", "audio/midi");
        mimeTypes.put("mim", "application/mime");
        mimeTypes.put("mime", "application/mime");
        mimeTypes.put("mov", "video/quicktime");
        mimeTypes.put("mp2", "audio/mpeg");
        mimeTypes.put("mp3", "audio/mpeg");
        mimeTypes.put("mp4", "video/mpeg4");
        mimeTypes.put("mpa", "video/mpeg");
        mimeTypes.put("mpe", "video/mpeg");
        mimeTypes.put("mpeg", "video/mpeg");
        mimeTypes.put("mpg", "video/mpeg");
        mimeTypes.put("mpga", "audio/mpeg");
        mimeTypes.put("mpm", "video/mpeg");
        mimeTypes.put("mpv", "video/mpeg");
        mimeTypes.put("pdf", "application/pdf");
        mimeTypes.put("pic", "image/x-pict");
        mimeTypes.put("pict", "image/x-pict");
        mimeTypes.put("pct", "image/x-pict");
        mimeTypes.put("pl", "application/x-perl");
        mimeTypes.put("png", "image/png");
        mimeTypes.put("pnm", "image/x-portable-anymap");
        mimeTypes.put("pbm", "image/x-portable-bitmap");
        mimeTypes.put("ppm", "image/x-portable-pixmap");
        mimeTypes.put("ps", "application/postscript");
        mimeTypes.put("ppt", "application/vnd.ms-powerpoint");
        mimeTypes.put("qt", "video/quicktime");
        mimeTypes.put("ra", "application/vnd.rn-realaudio");
        mimeTypes.put("rar", "application/zip");
        mimeTypes.put("rf", "application/vnd.rn-realflash");
        mimeTypes.put("ra", "audio/vnd.rn-realaudio");
        mimeTypes.put("ram", "audio/x-pn-realaudio");
        mimeTypes.put("rm", "application/vnd.rn-realmedia");
        mimeTypes.put("rmm", "audio/x-pn-realaudio");
        mimeTypes.put("rsml", "application/vnd.rn-rsml");
        mimeTypes.put("rtf", "text/rtf");
        mimeTypes.put("rv", "video/vnd.rn-realvideo");
        mimeTypes.put("spl", "application/futuresplash");
        mimeTypes.put("snd", "audio/basic");
        mimeTypes.put("ssm", "application/smil");
        mimeTypes.put("swf", "application/x-shockwave-flash");
        mimeTypes.put("tar", "application/x-tar");
        mimeTypes.put("tgz", "application/x-gtar");
        mimeTypes.put("tif", "image/tiff");
        mimeTypes.put("tiff", "image/tiff");
        mimeTypes.put("txt", "text/plain");
        mimeTypes.put("ulw", "audio/basic");
        mimeTypes.put("war", "application/zip");
        mimeTypes.put("wav", "audio/x-wav");
        mimeTypes.put("wax", "application/x-ms-wax");
        mimeTypes.put("wm", "application/x-ms-wm");
        mimeTypes.put("wma", "application/x-ms-wma");
        mimeTypes.put("wml", "text/wml");
        mimeTypes.put("wmw", "application/x-ms-wmw");
        mimeTypes.put("wrd", "application/msword");
        mimeTypes.put("wvx", "application/x-ms-wvx");
        mimeTypes.put("xbm", "image/x-xbitmap");
        mimeTypes.put("xpm", "image/image/x-xpixmap");
        mimeTypes.put("xml", "text/xml");
        mimeTypes.put("xsl", "text/xml");
        mimeTypes.put("xls", "application/vnd.ms-excel");
        mimeTypes.put("zip", "application/zip");
        mimeTypes.put("z", "application/x-compress");
        mimeTypes.put("Z", "application/x-compress");
    }
}

