/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.db;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.derby.iapi.sql.compile.OptTrace;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.impl.sql.compile.DefaultOptTrace;

public class OptimizerTrace {
    public static void setOptimizerTrace(boolean bl) {
        DefaultOptTrace defaultOptTrace = bl ? new DefaultOptTrace() : null;
        OptimizerTrace.setOptimizerTracer(defaultOptTrace);
    }

    public static void setOptimizerTracer(OptTrace optTrace) {
        try {
            ConnectionUtil.getCurrentLCC().setOptimizerTracer(optTrace);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static OptTrace getOptimizerTracer() {
        try {
            return ConnectionUtil.getCurrentLCC().getOptimizerTracer();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getOptimizerTraceOutput() {
        String string = null;
        try {
            LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
            OptTrace optTrace = languageConnectionContext.getOptimizerTracer();
            if (optTrace != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                optTrace.printToWriter(printWriter);
                printWriter.flush();
                stringWriter.flush();
                string = stringWriter.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }
}

