/*
 * Decompiled with CFR 0.152.
 */
package jakarta.security.jacc;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.Subject;

public interface Policy {
    default public boolean implies(Permission permissionToBeChecked, Subject subject) {
        if (this.isExcluded(permissionToBeChecked)) {
            return false;
        }
        if (this.isUnchecked(permissionToBeChecked)) {
            return true;
        }
        return this.impliesByRole(permissionToBeChecked, subject);
    }

    default public boolean isExcluded(Permission permissionToBeChecked) {
        throw new UnsupportedOperationException();
    }

    default public boolean isUnchecked(Permission permissionToBeChecked) {
        throw new UnsupportedOperationException();
    }

    default public boolean impliesByRole(Permission permissionToBeChecked, Subject subject) {
        throw new UnsupportedOperationException();
    }

    public PermissionCollection getPermissionCollection(Subject var1);

    default public boolean implies(Permission permissionToBeChecked) {
        return this.implies(permissionToBeChecked, Collections.emptySet());
    }

    default public boolean implies(Permission permissionToBeChecked, Set<Principal> principals) {
        Subject subject = new Subject();
        subject.getPrincipals().addAll(principals);
        return this.implies(permissionToBeChecked, subject);
    }

    default public void refresh() {
    }
}

