/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.common.configurable.LruCache;
import io.helidon.common.configurable.LruCacheConfig;
import io.helidon.config.PropertiesFilter;
import jakarta.annotation.Priority;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.ConfigSource;

@Priority(value=300)
class MpEnvironmentVariablesSource
implements ConfigSource {
    static final int MY_DEFAULT_ORDINAL = 300;
    private static final Pattern DISALLOWED_CHARS = Pattern.compile("[^a-zA-Z0-9_]");
    private static final String UNDERSCORE = "_";
    private static final int MAX_CACHE_SIZE = 10000;
    private final Map<String, String> env = Map.copyOf(PropertiesFilter.create(System.getProperties()).filter(System.getenv()));
    private final LruCache<String, Cached> cache;

    MpEnvironmentVariablesSource() {
        this(10000);
    }

    MpEnvironmentVariablesSource(int cacheSize) {
        this.cache = ((LruCacheConfig.Builder)LruCache.builder().capacity(cacheSize)).build();
    }

    LruCache<String, Cached> cache() {
        return this.cache;
    }

    public Set<String> getPropertyNames() {
        return this.env.keySet();
    }

    public Map<String, String> getProperties() {
        return this.env;
    }

    public String getValue(String propertyName) {
        return this.cache.computeValue((Object)propertyName, () -> {
            String result = this.env.get(propertyName);
            if (null != result) {
                return Optional.of(new Cached(result));
            }
            String rule2 = MpEnvironmentVariablesSource.rule2(propertyName);
            result = this.env.get(rule2);
            if (null != result) {
                return Optional.of(new Cached(result));
            }
            String rule3 = rule2.toUpperCase();
            result = this.env.get(rule3);
            return Optional.of(new Cached(result));
        }).map(cached -> cached.value).orElse(null);
    }

    public int getOrdinal() {
        String configOrdinal = this.getValue("config_ordinal");
        if (configOrdinal == null) {
            return 300;
        }
        return super.getOrdinal();
    }

    public String getName() {
        return "Environment Variables";
    }

    public String toString() {
        return this.getName() + " (" + this.getOrdinal() + ")";
    }

    private static String rule2(String propertyName) {
        return DISALLOWED_CHARS.matcher(propertyName).replaceAll(UNDERSCORE);
    }

    private static final class Cached {
        private final String value;

        private Cached(String value) {
            this.value = value;
        }
    }
}

