/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CoordinatorImpl;
import java.util.Vector;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Coordinator;

class NestingInfo {
    CoordinatorImpl[] ancestorSeq = null;
    Vector childSet = new Vector();
    boolean removed = false;

    NestingInfo() {
    }

    NestingInfo(CoordinatorImpl[] ancestors) {
        this.ancestorSeq = (CoordinatorImpl[])ancestors.clone();
        this.removed = ancestors.length == 0;
    }

    boolean addChild(CoordinatorImpl child) {
        boolean result;
        boolean bl = result = !this.childSet.contains(child);
        if (result) {
            this.childSet.addElement(child);
        }
        return result;
    }

    boolean removeChild(CoordinatorImpl child) {
        boolean result = this.childSet.removeElement(child);
        return result;
    }

    void empty() {
        this.childSet.removeAllElements();
    }

    boolean removeFromParent(CoordinatorImpl child) {
        boolean result = true;
        if (!this.removed) {
            CoordinatorImpl parent = this.ancestorSeq[0];
            result = parent.removeChild(child);
            this.removed = true;
        }
        return result;
    }

    CoordinatorImpl getParent(boolean forgetting) {
        CoordinatorImpl result = null;
        if (this.ancestorSeq.length != 0) {
            result = this.ancestorSeq[0];
        }
        if (forgetting) {
            this.removed = true;
        }
        return result;
    }

    CoordinatorImpl getTopLevel() {
        CoordinatorImpl result = null;
        if (this.ancestorSeq.length != 0) {
            result = this.ancestorSeq[this.ancestorSeq.length - 1];
        }
        return result;
    }

    CoordinatorImpl[] getAncestors() {
        CoordinatorImpl[] result = null;
        result = (CoordinatorImpl[])this.ancestorSeq.clone();
        return result;
    }

    int numChildren() {
        return this.childSet.size();
    }

    boolean replyCheck() {
        boolean result = false;
        for (int i = 0; i < this.childSet.size() && !result; ++i) {
            CoordinatorImpl child = (CoordinatorImpl)this.childSet.elementAt(i);
            result = child.isActive();
        }
        return result;
    }

    boolean isDescendant(Coordinator other) {
        boolean result = false;
        try {
            for (int i = 0; i < this.ancestorSeq.length && !result; ++i) {
                result = this.ancestorSeq[i].is_same_transaction(other);
            }
        }
        catch (SystemException exc) {
            result = false;
        }
        return result;
    }

    void rollbackFamily() {
        while (this.childSet.size() > 0) {
            CoordinatorImpl child = (CoordinatorImpl)this.childSet.elementAt(0);
            try {
                child.rollback(true);
            }
            catch (Throwable throwable) {}
        }
    }
}

